/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.faktorips.devtools.model.IVersion;
import org.faktorips.devtools.model.util.AlphaNumericComparator;

public class DefaultVersion
implements IVersion<DefaultVersion> {
    public static final DefaultVersion EMPTY_VERSION = new DefaultVersion(null);
    private static final String DEFAULT_VERSION_STRING = "0";
    private static final Pattern QUALIFIER_PATTERN = Pattern.compile("\\d*(\\.\\d+)*");
    private final String versionString;

    public DefaultVersion(String versionString) {
        this.versionString = versionString == null || versionString.isEmpty() ? DEFAULT_VERSION_STRING : versionString;
    }

    @Override
    public int compareTo(DefaultVersion o) {
        return new AlphaNumericComparator().compare(this.versionString, o.versionString);
    }

    @Override
    public String asString() {
        return this.versionString;
    }

    @Override
    public String getUnqualifiedVersion() {
        Matcher matcher = QUALIFIER_PATTERN.matcher(this.versionString);
        if (matcher.find()) {
            String unqualified = matcher.group();
            return unqualified.isEmpty() ? EMPTY_VERSION.asString() : unqualified;
        }
        return EMPTY_VERSION.asString();
    }

    public int hashCode() {
        return Objects.hash(this.versionString);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultVersion other = (DefaultVersion)obj;
        return Objects.equals(this.versionString, other.versionString);
    }

    public String toString() {
        return "Version [" + this.versionString + "]";
    }

    @Override
    public boolean isEmptyVersion() {
        return this.equals(EMPTY_VERSION);
    }

    @Override
    public boolean isNotEmptyVersion() {
        return !this.isEmptyVersion();
    }
}

