/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal;

import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.IVersion;
import org.faktorips.devtools.model.IVersionProvider;
import org.faktorips.devtools.model.internal.DefaultVersion;
import org.faktorips.devtools.model.internal.OsgiVersionFormat;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.ipsproject.IIpsProjectProperties;
import org.faktorips.devtools.model.ipsproject.IVersionFormat;
import org.faktorips.devtools.model.productrelease.ReleaseExtension;

public class DefaultVersionProvider
implements IVersionProvider<DefaultVersion> {
    private final IIpsProject ipsProject;
    private final IVersionFormat versionFormat;

    public DefaultVersionProvider(IIpsProject ipsProject) {
        this.ipsProject = ipsProject;
        this.versionFormat = this.createVersionFormat();
    }

    public DefaultVersionProvider(IIpsProject ipsProject, IVersionFormat versionFormat) {
        this.ipsProject = ipsProject;
        this.versionFormat = versionFormat;
    }

    private IVersionFormat createVersionFormat() {
        return IIpsModelExtensions.get().getReleaseExtension(this.ipsProject).map(releaseExtension -> new ReleaseExtensionVersionFormat((ReleaseExtension)releaseExtension)).orElseGet(OsgiVersionFormat::new);
    }

    @Override
    public IVersion<DefaultVersion> getVersion(String versionAsString) {
        if (this.isCorrectVersionFormat(versionAsString)) {
            return new DefaultVersion(versionAsString);
        }
        throw new IllegalArgumentException("No valid version: " + versionAsString);
    }

    @Override
    public IVersion<DefaultVersion> getProjectVersion() {
        String projectVersion = this.ipsProject.getReadOnlyProperties().getVersion();
        if (projectVersion != null && this.isCorrectVersionFormat(projectVersion)) {
            return this.getVersion(projectVersion);
        }
        return DefaultVersion.EMPTY_VERSION;
    }

    @Override
    public void setProjectVersion(IVersion<DefaultVersion> version) {
        IIpsProjectProperties properties = this.ipsProject.getProperties();
        properties.setVersion(version.asString());
        this.ipsProject.setProperties(properties);
    }

    @Override
    public boolean isCorrectVersionFormat(String version) {
        return this.versionFormat.isCorrectVersionFormat(version);
    }

    @Override
    public String getVersionFormat() {
        return this.versionFormat.getVersionFormat();
    }

    public static final class ReleaseExtensionVersionFormat
    implements IVersionFormat {
        private final ReleaseExtension releaseExtension;

        private ReleaseExtensionVersionFormat(ReleaseExtension releaseExtension) {
            this.releaseExtension = releaseExtension;
        }

        @Override
        public boolean isCorrectVersionFormat(String version) {
            return this.releaseExtension.getVersionFormatRegex().matcher(version).matches();
        }

        @Override
        public String getVersionFormat() {
            return this.releaseExtension.getReadableVersionFormat();
        }
    }
}

