/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.devtools.model.IFunctionResolverFactory;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.builder.ExtendedExprCompiler;
import org.faktorips.devtools.model.internal.fl.AbstractProjectRelatedFunctionResolverFactory;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.devtools.model.util.SortorderSet;
import org.faktorips.fl.FunctionResolver;

public class ExtensionFunctionResolversCache {
    private final IIpsProject ipsProject;
    private List<FunctionResolver<JavaCodeFragment>> cachedFunctionResolvers;
    private SortorderSet<IFunctionResolverFactory<JavaCodeFragment>> resolverFactories;

    public ExtensionFunctionResolversCache(IIpsProject ipsProject) {
        this.ipsProject = ipsProject;
        this.resolverFactories = IIpsModelExtensions.get().getFlFunctionResolverFactories();
        this.registerListenerWithIpsModel();
    }

    public ExtensionFunctionResolversCache(IIpsProject ipsProject, SortorderSet<IFunctionResolverFactory<JavaCodeFragment>> resolverFactories) {
        this.ipsProject = ipsProject;
        this.resolverFactories = resolverFactories;
        this.registerListenerWithIpsModel();
    }

    private void registerListenerWithIpsModel() {
        this.getIpsProject().getIpsModel().addChangeListener($ -> this.clearCache());
    }

    public void addExtensionFunctionResolversToCompiler(ExtendedExprCompiler compiler) {
        List<FunctionResolver<JavaCodeFragment>> resolvers = this.createFunctionResolversIfNeccessary();
        this.addFunctionResolversTo(resolvers, compiler);
    }

    protected List<FunctionResolver<JavaCodeFragment>> createFunctionResolversIfNeccessary() {
        if (this.cachedFunctionResolvers == null) {
            this.cachedFunctionResolvers = this.createExtendingFunctionResolvers();
        }
        return this.cachedFunctionResolvers;
    }

    protected List<FunctionResolver<JavaCodeFragment>> createExtendingFunctionResolvers() {
        ArrayList<FunctionResolver<JavaCodeFragment>> resolvers = new ArrayList<FunctionResolver<JavaCodeFragment>>();
        for (IFunctionResolverFactory<JavaCodeFragment> factory : this.resolverFactories.getSortedValues()) {
            if (!this.isActive(factory)) continue;
            FunctionResolver<JavaCodeFragment> resolver = this.createFuntionResolver(factory);
            this.addIfNotNull(resolvers, resolver);
        }
        return resolvers;
    }

    private void addIfNotNull(ArrayList<FunctionResolver<JavaCodeFragment>> resolverList, FunctionResolver<JavaCodeFragment> resolver) {
        if (resolver != null) {
            resolverList.add(resolver);
        }
    }

    private FunctionResolver<JavaCodeFragment> createFuntionResolver(IFunctionResolverFactory<JavaCodeFragment> factory) {
        try {
            return this.createFunctionResolver(factory);
        }
        catch (Exception e) {
            IpsLog.log((IStatus)new IpsStatus("Unable to create the function resolver for the following factory: " + factory.getClass(), e));
            return null;
        }
    }

    private boolean isActive(IFunctionResolverFactory<JavaCodeFragment> factory) {
        return this.getIpsProject().getReadOnlyProperties().isActive(factory);
    }

    private FunctionResolver<JavaCodeFragment> createFunctionResolver(IFunctionResolverFactory<JavaCodeFragment> factory) {
        Locale formulaLanguageLocale = this.getIpsProject().getFormulaLanguageLocale();
        if (factory instanceof AbstractProjectRelatedFunctionResolverFactory) {
            return ((AbstractProjectRelatedFunctionResolverFactory)factory).newFunctionResolver(this.getIpsProject(), formulaLanguageLocale);
        }
        return factory.newFunctionResolver(formulaLanguageLocale);
    }

    private void addFunctionResolversTo(List<FunctionResolver<JavaCodeFragment>> resolvers, ExtendedExprCompiler compiler) {
        for (FunctionResolver<JavaCodeFragment> resolver : resolvers) {
            compiler.add(resolver);
        }
    }

    private IIpsProject getIpsProject() {
        return this.ipsProject;
    }

    protected void clearCache() {
        this.cachedFunctionResolvers = null;
    }
}

