/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.Assert;
import org.faktorips.devtools.model.IInternationalString;
import org.faktorips.runtime.internal.InternationalStringXmlReaderWriter;
import org.faktorips.util.collections.DistinctElementComparator;
import org.faktorips.values.LocalizedString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InternationalString
implements IInternationalString {
    private static final DistinctElementComparator<LocalizedString> COMPARATOR = DistinctElementComparator.createComparator(Comparator.comparing(LocalizedString::getValue));
    private final Map<Locale, LocalizedString> localizedStringMap = new LinkedHashMap<Locale, LocalizedString>();
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public InternationalString() {
    }

    public InternationalString(PropertyChangeListener listener) {
        this();
        this.changes.addPropertyChangeListener(listener);
    }

    @Override
    public LocalizedString get(Locale locale) {
        LocalizedString localizedString = this.localizedStringMap.get(locale);
        if (localizedString == null) {
            return this.emptyLocalizedString(locale);
        }
        return localizedString;
    }

    @Override
    public void add(LocalizedString localizedString) {
        Assert.isNotNull((Object)localizedString);
        LocalizedString localizedStringToSet = localizedString;
        if (localizedString.getValue() == null) {
            localizedStringToSet = this.emptyLocalizedString(localizedString.getLocale());
        }
        LocalizedString oldText = this.localizedStringMap.put(localizedStringToSet.getLocale(), localizedStringToSet);
        this.changes.firePropertyChange("localizedString", oldText, localizedStringToSet);
    }

    @Override
    public Collection<LocalizedString> values() {
        return this.localizedStringMap.values();
    }

    @Override
    public void initFromXml(Element element) {
        Collection localizedStrings = InternationalStringXmlReaderWriter.fromXml((Element)element);
        this.localizedStringMap.clear();
        for (LocalizedString localizedString : localizedStrings) {
            this.localizedStringMap.put(localizedString.getLocale(), localizedString);
        }
    }

    @Override
    public Element toXml(Document doc) {
        return InternationalStringXmlReaderWriter.toXml((Document)doc, this.localizedStringMap.values());
    }

    public int hashCode() {
        return Objects.hash(this.localizedStringMap);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void other;
        Object object;
        if (this == obj) {
            return true;
        }
        if (obj == null || !((object = obj) instanceof InternationalString)) {
            return false;
        }
        InternationalString internationalString = (InternationalString)object;
        InternationalString cfr_ignored_0 = (InternationalString)object;
        if (this.localizedStringMap == null) {
            return other.localizedStringMap == null;
        }
        return this.equalLocalizedMapValues(other.values());
    }

    private boolean equalLocalizedMapValues(Collection<LocalizedString> otherLocalizedStringMapValues) {
        Collection<LocalizedString> values = this.values();
        if (otherLocalizedStringMapValues == null || values.size() != otherLocalizedStringMapValues.size()) {
            return false;
        }
        for (LocalizedString localizedString : values) {
            if (otherLocalizedStringMapValues.contains(localizedString)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("InternationalString [");
        if (this.localizedStringMap != null) {
            for (LocalizedString localizedString : this.values()) {
                builder.append(localizedString.toString());
                builder.append(" ");
            }
        }
        builder.append("]");
        return builder.toString();
    }

    private LocalizedString emptyLocalizedString(Locale locale) {
        return new LocalizedString(locale, "");
    }

    @Override
    public int compareTo(IInternationalString o) {
        return COMPARATOR.compare(this.values(), o.values());
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes.removePropertyChangeListener(l);
    }

    @Override
    public boolean hasValueFor(Locale locale) {
        return this.localizedStringMap != null && this.localizedStringMap.containsKey(locale);
    }
}

