/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal;

import java.util.Objects;
import org.eclipse.core.runtime.PlatformObject;
import org.faktorips.devtools.abstraction.AResource;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.ipsproject.IIpsProject;

public abstract class IpsElement
extends PlatformObject
implements IIpsElement {
    private static final IIpsElement[] NO_CHILDREN = new IIpsElement[0];
    protected String name;
    private IIpsElement parent;

    public IpsElement(IIpsElement parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public IpsElement() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public final IIpsElement getParent() {
        return this.parent;
    }

    @Override
    public boolean exists() {
        if (this.getParent() == null || !this.getParent().exists()) {
            return false;
        }
        if (this.getCorrespondingResource() == null) {
            return true;
        }
        return this.getCorrespondingResource().exists();
    }

    @Override
    public AResource getEnclosingResource() {
        AResource resource = this.getCorrespondingResource();
        if (resource != null) {
            return resource;
        }
        return this.getParent().getEnclosingResource();
    }

    @Override
    public IIpsModel getIpsModel() {
        return IIpsModel.get();
    }

    @Override
    public IIpsProject getIpsProject() {
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getIpsProject();
    }

    @Override
    public IIpsElement[] getChildren() {
        return NO_CHILDREN;
    }

    @Override
    public boolean hasChildren() {
        return this.getChildren().length > 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return 31 * result + (this.getParent() == null ? 0 : this.getParent().hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IpsElement other = (IpsElement)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.getParent(), other.getParent());
    }

    public String toString() {
        if (this.getParent() == null) {
            return this.getName();
        }
        return String.valueOf(this.getParent().toString()) + "/" + this.getName();
    }

    @Override
    public boolean isContainedInArchive() {
        return this.getParent().isContainedInArchive();
    }
}

