/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.abstraction.AFile;
import org.faktorips.devtools.abstraction.AProject;
import org.faktorips.devtools.abstraction.AResource;
import org.faktorips.devtools.abstraction.AWorkspace;
import org.faktorips.devtools.abstraction.Abstractions;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.ContentChangeEvent;
import org.faktorips.devtools.model.ContentsChangeListener;
import org.faktorips.devtools.model.IClassLoaderProvider;
import org.faktorips.devtools.model.ICustomModelExtensions;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.IIpsSrcFilesChangeListener;
import org.faktorips.devtools.model.IModificationStatusChangeListener;
import org.faktorips.devtools.model.IMultiLanguageSupport;
import org.faktorips.devtools.model.IVersionProvider;
import org.faktorips.devtools.model.ModificationStatusChangedEvent;
import org.faktorips.devtools.model.abstractions.WorkspaceAbstractions;
import org.faktorips.devtools.model.builder.IDependencyGraph;
import org.faktorips.devtools.model.extproperties.IExtensionPropertyDefinition;
import org.faktorips.devtools.model.internal.CustomModelExtensions;
import org.faktorips.devtools.model.internal.ExtensionFunctionResolversCache;
import org.faktorips.devtools.model.internal.IpsElement;
import org.faktorips.devtools.model.internal.IpsObjectPathContainerFactory;
import org.faktorips.devtools.model.internal.IpsProjectData;
import org.faktorips.devtools.model.internal.SingleEventModification;
import org.faktorips.devtools.model.internal.ValidationResultCache;
import org.faktorips.devtools.model.internal.XsdValidationHandler;
import org.faktorips.devtools.model.internal.builder.DependencyGraph;
import org.faktorips.devtools.model.internal.builder.EmptyBuilderSet;
import org.faktorips.devtools.model.internal.ipsobject.IpsObject;
import org.faktorips.devtools.model.internal.ipsobject.IpsSrcFileContent;
import org.faktorips.devtools.model.internal.ipsobject.IpsSrcFileOffRoot;
import org.faktorips.devtools.model.internal.ipsproject.ChangesOverTimeNamingConvention;
import org.faktorips.devtools.model.internal.ipsproject.IpsProject;
import org.faktorips.devtools.model.internal.ipsproject.properties.IpsArtefactBuilderSetConfig;
import org.faktorips.devtools.model.internal.ipsproject.properties.IpsArtefactBuilderSetInfo;
import org.faktorips.devtools.model.internal.ipsproject.properties.IpsProjectProperties;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsproject.IChangesOverTimeNamingConvention;
import org.faktorips.devtools.model.ipsproject.IIpsArtefactBuilderSet;
import org.faktorips.devtools.model.ipsproject.IIpsArtefactBuilderSetConfig;
import org.faktorips.devtools.model.ipsproject.IIpsArtefactBuilderSetInfo;
import org.faktorips.devtools.model.ipsproject.IIpsObjectPathContainer;
import org.faktorips.devtools.model.ipsproject.IIpsPackageFragment;
import org.faktorips.devtools.model.ipsproject.IIpsPackageFragmentRoot;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.ipsproject.IIpsProjectProperties;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.plugin.IpsModelExtensionsViaExtensionPoints;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.devtools.model.plugin.MultiLanguageSupport;
import org.faktorips.devtools.model.plugin.extensions.CachingSupplier;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class IpsModel
extends IpsElement
implements IIpsModel {
    public static final boolean TRACE_MODEL_MANAGEMENT = Boolean.parseBoolean(Abstractions.getDebugOption((String)"org.faktorips.devtools.model/trace/modelmanagement"));
    public static final boolean TRACE_MODEL_CHANGE_LISTENERS = Boolean.parseBoolean(Abstractions.getDebugOption((String)"org.faktorips.devtools.model/trace/modelchangelisteners"));
    public static final boolean TRACE_VALIDATION = Boolean.parseBoolean(Abstractions.getDebugOption((String)"org.faktorips.devtools.model/trace/validation"));
    protected static final int INVALID_MOD_STAMP = -42;
    private static IpsModel theInstance;
    private CopyOnWriteArraySet<ContentsChangeListener> changeListeners = new CopyOnWriteArraySet();
    private final Set<IIpsSrcFilesChangeListener> ipsSrcFilesChangeListeners = new CopyOnWriteArraySet<IIpsSrcFilesChangeListener>();
    private Set<IModificationStatusChangeListener> modificationStatusChangeListeners = new HashSet<IModificationStatusChangeListener>(100);
    private Map<Thread, Integer> listenerNotificationLevelMap = new HashMap<Thread, Integer>();
    private Map<String, IpsProject> projectMap = new ConcurrentHashMap<String, IpsProject>();
    private Supplier<List<IIpsArtefactBuilderSetInfo>> builderSetInfoList = CachingSupplier.caching(this::createIpsArtefactBuilderSetInfosIfNecessary);
    private Map<String, IChangesOverTimeNamingConvention> changesOverTimeNamingConventionMap = null;
    private Map<IIpsSrcFile, IpsSrcFileContent> ipsObjectsMap = new ConcurrentHashMap<IIpsSrcFile, IpsSrcFileContent>(1000);
    private ValidationResultCache validationResultCache = new ValidationResultCache();
    private IpsObjectType[] ipsObjectTypes;
    private final CustomModelExtensions customModelExtensions;
    private final Map<IIpsProject, IpsProjectData> ipsProjectDatas = new ConcurrentHashMap<IIpsProject, IpsProjectData>(3, 0.9f, 2);
    private IpsObjectPathContainerFactory ipsObjectPathContainerFactory = IpsObjectPathContainerFactory.newFactoryBasedOnExtensions();
    private final IMultiLanguageSupport multiLanguageSupport = new MultiLanguageSupport();
    private Function<IIpsProject, IIpsArtefactBuilderSet> fallbackBuilderSetProvider;

    protected IpsModel() {
        super(null, "IpsModel");
        if (TRACE_MODEL_MANAGEMENT) {
            System.out.println("IpsModel.Constructor(): IpsModel created.");
        }
        this.customModelExtensions = new CustomModelExtensions(this);
        this.initIpsObjectTypes();
    }

    public void stopListeningToResourceChanges() {
    }

    public void startListeningToResourceChanges() {
    }

    protected Set<IIpsSrcFile> getIpsSrcFilesInternal() {
        return this.ipsObjectsMap.keySet();
    }

    @Deprecated
    public static synchronized void reInit() {
        if (theInstance != null) {
            theInstance.stopListeningToResourceChanges();
        }
        theInstance = WorkspaceAbstractions.createIpsModel();
        theInstance.startListeningToResourceChanges();
    }

    @Deprecated
    public static final synchronized IpsModel get() {
        if (theInstance == null) {
            theInstance = WorkspaceAbstractions.createIpsModel();
        }
        return theInstance;
    }

    @Override
    public IMultiLanguageSupport getMultiLanguageSupport() {
        return this.multiLanguageSupport;
    }

    @Override
    public ICustomModelExtensions getCustomModelExtensions() {
        return this.customModelExtensions;
    }

    private void initIpsObjectTypes() {
        if (TRACE_MODEL_MANAGEMENT) {
            System.out.println("IpsModel.initIpsObjectType: start.");
        }
        ArrayList<IpsObjectType> types = new ArrayList<IpsObjectType>();
        types.add(IpsObjectType.POLICY_CMPT_TYPE);
        types.add(IpsObjectType.PRODUCT_CMPT_TYPE);
        types.add(IpsObjectType.PRODUCT_CMPT);
        types.add(IpsObjectType.PRODUCT_TEMPLATE);
        types.add(IpsObjectType.ENUM_TYPE);
        types.add(IpsObjectType.ENUM_CONTENT);
        types.add(IpsObjectType.TABLE_STRUCTURE);
        types.add(IpsObjectType.TABLE_CONTENTS);
        types.add(IpsObjectType.TEST_CASE_TYPE);
        types.add(IpsObjectType.TEST_CASE);
        IIpsModelExtensions.get().getAdditionalIpsObjectTypes().forEach(t -> this.addIpsObjectTypeIfNotDuplicate((List<IpsObjectType>)types, (IpsObjectType)t));
        IpsObjectType[] typesArray = types.toArray(new IpsObjectType[types.size()]);
        this.ipsObjectTypes = typesArray;
        if (TRACE_MODEL_MANAGEMENT) {
            System.out.println("IpsModel.initIpsObjectType: finished.");
        }
    }

    private void addIpsObjectTypeIfNotDuplicate(List<IpsObjectType> types, IpsObjectType newType) {
        for (IpsObjectType exisingType : types) {
            if (!exisingType.getFileExtension().equalsIgnoreCase(newType.getFileExtension())) continue;
            IpsLog.log((IStatus)new IpsStatus("Can't register IpsObjectType " + newType + " as it has the same file extension as the type " + exisingType));
            return;
        }
        types.add(newType);
    }

    private IpsProjectData getIpsProjectData(IIpsProject ipsProject) {
        return this.ipsProjectDatas.computeIfAbsent(ipsProject, p -> new IpsProjectData((IIpsProject)p, this.ipsObjectPathContainerFactory));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void runAndQueueChangeEvents(ICoreRunnable action, IProgressMonitor monitor) {
        if (this.changeListeners.isEmpty() && this.modificationStatusChangeListeners.isEmpty()) {
            try {
                this.getWorkspace().run(action, monitor);
            }
            catch (IpsException e) {
                IpsLog.log(e);
                throw e;
            }
            return;
        }
        listeners = new ArrayList<ContentsChangeListener>(this.changeListeners);
        changedSrcFileEvents = new HashMap<K, V>();
        batchListener = (ContentsChangeListener)LambdaMetafactory.metafactory(null, null, null, (Lorg/faktorips/devtools/model/ContentChangeEvent;)V, lambda$3(java.util.Map org.faktorips.devtools.model.ContentChangeEvent ), (Lorg/faktorips/devtools/model/ContentChangeEvent;)V)((IpsModel)this, changedSrcFileEvents);
        this.changeListeners.clear();
        this.addChangeListener(batchListener);
        copyOfCurrentModifyListeners = new HashSet<IModificationStatusChangeListener>(this.modificationStatusChangeListeners);
        modifiedSrcFiles = new LinkedHashSet<IIpsSrcFile>(0);
        batchModifiyListener = (IModificationStatusChangeListener)LambdaMetafactory.metafactory(null, null, null, (Lorg/faktorips/devtools/model/ModificationStatusChangedEvent;)V, lambda$4(java.util.Set org.faktorips.devtools.model.ModificationStatusChangedEvent ), (Lorg/faktorips/devtools/model/ModificationStatusChangedEvent;)V)(modifiedSrcFiles);
        this.modificationStatusChangeListeners.clear();
        this.addModifcationStatusChangeListener(batchModifiyListener);
        try {
            this.runSafe(action, monitor, modifiedSrcFiles);
        }
        finally {
            this.removeChangeListener(batchListener);
            this.changeListeners = new CopyOnWriteArraySet<ContentsChangeListener>(listeners);
            ** for (file : changedSrcFileEvents.keySet())
        }
lbl-1000:
        // 1 sources

        {
            this.notifyChangeListeners((ContentChangeEvent)changedSrcFileEvents.get(file));
            continue;
        }
lbl28:
        // 1 sources

        this.removeModificationStatusChangeListener(batchModifiyListener);
        this.modificationStatusChangeListeners = copyOfCurrentModifyListeners;
        for (IIpsSrcFile ipsSrcFile : modifiedSrcFiles) {
            event = new ModificationStatusChangedEvent(ipsSrcFile);
            this.notifyModificationStatusChangeListener(event);
        }
    }

    private void collect(Map<IIpsSrcFile, ContentChangeEvent> changedSrcFileEvents, ContentChangeEvent event) {
        ContentChangeEvent newEvent = null;
        ContentChangeEvent previousEvent = changedSrcFileEvents.get(event.getIpsSrcFile());
        newEvent = previousEvent == null ? event : ContentChangeEvent.mergeChangeEvents(event, previousEvent);
        changedSrcFileEvents.put(event.getIpsSrcFile(), newEvent);
    }

    /*
     * Unable to fully structure code
     */
    protected void runSafe(ICoreRunnable action, IProgressMonitor monitor, Set<IIpsSrcFile> modifiedSrcFiles) {
        block3: {
            try {
                this.getWorkspace().run(action, monitor);
                break block3;
            }
            catch (IpsException e) {
                ** for (ipsSrcFile : modifiedSrcFiles)
            }
lbl-1000:
            // 1 sources

            {
                ipsSrcFile.discardChanges();
                continue;
            }
lbl8:
            // 1 sources

            IpsLog.logAndShowErrorDialog((Exception)e);
        }
    }

    @Override
    public AWorkspace getWorkspace() {
        return Abstractions.getWorkspace();
    }

    @Override
    public IIpsProject createIpsProject(AProject project) {
        return WorkspaceAbstractions.createIpsProject((IIpsModel)this, project);
    }

    @Override
    public IIpsProject[] getIpsProjects() {
        return (IIpsProject[])Abstractions.getWorkspace().getRoot().getProjects().stream().filter(AProject::isIpsProject).map(AResource::getName).map(this::getIpsProject).toArray(IIpsProject[]::new);
    }

    @Override
    public IIpsProject[] getIpsModelProjects() {
        IIpsProject[] allIpsProjects = this.getIpsProjects();
        ArrayList<IIpsProject> modelProjects = new ArrayList<IIpsProject>(allIpsProjects.length);
        IIpsProject[] iIpsProjectArray = allIpsProjects;
        int n = allIpsProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsProject ipsProject = iIpsProjectArray[n2];
            if (ipsProject.isModelProject()) {
                modelProjects.add(ipsProject);
            }
            ++n2;
        }
        return modelProjects.toArray(new IIpsProject[modelProjects.size()]);
    }

    @Override
    public IIpsProject[] getIpsProductDefinitionProjects() {
        IIpsProject[] allIpsProjects = this.getIpsProjects();
        ArrayList<IIpsProject> productDefinitionProjects = new ArrayList<IIpsProject>(allIpsProjects.length);
        IIpsProject[] iIpsProjectArray = allIpsProjects;
        int n = allIpsProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsProject ipsProject = iIpsProjectArray[n2];
            if (ipsProject.isProductDefinitionProject()) {
                productDefinitionProjects.add(ipsProject);
            }
            ++n2;
        }
        return productDefinitionProjects.toArray(new IIpsProject[productDefinitionProjects.size()]);
    }

    @Override
    public Set<AProject> getNonIpsProjects() {
        return Abstractions.getWorkspace().getRoot().getProjects().stream().filter(Predicate.not(AProject::isIpsProject)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public IIpsModel getIpsModel() {
        return this;
    }

    @Override
    public String getNextPartId(IIpsObjectPartContainer parentPart) {
        return UUID.randomUUID().toString();
    }

    @Override
    public IIpsProject getIpsProject(String name) {
        return this.projectMap.computeIfAbsent(name, this::createIpsProject);
    }

    private IpsProject createIpsProject(String name) {
        return WorkspaceAbstractions.createIpsProject((IIpsModel)this, name);
    }

    @Override
    public IIpsProject getIpsProject(AProject project) {
        return this.getIpsProject(project.getName());
    }

    @Override
    public AResource getCorrespondingResource() {
        return Abstractions.getWorkspace().getRoot();
    }

    @Override
    public boolean exists() {
        return this.getCorrespondingResource() != null && this.getCorrespondingResource().exists();
    }

    @Override
    public IIpsElement[] getChildren() {
        return this.getIpsProjects();
    }

    @Override
    public IIpsElement getIpsElement(AResource resource) {
        Path relativePath;
        ArgumentCheck.notNull((Object)resource);
        if (resource.getType() == AResource.AResourceType.WORKSPACE) {
            return this;
        }
        if (resource.getType() == AResource.AResourceType.PROJECT) {
            if (((AProject)resource).isIpsProject()) {
                return this.getIpsProject(resource.getName());
            }
            return null;
        }
        AProject project = resource.getProject();
        if (project == null) {
            return null;
        }
        IIpsProject ipsProject = this.getIpsProject(project.getName());
        IIpsPackageFragmentRoot root = ipsProject.findIpsPackageFragmentRoot(relativePath = resource.getProjectRelativePath());
        if (root == null) {
            return this.getExternalIpsSrcFile(resource);
        }
        int rootNameCount = Path.of(root.getName(), new String[0]).getNameCount();
        if (relativePath.getNameCount() == rootNameCount) {
            return root;
        }
        StringBuilder folderName = new StringBuilder();
        int i = rootNameCount;
        while (i < relativePath.getNameCount() - 1) {
            if (i > rootNameCount) {
                folderName.append('.');
            }
            folderName.append(relativePath.subpath(i, i + 1));
            ++i;
        }
        if (resource.getType() == AResource.AResourceType.FOLDER) {
            if (relativePath.getNameCount() > rootNameCount + 1) {
                folderName.append('.');
            }
            folderName.append(resource.getName());
            return root.getIpsPackageFragment(folderName.toString());
        }
        IIpsPackageFragment ipsFolder = root.getIpsPackageFragment(folderName.toString());
        if (ipsFolder == null) {
            return null;
        }
        return ipsFolder.getIpsSrcFile(resource.getName());
    }

    private IIpsElement getExternalIpsSrcFile(AResource resource) {
        if (resource.getType() == AResource.AResourceType.FILE && resource.exists() && this.getIpsObjectTypeByFileExtension(((AFile)resource).getExtension()) != null) {
            return new IpsSrcFileOffRoot((AFile)resource);
        }
        return null;
    }

    @Override
    public IIpsElement findIpsElement(AResource resource) {
        if (resource == null) {
            return null;
        }
        IIpsElement element = this.getIpsElement(resource);
        if (element != null && element.exists()) {
            return element;
        }
        return null;
    }

    public void stopBroadcastingChangesMadeByCurrentThread() {
        Integer level = this.listenerNotificationLevelMap.get(Thread.currentThread());
        level = level == null ? Integer.valueOf(1) : Integer.valueOf(level + 1);
        this.listenerNotificationLevelMap.put(Thread.currentThread(), level);
        if (TRACE_MODEL_CHANGE_LISTENERS) {
            System.out.println("IpsModel.stopBroadcastingChangesMadeByCurrentThread(): Thread=" + Thread.currentThread() + ", new level=" + level);
        }
    }

    public void resumeBroadcastingChangesMadeByCurrentThread() {
        Integer level = this.listenerNotificationLevelMap.get(Thread.currentThread());
        if (level != null && level > 0) {
            level = level - 1;
        }
        this.listenerNotificationLevelMap.put(Thread.currentThread(), level);
        if (TRACE_MODEL_CHANGE_LISTENERS) {
            System.out.println("IpsModel.restartBroadcastingChangesMadeByCurrentThread(): Thread=" + Thread.currentThread() + ", new level=" + level);
        }
    }

    public boolean isBroadcastingChangesForCurrentThread() {
        Integer level = this.listenerNotificationLevelMap.get(Thread.currentThread());
        return level == null || level == 0;
    }

    @Override
    public void addModifcationStatusChangeListener(IModificationStatusChangeListener listener) {
        if (TRACE_MODEL_CHANGE_LISTENERS) {
            System.out.println("IpsModel.addModificationStatusChangeListener(): " + listener);
        }
        if (this.modificationStatusChangeListeners == null) {
            this.modificationStatusChangeListeners = new HashSet<IModificationStatusChangeListener>(1);
        }
        this.modificationStatusChangeListeners.add(listener);
    }

    @Override
    public void removeModificationStatusChangeListener(IModificationStatusChangeListener listener) {
        if (this.modificationStatusChangeListeners != null) {
            boolean wasRemoved = this.modificationStatusChangeListeners.remove(listener);
            if (TRACE_MODEL_CHANGE_LISTENERS) {
                System.out.println("IpsModel.removeModificationStatusChangeListener(): " + listener + ", was removed=" + wasRemoved);
            }
        }
    }

    public void notifyModificationStatusChangeListener(ModificationStatusChangedEvent event) {
        if (this.modificationStatusChangeListeners.size() == 0 || !this.isBroadcastingChangesForCurrentThread()) {
            return;
        }
        if (TRACE_MODEL_CHANGE_LISTENERS) {
            System.out.println("IpsModel.notifyModificationStatusChangeListener(): " + this.modificationStatusChangeListeners.size() + " listeners");
        }
        IIpsModelExtensions.get().getWorkspaceInteractions().runInDisplayThreadSync(new RunnableModificationStatusChangeListenerImplementation(event));
    }

    @Override
    public void addChangeListener(ContentsChangeListener listener) {
        if (TRACE_MODEL_CHANGE_LISTENERS) {
            System.out.println("IpsModel.addChangeListeners(): " + listener);
        }
        this.changeListeners.add(listener);
    }

    @Override
    public void removeChangeListener(ContentsChangeListener listener) {
        boolean wasRemoved = this.changeListeners.remove(listener);
        if (TRACE_MODEL_CHANGE_LISTENERS) {
            System.out.println("IpsModel.removeChangeListeners(): " + listener + ", was removed=" + wasRemoved);
        }
    }

    public void notifyChangeListeners(ContentChangeEvent event) {
        if (!this.isBroadcastingChangesForCurrentThread()) {
            return;
        }
        if (TRACE_MODEL_CHANGE_LISTENERS) {
            System.out.println("IpsModel.notfiyChangeListeners(): " + this.changeListeners.size() + " listeners");
        }
        RunnableChangeListenerImplementation notifier = new RunnableChangeListenerImplementation(event);
        IIpsModelExtensions.get().getWorkspaceInteractions().runInDisplayThreadAsyncIfNotCurrentDisplay(notifier);
    }

    @Override
    public boolean addIpsSrcFilesChangedListener(IIpsSrcFilesChangeListener listener) {
        return this.ipsSrcFilesChangeListeners.add(listener);
    }

    @Override
    public boolean removeIpsSrcFilesChangedListener(IIpsSrcFilesChangeListener listener) {
        return this.ipsSrcFilesChangeListeners.remove(listener);
    }

    protected void forEachIpsSrcFilesChangeListener(Consumer<? super IIpsSrcFilesChangeListener> consumer) {
        this.ipsSrcFilesChangeListeners.forEach(consumer);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof IIpsModel;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return "IpsModel";
    }

    @Override
    public IIpsPackageFragmentRoot[] getSourcePackageFragmentRoots() {
        IIpsProject[] projects;
        ArrayList<IIpsPackageFragmentRoot> result = new ArrayList<IIpsPackageFragmentRoot>();
        IIpsProject[] iIpsProjectArray = projects = this.getIpsProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsProject project = iIpsProjectArray[n2];
            ((IpsProject)project).getSourceIpsFragmentRoots(result);
            ++n2;
        }
        IIpsPackageFragmentRoot[] sourceRoots = new IIpsPackageFragmentRoot[result.size()];
        result.toArray(sourceRoots);
        return sourceRoots;
    }

    public ValueDatatype getValueDatatypeDefinedInProjectProperties(IIpsProject ipsProject, String qName) {
        Datatype datatype = this.getDatatypeDefinedInProjectProperties(ipsProject, qName);
        if (datatype != null && datatype.isValueDatatype()) {
            return (ValueDatatype)datatype;
        }
        return null;
    }

    public Datatype getDatatypeDefinedInProjectProperties(IIpsProject ipsProject, String qName) {
        Map<String, Datatype> map = this.getDatatypesDefinedInProjectProperties(ipsProject);
        return map.get(qName);
    }

    public void getDatatypesDefinedInProjectProperties(IIpsProject ipsProject, boolean valuetypesOnly, boolean includePrimitives, Set<Datatype> datatypes) {
        Map<String, Datatype> map = this.getDatatypesDefinedInProjectProperties(ipsProject);
        for (Datatype datatype : map.values()) {
            if (valuetypesOnly && !datatype.isValueDatatype() || !includePrimitives && datatype.isPrimitive()) continue;
            datatypes.add(datatype);
        }
    }

    public Map<String, Datatype> getDatatypesDefinedInProjectProperties(IIpsProject ipsProject) {
        this.reinitIpsProjectPropertiesIfNecessary((IpsProject)ipsProject);
        LinkedHashMap<String, Datatype> map = this.getIpsProjectData(ipsProject).getProjectDatatypesMap();
        if (map.isEmpty()) {
            this.initDatatypesDefinedInProjectProperties(ipsProject);
            map = this.getIpsProjectData(ipsProject).getProjectDatatypesMap();
        }
        return map;
    }

    private void initDatatypesDefinedInProjectProperties(IIpsProject project) {
        IpsProjectData ipsProjectData = this.getIpsProjectData(project);
        LinkedHashMap<String, Datatype> projectTypes = ipsProjectData.getProjectDatatypesMap();
        IpsProjectProperties props = this.getIpsProjectProperties(project);
        String[] datatypeIds = props.getPredefinedDatatypesUsed();
        Map<String, Datatype> datatypeMap = IIpsModelExtensions.get().getPredefinedDatatypes();
        String[] stringArray = datatypeIds;
        int n = datatypeIds.length;
        int n2 = 0;
        while (n2 < n) {
            String datatypeId = stringArray[n2];
            Datatype datatype = datatypeMap.get(datatypeId);
            if (datatype != null) {
                projectTypes.put(datatypeId, datatype);
            }
            ++n2;
        }
        List<Datatype> definedDatatypes = props.getDefinedDatatypes();
        for (Datatype datatype : definedDatatypes) {
            projectTypes.put(datatype.getQualifiedName(), datatype);
        }
    }

    public IIpsArtefactBuilderSet getIpsArtefactBuilderSet(IIpsProject project, boolean reinit) {
        ArgumentCheck.notNull((Object)project, (Object)this);
        this.reinitIpsProjectPropertiesIfNecessary((IpsProject)project);
        IIpsArtefactBuilderSet builderSet = this.getIpsProjectData(project).getIpsArtefactBuilderSet();
        if (builderSet == null) {
            return this.registerBuilderSet(project);
        }
        IpsProjectProperties data = this.getIpsProjectProperties(project);
        if (!builderSet.getId().equals(this.getBuilderSetId(data))) {
            return this.registerBuilderSet(project);
        }
        if (reinit) {
            this.initBuilderSet(builderSet, project, data);
        }
        return builderSet;
    }

    @Override
    public String getBuilderSetId(IIpsProjectProperties data) {
        return data.getBuilderSetId();
    }

    private IIpsArtefactBuilderSet registerBuilderSet(IIpsProject project) {
        IpsProjectProperties data = this.getIpsProjectProperties(project);
        IIpsArtefactBuilderSet builderSet = this.createIpsArtefactBuilderSet(this.getBuilderSetId(data), project);
        if (builderSet == null || !this.initBuilderSet(builderSet, project, data)) {
            if (this.getFallbackBuilderSetProvider() != null) {
                return this.getFallbackBuilderSetProvider().apply(project);
            }
            EmptyBuilderSet emptyBuilderSet = new EmptyBuilderSet();
            try {
                emptyBuilderSet.initialize(new IpsArtefactBuilderSetConfig(new HashMap<String, Object>()));
            }
            catch (IpsException e) {
                IpsLog.log(e);
            }
            return emptyBuilderSet;
        }
        this.getIpsProjectData(project).setIpsArtefactBuilderSet(builderSet);
        return builderSet;
    }

    private boolean initBuilderSet(IIpsArtefactBuilderSet builderSet, IIpsProject ipsProject, IIpsProjectProperties properties) {
        IIpsArtefactBuilderSetInfo builderSetInfo;
        block3: {
            try {
                builderSetInfo = this.getIpsArtefactBuilderSetInfo(builderSet.getId());
                if (builderSetInfo != null) break block3;
                IpsLog.log((IStatus)new IpsStatus("There is no builder set info registered with the id: " + builderSet.getId()));
                return false;
            }
            catch (IpsException e) {
                IpsLog.log((IStatus)new IpsStatus("An exception occurred while trying to initialize the artefact builder set: " + builderSet.getId(), e));
                return false;
            }
        }
        IIpsArtefactBuilderSetConfig builderSetConfig = properties.getBuilderSetConfig().create(ipsProject, builderSetInfo);
        builderSet.initialize(builderSetConfig);
        return true;
    }

    public IDependencyGraph getDependencyGraph(IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object)ipsProject, (Object)this);
        IDependencyGraph graph = this.getIpsProjectData(ipsProject).getDependencyGraph();
        if (graph == null) {
            graph = IIpsModelExtensions.get().getDependencyGraphPersistenceManager().getDependencyGraph(ipsProject);
            if (graph != null) {
                this.getIpsProjectData(ipsProject).setDependencyGraph(graph);
                return graph;
            }
            if (ipsProject.exists()) {
                graph = new DependencyGraph(ipsProject);
                this.getIpsProjectData(ipsProject).setDependencyGraph(graph);
            }
        }
        return graph;
    }

    public IDependencyGraph[] getCachedDependencyGraphs() {
        ArrayList<IDependencyGraph> graphs = new ArrayList<IDependencyGraph>();
        for (IpsProjectData projectData : this.ipsProjectDatas.values()) {
            if (projectData.getDependencyGraph() == null) continue;
            graphs.add(projectData.getDependencyGraph());
        }
        return graphs.toArray(new IDependencyGraph[graphs.size()]);
    }

    public IpsProjectProperties getIpsProjectProperties(IIpsProject ipsProject) {
        AFile propertyFile = ipsProject.getIpsProjectPropertiesFile();
        IpsProjectProperties properties = this.getIpsProjectData(ipsProject).getProjectProperties();
        if (properties != null && propertyFile.getModificationStamp() != properties.getLastPersistentModificationTimestamp()) {
            this.clearProjectSpecificCaches(ipsProject);
            properties = null;
        }
        if (properties == null) {
            properties = this.readProjectProperties(ipsProject);
            this.getIpsProjectData(ipsProject).setProjectProperties(properties);
        }
        return properties;
    }

    private void reinitIpsProjectPropertiesIfNecessary(IpsProject ipsProject) {
        this.getIpsProjectProperties(ipsProject);
    }

    public void clearProjectSpecificCaches(IIpsProject ipsProject) {
        this.ipsProjectDatas.remove(ipsProject);
        ipsProject.clearCaches();
    }

    private IpsProjectProperties readProjectProperties(IIpsProject ipsProject) {
        Document doc;
        InputStream is;
        AFile file = ipsProject.getIpsProjectPropertiesFile();
        IpsProjectProperties properties = new IpsProjectProperties(ipsProject);
        XsdValidationHandler xsdValidationHandler = new XsdValidationHandler();
        properties.setCreatedFromParsableFileContents(false);
        if (!file.exists()) {
            return properties;
        }
        try {
            is = file.getContents();
        }
        catch (IpsException e1) {
            IpsLog.log((IStatus)new IpsStatus("Error reading project file contents " + file, e1));
            return properties;
        }
        try {
            try {
                doc = XmlUtil.getDefaultDocumentBuilder().parse(is);
            }
            catch (SAXException e) {
                IpsLog.log((IStatus)new IpsStatus("Error parsing project file " + file, e));
                IpsProjectProperties ipsProjectProperties = properties;
                try {
                    is.close();
                }
                catch (IOException e2) {
                    IpsLog.log((IStatus)new IpsStatus("Error closing input stream after reading project file " + file, e2));
                    return properties;
                }
                return ipsProjectProperties;
            }
            catch (IOException e) {
                IpsLog.log((IStatus)new IpsStatus("Error accessing project file " + file, e));
                IpsProjectProperties ipsProjectProperties = properties;
                try {
                    is.close();
                }
                catch (IOException e3) {
                    IpsLog.log((IStatus)new IpsStatus("Error closing input stream after reading project file " + file, e3));
                    return properties;
                }
                return ipsProjectProperties;
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                IpsLog.log((IStatus)new IpsStatus("Error closing input stream after reading project file " + file, e));
                return properties;
            }
        }
        try {
            properties = IpsProjectProperties.createFromXml(ipsProject, doc.getDocumentElement());
            if (properties.isValidateIpsSchema()) {
                XmlUtil.getXsdValidator(IpsProjectType.IPS_PROJECT, xsdValidationHandler).validate(new DOMSource(doc));
                if (!xsdValidationHandler.getXsdValidationErrors().isEmpty()) {
                    IpsLog.log((IStatus)new IpsStatus("Schema validation failed for ips project properties file " + file));
                }
                properties.setXsdValidationHandler(xsdValidationHandler);
                if (!xsdValidationHandler.getXsdValidationErrors().isEmpty()) {
                    properties.setCreatedFromParsableFileContents(false);
                }
            }
        }
        catch (Exception e) {
            IpsLog.log((IStatus)new IpsStatus("Error creating properties from xml, file:  " + file, e));
            properties.setCreatedFromParsableFileContents(false);
        }
        properties.setLastPersistentModificationTimestamp(file.getModificationStamp());
        return properties;
    }

    protected void releaseInCache(IIpsSrcFile srcFile) {
        IpsSrcFileContent contents = this.ipsObjectsMap.get(srcFile);
        contents.setModificationStamp(-42L);
    }

    private IIpsArtefactBuilderSet createIpsArtefactBuilderSet(String builderSetId, IIpsProject ipsProject) {
        IIpsArtefactBuilderSetInfo[] infos;
        ArgumentCheck.notNull((Object)builderSetId);
        ArgumentCheck.notNull((Object)ipsProject);
        IIpsArtefactBuilderSetInfo[] iIpsArtefactBuilderSetInfoArray = infos = this.getIpsArtefactBuilderSetInfos();
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsArtefactBuilderSetInfo info = iIpsArtefactBuilderSetInfoArray[n2];
            if (info.getBuilderSetId().equals(builderSetId)) {
                return info.create(ipsProject);
            }
            ++n2;
        }
        return null;
    }

    public void setIpsArtefactBuilderSetInfos(IIpsArtefactBuilderSetInfo[] builderSetInfos) {
        this.builderSetInfoList = () -> new ArrayList<IIpsArtefactBuilderSetInfo>(Arrays.asList(builderSetInfos));
    }

    @Override
    public Set<IExtensionPropertyDefinition> getExtensionPropertyDefinitionsForClass(Class<?> type, boolean includeSupertypesAndInterfaces) {
        return this.customModelExtensions.getExtensionPropertyDefinitions(type, includeSupertypesAndInterfaces);
    }

    @Override
    public Map<String, IExtensionPropertyDefinition> getExtensionPropertyDefinitions(IIpsObjectPartContainer object) {
        return this.customModelExtensions.getExtensionPropertyDefinitions(object);
    }

    public void addIpsObjectExtensionProperty(IExtensionPropertyDefinition property) {
        this.customModelExtensions.addIpsObjectExtensionProperty(property);
    }

    @Override
    public ValueDatatype[] getPredefinedValueDatatypes() {
        Collection<Datatype> c = IIpsModelExtensions.get().getPredefinedDatatypes().values();
        return c.toArray(new ValueDatatype[c.size()]);
    }

    @Override
    public boolean isPredefinedValueDatatype(String valueDatatypeId) {
        return IIpsModelExtensions.get().getPredefinedDatatypes().containsKey(valueDatatypeId);
    }

    @Override
    public void delete(IIpsElement toDelete) {
        if (toDelete instanceof IIpsObjectPart) {
            ((IIpsObjectPart)toDelete).delete();
        }
    }

    @Override
    public IChangesOverTimeNamingConvention getChangesOverTimeNamingConvention(String id) {
        this.initChangesOverTimeNamingConventionIfNecessary();
        IChangesOverTimeNamingConvention convention = this.changesOverTimeNamingConventionMap.get(id);
        if (convention != null) {
            return convention;
        }
        convention = this.changesOverTimeNamingConventionMap.get("VAA");
        if (convention != null) {
            IpsLog.log((IStatus)new IpsStatus(2, "Unknown changes in time naming convention " + id + ". Using default " + "VAA", null));
            return convention;
        }
        IpsLog.log((IStatus)new IpsStatus("Unknown changes in time naming convention " + id + ". Default convention " + "VAA" + " not found!"));
        return new ChangesOverTimeNamingConvention("VAA");
    }

    @Override
    public IChangesOverTimeNamingConvention[] getChangesOverTimeNamingConvention() {
        this.initChangesOverTimeNamingConventionIfNecessary();
        IChangesOverTimeNamingConvention[] conventions = new IChangesOverTimeNamingConvention[this.changesOverTimeNamingConventionMap.size()];
        int i = 0;
        for (IChangesOverTimeNamingConvention iChangesOverTimeNamingConvention : this.changesOverTimeNamingConventionMap.values()) {
            conventions[i++] = iChangesOverTimeNamingConvention;
        }
        return conventions;
    }

    private void initChangesOverTimeNamingConventionIfNecessary() {
        if (this.changesOverTimeNamingConventionMap == null) {
            this.changesOverTimeNamingConventionMap = new HashMap<String, IChangesOverTimeNamingConvention>();
            ChangesOverTimeNamingConvention fips = new ChangesOverTimeNamingConvention("FIPS");
            this.changesOverTimeNamingConventionMap.put(fips.getId(), fips);
            ChangesOverTimeNamingConvention vaa = new ChangesOverTimeNamingConvention("VAA");
            this.changesOverTimeNamingConventionMap.put(vaa.getId(), vaa);
            ChangesOverTimeNamingConvention pm = new ChangesOverTimeNamingConvention("PM");
            this.changesOverTimeNamingConventionMap.put(pm.getId(), pm);
        }
    }

    public IClassLoaderProvider getClassLoaderProvider(IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object)ipsProject);
        IClassLoaderProvider provider = this.getIpsProjectData(ipsProject).getClassLoaderProvider();
        if (provider == null) {
            provider = IIpsModelExtensions.get().getClassLoaderProviderFactory().getClassLoaderProvider(ipsProject);
            this.getIpsProjectData(ipsProject).setClassLoaderProvider(provider);
        }
        return provider;
    }

    public ExtensionFunctionResolversCache getExtensionFunctionResolverCache(IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object)ipsProject);
        ExtensionFunctionResolversCache functionResolversCache = this.getIpsProjectData(ipsProject).getFunctionResolver();
        if (functionResolversCache == null) {
            functionResolversCache = new ExtensionFunctionResolversCache(ipsProject);
            this.getIpsProjectData(ipsProject).setFunctionResolver(functionResolversCache);
        }
        return functionResolversCache;
    }

    public ValidationResultCache getValidationResultCache() {
        return this.validationResultCache;
    }

    public synchronized void removeIpsSrcFileContent(IIpsSrcFile file) {
        if (file != null) {
            this.ipsObjectsMap.remove(file);
        }
    }

    public boolean isCached(IIpsSrcFile file) {
        return this.ipsObjectsMap.get(file) != null;
    }

    public synchronized IpsSrcFileContent getIpsSrcFileContent(IIpsSrcFile file, boolean loadCompleteContent) {
        if (file == null) {
            return null;
        }
        IpsSrcFileContent content = this.ipsObjectsMap.get(file);
        if (content == null) {
            if (file.exists()) {
                content = this.readContentFromFile(file, loadCompleteContent);
                this.cache(file, content);
                return content;
            }
            return null;
        }
        AResource enclResource = file.getEnclosingResource();
        if (enclResource == null) {
            return content;
        }
        long resourceModStamp = enclResource.getModificationStamp();
        if (content.getModificationStamp() == resourceModStamp) {
            return this.checkSynchronizedContent(content, loadCompleteContent);
        }
        if (loadCompleteContent) {
            content.initContentFromFile();
        } else {
            content.initRootPropertiesFromFile();
        }
        return content;
    }

    @Deprecated
    public void cache(IIpsSrcFile file, IpsSrcFileContent content) {
        this.ipsObjectsMap.put(file, content);
    }

    private IpsSrcFileContent readContentFromFile(IIpsSrcFile file, boolean loadCompleteContent) {
        IpsSrcFileContent content = new IpsSrcFileContent((IpsObject)file.getIpsObjectType().newObject(file));
        if (loadCompleteContent) {
            IpsModel.logTraceMessage("New content created", file);
            content.initContentFromFile();
        } else {
            IpsModel.logTraceMessage("New properties read", file);
            content.initRootPropertiesFromFile();
        }
        return content;
    }

    private IpsSrcFileContent checkSynchronizedContent(IpsSrcFileContent content, boolean loadCompleteContent) {
        if (loadCompleteContent) {
            if (content.isInitialized()) {
                IpsModel.logTraceMessage("Content returned from cache", content.getIpsSrcFile());
                return content;
            }
            IpsModel.logTraceMessage("Content initialized", content.getIpsSrcFile());
            content.initContentFromFile();
            return content;
        }
        if (content.areRootPropertiesAvailable()) {
            IpsModel.logTraceMessage("Properties returned from cache", content.getIpsSrcFile());
            return content;
        }
        IpsModel.logTraceMessage("Properties initialized", content.getIpsSrcFile());
        content.initRootPropertiesFromFile();
        return content;
    }

    @Override
    public synchronized IpsSrcFileContent getIpsSrcFileContent(IIpsSrcFile file) {
        return this.getIpsSrcFileContent(file, true);
    }

    public void ipsSrcFileContentHasChanged(ContentChangeEvent event) {
        IIpsSrcFile file = event.getIpsSrcFile();
        if (TRACE_MODEL_MANAGEMENT) {
            System.out.println("IpsModel.ipsSrcFileHasChanged(), file=" + file + ", Thead: " + Thread.currentThread().getName());
        }
        this.validationResultCache.removeStaleData(file);
        this.notifyChangeListeners(event);
        if (TRACE_MODEL_MANAGEMENT) {
            System.out.println("IpsModel.ipsSrcFileHasChanged(), file=" + event.getIpsSrcFile() + ", Thead: " + Thread.currentThread().getName());
        }
    }

    @Override
    public void clearValidationCache() {
        this.getValidationResultCache().clear();
    }

    private List<IIpsArtefactBuilderSetInfo> createIpsArtefactBuilderSetInfosIfNecessary() {
        IExtensionRegistry registry = ((IpsModelExtensionsViaExtensionPoints)IIpsModelExtensions.get()).getExtensionRegistry();
        ArrayList<IIpsArtefactBuilderSetInfo> tmpList = new ArrayList<IIpsArtefactBuilderSetInfo>();
        IpsArtefactBuilderSetInfo.loadExtensions(registry, IpsLog.get(), tmpList, this);
        return tmpList;
    }

    @Override
    public IIpsArtefactBuilderSetInfo[] getIpsArtefactBuilderSetInfos() {
        List<IIpsArtefactBuilderSetInfo> list = this.builderSetInfoList.get();
        return list.toArray(new IIpsArtefactBuilderSetInfo[list.size()]);
    }

    @Override
    public IIpsArtefactBuilderSetInfo getIpsArtefactBuilderSetInfo(String id) {
        for (IIpsArtefactBuilderSetInfo name2 : this.builderSetInfoList.get()) {
            IIpsArtefactBuilderSetInfo builderSetInfo = name2;
            if (!builderSetInfo.getBuilderSetId().equals(id)) continue;
            return builderSetInfo;
        }
        return null;
    }

    @Override
    public IpsObjectType[] getIpsObjectTypes() {
        return Arrays.copyOf(this.ipsObjectTypes, this.ipsObjectTypes.length);
    }

    @Override
    public IpsObjectType getIpsObjectType(String name) {
        IpsObjectType[] ipsObjectTypeArray = this.ipsObjectTypes;
        int n = this.ipsObjectTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IpsObjectType ipsObjectType = ipsObjectTypeArray[n2];
            if (ipsObjectType.getId().equals(name)) {
                return ipsObjectType;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IpsObjectType getIpsObjectTypeByFileExtension(String fileExtension) {
        IpsObjectType[] ipsObjectTypeArray = this.ipsObjectTypes;
        int n = this.ipsObjectTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IpsObjectType ipsObjectType = ipsObjectTypeArray[n2];
            if (ipsObjectType.getFileExtension().equals(fileExtension)) {
                return ipsObjectType;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IVersionProvider<?> getVersionProvider(IIpsProject ipsProject) {
        IVersionProvider<?> versionProvider = this.getIpsProjectData(ipsProject).getVersionProvider();
        if (versionProvider == null) {
            versionProvider = IIpsModelExtensions.get().getVersionProvider(ipsProject);
            this.getIpsProjectData(ipsProject).setVersionProvider(versionProvider);
        }
        return versionProvider;
    }

    private static void logTraceMessage(String text, IIpsSrcFile ipsSrcFile) {
        if (TRACE_MODEL_MANAGEMENT) {
            AResource enclosingResource = ipsSrcFile.getEnclosingResource();
            System.out.println(MessageFormat.format("IpsModel.getIpsSrcFileContent(): {0}, file={1}, FileModStamp={2}, Thread={3}", text, "" + ipsSrcFile, "" + enclosingResource.getModificationStamp(), Thread.currentThread().getName()));
        }
    }

    @Override
    public boolean isContainedInArchive() {
        return false;
    }

    @Override
    public IIpsObjectPathContainer getIpsObjectPathContainer(IIpsProject ipsProject, String containerTypeId, String optionalPath) {
        ArgumentCheck.notNull((Object)ipsProject);
        ArgumentCheck.notNull((Object)containerTypeId);
        ArgumentCheck.notNull((Object)optionalPath);
        IpsProjectData data = this.getIpsProjectData(ipsProject);
        return data.getIpsObjectPathContainer(containerTypeId, optionalPath);
    }

    public <T> T executeModificationsWithSingleEvent(SingleEventModification<T> modifications) {
        boolean successful = false;
        IIpsSrcFile ipsSrcFile = modifications.getIpsSrcFile();
        IpsSrcFileContent content = this.getIpsSrcFileContent(ipsSrcFile);
        try {
            this.stopBroadcastingChangesMadeByCurrentThread();
            successful = modifications.execute();
        }
        finally {
            if (successful) {
                ipsSrcFile.markAsClean();
            }
            this.resumeBroadcastingChangesMadeByCurrentThread();
            if (successful) {
                if (content != null) {
                    content.ipsObjectChanged(modifications.modificationEvent());
                } else {
                    this.ipsSrcFileContentHasChanged(modifications.modificationEvent());
                }
            }
        }
        return modifications.getResult();
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("The IPS Model cannot be deleted.");
    }

    public LinkedHashSet<IIpsSrcFile> getMarkerEnums(IpsProject ipsProject) {
        return this.getIpsProjectData(ipsProject).getMarkerEnums();
    }

    protected Function<IIpsProject, IIpsArtefactBuilderSet> getFallbackBuilderSetProvider() {
        return this.fallbackBuilderSetProvider;
    }

    public void setFallbackBuilderSetProvider(Function<IIpsProject, IIpsArtefactBuilderSet> fallbackBuilderSetProvider) {
        this.fallbackBuilderSetProvider = fallbackBuilderSetProvider;
    }

    private /* synthetic */ void lambda$3(Map map, ContentChangeEvent event) {
        this.collect(map, event);
    }

    private static /* synthetic */ void lambda$4(Set set, ModificationStatusChangedEvent event) {
        boolean bl = set.add(event.getIpsSrcFile());
    }

    private static class IpsProjectType
    extends IpsObjectType {
        private static final IpsObjectType IPS_PROJECT = new IpsProjectType();
        private static final String IPS_PROJECT_PROP = "ipsProjectProperties";

        protected IpsProjectType() {
            super(IPS_PROJECT_PROP, IPS_PROJECT_PROP, IPS_PROJECT_PROP, IPS_PROJECT_PROP, ".ipsproject", false, false, null);
        }
    }

    private final class RunnableChangeListenerImplementation
    implements Runnable {
        private final ContentChangeEvent event;

        private RunnableChangeListenerImplementation(ContentChangeEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            for (ContentsChangeListener listener : IpsModel.this.changeListeners) {
                if (!this.event.getIpsSrcFile().exists()) break;
                try {
                    if (TRACE_MODEL_CHANGE_LISTENERS) {
                        System.out.println("IpsModel.notfiyChangeListeners(): Start notifying listener: " + listener);
                    }
                    listener.contentsChanged(this.event);
                    if (!TRACE_MODEL_CHANGE_LISTENERS) continue;
                    System.out.println("IpsModel.notfiyChangeListeners(): Finished notifying listener: " + listener);
                }
                catch (Exception e) {
                    IpsLog.log((IStatus)new IpsStatus("Error notifying IPS model change listener", e));
                }
            }
        }
    }

    private final class RunnableModificationStatusChangeListenerImplementation
    implements Runnable {
        private final ModificationStatusChangedEvent event;

        private RunnableModificationStatusChangeListenerImplementation(ModificationStatusChangedEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            CopyOnWriteArrayList<IModificationStatusChangeListener> copy = new CopyOnWriteArrayList<IModificationStatusChangeListener>(IpsModel.this.modificationStatusChangeListeners);
            for (IModificationStatusChangeListener listener : copy) {
                try {
                    if (TRACE_MODEL_CHANGE_LISTENERS) {
                        System.out.println("IpsModel.notfiyChangeListeners(): Start notifying listener: " + listener);
                    }
                    listener.modificationStatusHasChanged(this.event);
                    if (!TRACE_MODEL_CHANGE_LISTENERS) continue;
                    System.out.println("IpsModel.notifyModificationStatusChangeListener(): Finished notifying listener: " + listener);
                }
                catch (Exception e) {
                    IpsLog.log((IStatus)new IpsStatus("Error notifying IPS model ModificationStatusChangeListeners", e));
                }
            }
        }
    }
}

