/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.ipsproject.IIpsObjectPathContainer;
import org.faktorips.devtools.model.ipsproject.IIpsObjectPathContainerType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.util.ArgumentCheck;

public class IpsObjectPathContainerFactory {
    private Map<String, IIpsObjectPathContainerType> typesById = new HashMap<String, IIpsObjectPathContainerType>();

    public static final IpsObjectPathContainerFactory newFactoryBasedOnExtensions() {
        List<IIpsObjectPathContainerType> types = IIpsModelExtensions.get().getIpsObjectPathContainerTypes();
        return IpsObjectPathContainerFactory.newFactory(types);
    }

    public static final IpsObjectPathContainerFactory newFactory(List<IIpsObjectPathContainerType> types) {
        IpsObjectPathContainerFactory newFactory = new IpsObjectPathContainerFactory();
        for (IIpsObjectPathContainerType type : types) {
            if (type.getId() == null) {
                IpsLog.log((IStatus)new IpsStatus("Can't register type " + type + " as id is null."));
                continue;
            }
            IIpsObjectPathContainerType otherType = newFactory.getContainerType(type.getId());
            if (otherType != null && otherType != type) {
                IpsLog.log((IStatus)new IpsStatus("Can't register type " + type + ", as another type is registered with the same id, id=" + type.getId()));
                continue;
            }
            newFactory.registerContainerType(type);
        }
        return newFactory;
    }

    public IIpsObjectPathContainer newContainer(IIpsProject ipsProject, String containerTypeId, String optionalPath) {
        IIpsObjectPathContainerType type = this.getContainerType(containerTypeId);
        if (type == null) {
            return null;
        }
        return type.newContainer(ipsProject, optionalPath);
    }

    public IIpsObjectPathContainerType getContainerType(String containerTypeId) {
        return this.typesById.get(containerTypeId);
    }

    public boolean isRegistered(IIpsObjectPathContainerType type) {
        return type.equals(this.getContainerType(type.getId()));
    }

    public void registerContainerType(IIpsObjectPathContainerType newType) {
        ArgumentCheck.notNull((Object)newType.getId());
        IIpsObjectPathContainerType type = this.getContainerType(newType.getId());
        if (type != null & !newType.equals(type)) {
            throw new IllegalArgumentException("There is already the type " + type + " registererd for the ID " + newType.getId());
        }
        this.typesById.put(newType.getId(), newType);
    }

    public void unregisterContainerType(IIpsObjectPathContainerType type) {
        if (this.getContainerType(type.getId()) == null) {
            throw new IllegalArgumentException("The type " + type + " hasn't been registererd");
        }
        this.typesById.remove(type.getId());
    }

    public int getNumOfRegisteredTypes() {
        return this.typesById.size();
    }
}

