/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.faktorips.datatype.Datatype;
import org.faktorips.devtools.model.IClassLoaderProvider;
import org.faktorips.devtools.model.IVersionProvider;
import org.faktorips.devtools.model.builder.IDependencyGraph;
import org.faktorips.devtools.model.internal.ExtensionFunctionResolversCache;
import org.faktorips.devtools.model.internal.IpsObjectPathContainerFactory;
import org.faktorips.devtools.model.internal.ipsproject.properties.IpsProjectProperties;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsproject.IIpsArtefactBuilderSet;
import org.faktorips.devtools.model.ipsproject.IIpsObjectPathContainer;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.ipsproject.IIpsProjectProperties;
import org.faktorips.util.ArgumentCheck;

public class IpsProjectData {
    private final IIpsProject ipsProject;
    private final IpsObjectPathContainerFactory containerFactory;
    private final Map<ContainerTypeAndPath, IIpsObjectPathContainer> containers = new ConcurrentHashMap<ContainerTypeAndPath, IIpsObjectPathContainer>();
    private IIpsArtefactBuilderSet ipsArtefactBuilderSet;
    private IDependencyGraph dependencyGraph;
    private IClassLoaderProvider classLoaderProvider;
    private ExtensionFunctionResolversCache functionResolver;
    private volatile LinkedHashSet<IIpsSrcFile> markerEnums;
    private IpsProjectProperties projectProperties;
    private final LinkedHashMap<String, Datatype> projectDatatypesMap = new LinkedHashMap();
    private IVersionProvider<?> versionFormat;

    public IpsProjectData(IIpsProject ipsProject, IpsObjectPathContainerFactory containerFactory) {
        ArgumentCheck.notNull((Object)ipsProject);
        ArgumentCheck.notNull((Object)containerFactory);
        this.ipsProject = ipsProject;
        this.containerFactory = containerFactory;
    }

    public IIpsProject getIpsProject() {
        return this.ipsProject;
    }

    public IIpsObjectPathContainer getIpsObjectPathContainer(String containerTypeId, String optionalPath) {
        ArgumentCheck.notNull((Object)containerTypeId);
        ArgumentCheck.notNull((Object)optionalPath);
        ContainerTypeAndPath typeAndPath = new ContainerTypeAndPath(containerTypeId, optionalPath);
        return this.containers.computeIfAbsent(typeAndPath, $ -> this.containerFactory.newContainer(this.ipsProject, containerTypeId, optionalPath));
    }

    public String toString() {
        return "IpsProjectData [project=" + this.ipsProject.getName() + "]";
    }

    public IIpsArtefactBuilderSet getIpsArtefactBuilderSet() {
        return this.ipsArtefactBuilderSet;
    }

    public void setIpsArtefactBuilderSet(IIpsArtefactBuilderSet ipsArtefactBuilderSet) {
        this.ipsArtefactBuilderSet = ipsArtefactBuilderSet;
    }

    public IDependencyGraph getDependencyGraph() {
        return this.dependencyGraph;
    }

    public void setDependencyGraph(IDependencyGraph dependencyGraph) {
        this.dependencyGraph = dependencyGraph;
    }

    public IClassLoaderProvider getClassLoaderProvider() {
        return this.classLoaderProvider;
    }

    public void setClassLoaderProvider(IClassLoaderProvider classLoaderProvider) {
        this.classLoaderProvider = classLoaderProvider;
    }

    public ExtensionFunctionResolversCache getFunctionResolver() {
        return this.functionResolver;
    }

    public void setFunctionResolver(ExtensionFunctionResolversCache functionResolver) {
        this.functionResolver = functionResolver;
    }

    public IpsProjectProperties getProjectProperties() {
        return this.projectProperties;
    }

    public void setProjectProperties(IpsProjectProperties projectProperties) {
        this.projectProperties = projectProperties;
    }

    public LinkedHashMap<String, Datatype> getProjectDatatypesMap() {
        return this.projectDatatypesMap;
    }

    public IVersionProvider<?> getVersionProvider() {
        return this.versionFormat;
    }

    public void setVersionProvider(IVersionProvider<?> versionProvider) {
        this.versionFormat = versionProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashSet<IIpsSrcFile> getMarkerEnums() {
        LinkedHashSet<IIpsSrcFile> result = this.markerEnums;
        if (result != null) {
            return result;
        }
        IpsProjectData ipsProjectData = this;
        synchronized (ipsProjectData) {
            if (this.markerEnums == null) {
                this.markerEnums = this.initMarkerEnums();
            }
            return this.markerEnums;
        }
    }

    private LinkedHashSet<IIpsSrcFile> initMarkerEnums() {
        LinkedHashSet<IIpsSrcFile> result = new LinkedHashSet<IIpsSrcFile>();
        IIpsProjectProperties properties = this.ipsProject.getReadOnlyProperties();
        if (properties.isMarkerEnumsEnabled()) {
            LinkedHashSet<String> markerEnumsQNames = properties.getMarkerEnums();
            for (String qualifiedName : markerEnumsQNames) {
                IIpsSrcFile ipsSrcFile = this.ipsProject.findIpsSrcFile(IpsObjectType.ENUM_TYPE, qualifiedName);
                if (ipsSrcFile == null || !ipsSrcFile.exists()) continue;
                result.add(ipsSrcFile);
            }
        }
        return result;
    }

    static class ContainerTypeAndPath {
        private String type;
        private String path;

        ContainerTypeAndPath(String type, String path) {
            this.type = type;
            this.path = path;
        }

        public int hashCode() {
            return Objects.hash(this.path, this.type);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ContainerTypeAndPath other = (ContainerTypeAndPath)obj;
            return Objects.equals(this.path, other.path) && Objects.equals(this.type, other.type);
        }

        public String toString() {
            return "ContainerTypeAndPath [type=" + this.type + ", path=" + this.path + "]";
        }
    }
}

