/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal;

import org.faktorips.devtools.model.IVersion;
import org.faktorips.util.ArgumentCheck;
import org.osgi.framework.Version;

public class OsgiVersion
implements IVersion<OsgiVersion> {
    public static final OsgiVersion EMPTY_VERSION = new OsgiVersion(Version.emptyVersion);
    private final Version version;

    public OsgiVersion(String versionString) {
        ArgumentCheck.notNull((Object)versionString);
        this.version = new Version(versionString);
    }

    private OsgiVersion(Version version) {
        this.version = version;
    }

    @Override
    public String asString() {
        return this.version.toString();
    }

    @Override
    public String getUnqualifiedVersion() {
        if (this.version.getQualifier().isEmpty()) {
            return this.version.toString();
        }
        String versionString = this.version.toString();
        int qualifierSep = versionString.lastIndexOf(46);
        return versionString.substring(0, qualifierSep);
    }

    @Override
    public int compareTo(OsgiVersion osgiVersion) {
        return this.version.compareTo(osgiVersion.version);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        Object object = obj;
        if (object instanceof OsgiVersion) {
            void osgiVersion;
            OsgiVersion osgiVersion2 = (OsgiVersion)object;
            OsgiVersion cfr_ignored_0 = (OsgiVersion)object;
            Version otherVersion = osgiVersion.version;
            return this.version.equals((Object)otherVersion);
        }
        return false;
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public String toString() {
        return "OsgiVersion [version=" + this.version + "]";
    }

    @Override
    public boolean isEmptyVersion() {
        return Version.emptyVersion.equals((Object)this.version);
    }

    @Override
    public boolean isNotEmptyVersion() {
        return !this.isEmptyVersion();
    }
}

