/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal;

import java.beans.PropertyChangeEvent;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import org.faktorips.devtools.abstraction.AFile;
import org.faktorips.devtools.abstraction.AProject;
import org.faktorips.devtools.abstraction.AResource;
import org.faktorips.devtools.abstraction.AResourceDelta;
import org.faktorips.devtools.abstraction.AResourceDeltaVisitor;
import org.faktorips.devtools.abstraction.util.PathUtil;
import org.faktorips.devtools.model.ContentChangeEvent;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.internal.IpsModel;
import org.faktorips.devtools.model.internal.ipsobject.IpsSrcFileContent;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;

public class ResourceDeltaVisitor
implements AResourceDeltaVisitor {
    private final IpsModel ipsModel;
    private Set<String> fileExtensionsOfInterest = new HashSet<String>(20);

    public ResourceDeltaVisitor(IpsModel ipsModel) {
        IpsObjectType[] types;
        this.ipsModel = ipsModel;
        IpsObjectType[] ipsObjectTypeArray = types = ipsModel.getIpsObjectTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IpsObjectType type = ipsObjectTypeArray[n2];
            this.getFileExtensionsOfInterest().add(type.getFileExtension());
            ++n2;
        }
        this.getFileExtensionsOfInterest().add("ipsproject");
    }

    public boolean visit(AResourceDelta delta) {
        AResource resource = delta.getResource();
        return this.visitInternal(delta, resource);
    }

    boolean visitInternal(AResourceDelta delta, AResource resource) {
        if (resource == null || resource.getType() != AResource.AResourceType.FILE) {
            return true;
        }
        if (this.isRelatedFile(resource)) {
            if (this.ipsProjectPropertiesChanged(resource) || this.manifestChanged(resource)) {
                this.handleUpdateProjectSettings(resource);
            } else if (delta.getKind() == AResourceDelta.AResourceDeltaKind.REMOVED) {
                this.handleRemoved(resource);
            } else {
                this.handleOtherResourceChange(resource);
            }
        }
        return false;
    }

    private void handleUpdateProjectSettings(AResource resource) {
        AProject project = resource.getProject();
        if (project != null) {
            IIpsProject ipsProject = this.ipsModel.getIpsProject(project);
            this.ipsModel.clearProjectSpecificCaches(ipsProject);
            this.ipsModel.getValidationResultCache().clear();
        }
    }

    private void handleRemoved(AResource resource) {
        IIpsElement ipsElement = this.ipsModel.getIpsElement(resource);
        if (ipsElement instanceof IIpsSrcFile) {
            this.ipsModel.removeIpsSrcFileContent((IIpsSrcFile)ipsElement);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean handleOtherResourceChange(AResource resource) {
        IIpsElement element = this.ipsModel.findIpsElement(resource);
        IIpsElement iIpsElement = element;
        if (iIpsElement instanceof IIpsSrcFile) {
            void srcFile;
            IIpsSrcFile iIpsSrcFile = (IIpsSrcFile)iIpsElement;
            IIpsSrcFile cfr_ignored_0 = (IIpsSrcFile)iIpsElement;
            if (srcFile.isContainedInIpsRoot()) {
                IpsSrcFileContent content = this.ipsModel.getIpsSrcFileContent((IIpsSrcFile)srcFile);
                boolean isInSync = this.isInSync((IIpsSrcFile)srcFile, content);
                this.traceModelResourceVisited(resource, (IIpsSrcFile)srcFile, isInSync);
                if (!isInSync) {
                    this.handleNotSyncResource((IIpsSrcFile)srcFile);
                }
                return true;
            }
        }
        return true;
    }

    private boolean ipsProjectPropertiesChanged(AResource resource) {
        IIpsProject ipsProject;
        AProject project = resource.getProject();
        IIpsProject iIpsProject = ipsProject = project == null ? null : this.ipsModel.getIpsProject(project);
        return ipsProject != null && resource.equals(ipsProject.getIpsProjectPropertiesFile());
    }

    private boolean manifestChanged(AResource resource) {
        return resource.getProjectRelativePath().equals(Path.of("META-INF/MANIFEST.MF", new String[0]));
    }

    private void handleNotSyncResource(IIpsSrcFile srcFile) {
        this.ipsModel.ipsSrcFileContentHasChanged(ContentChangeEvent.newWholeContentChangedEvent(srcFile, new PropertyChangeEvent[0]));
    }

    private void traceModelResourceVisited(AResource resource, IIpsSrcFile srcFile, boolean isInSync) {
        if (IpsModel.TRACE_MODEL_MANAGEMENT) {
            System.out.println("IpsModel.ResourceDeltaVisitor.visit(): Received notification of IpsSrcFile change/delete on disk with modStamp " + resource.getModificationStamp() + ", Sync status=" + isInSync + ", " + srcFile + " Thread: " + Thread.currentThread().getName());
        }
    }

    private boolean isRelatedFile(AResource resource) {
        AFile file = (AFile)resource;
        return this.getFileExtensionsOfInterest().contains(file.getExtension()) || "META-INF/MANIFEST.MF".equals(PathUtil.toPortableString((Path)file.getProjectRelativePath()));
    }

    private boolean isInSync(IIpsSrcFile srcFile, IpsSrcFileContent content) {
        return content == null || content.wasModStampCreatedBySave(srcFile.getEnclosingResource().getModificationStamp());
    }

    public Set<String> getFileExtensionsOfInterest() {
        return this.fileExtensionsOfInterest;
    }
}

