/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal;

import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.abstraction.util.JavaConventions;
import org.faktorips.devtools.model.Validatable;
import org.faktorips.devtools.model.internal.Messages;
import org.faktorips.devtools.model.ipsobject.IIpsObject;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.internal.IpsStringUtils;

public class ValidationUtils {
    private ValidationUtils() {
    }

    public static final boolean checkIpsObjectReference(String objectName, IpsObjectType type, String propertyDisplayName, IIpsObjectPartContainer part, String propertyName, String msgCode, MessageList list) {
        if (!ValidationUtils.checkStringPropertyNotEmpty(objectName, propertyDisplayName, part, propertyName, msgCode, list)) {
            return false;
        }
        if (part.getIpsProject().findIpsSrcFile(type, objectName) == null) {
            String text = MessageFormat.format(Messages.ValidationUtils_msgObjectDoesNotExist, StringUtils.capitalize((String)propertyDisplayName), objectName);
            list.add(new Message(msgCode, text, Message.ERROR, (Object)part, new String[]{propertyName}));
            return false;
        }
        return true;
    }

    public static final IIpsObject checkAndGetIpsObjectReference(String objectName, IpsObjectType type, String propertyDisplayName, IIpsObjectPartContainer part, String propertyName, String msgCode, MessageList list, IIpsProject ipsProject) {
        if (!ValidationUtils.checkStringPropertyNotEmpty(objectName, propertyDisplayName, part, propertyName, msgCode, list)) {
            return null;
        }
        IIpsSrcFile srcFile = ipsProject.findIpsSrcFile(type, objectName);
        if (srcFile == null) {
            String text = MessageFormat.format(Messages.ValidationUtils_msgObjectDoesNotExist, StringUtils.capitalize((String)propertyDisplayName), objectName);
            list.add(new Message(msgCode, text, Message.ERROR, (Object)part, new String[]{propertyName}));
            return null;
        }
        return srcFile.getIpsObject();
    }

    public static final Datatype checkDatatypeReference(String datatypeName, boolean voidAllowed, IIpsObjectPart part, String propertyName, String msgcode, MessageList list, IIpsProject ipsProject) {
        if (!ValidationUtils.checkStringPropertyNotEmpty(datatypeName, "Datatype", part, propertyName, msgcode, list)) {
            return null;
        }
        Datatype datatype = ipsProject.findDatatype(datatypeName);
        if (datatype == null) {
            String text = MessageFormat.format(Messages.ValidationUtils_msgDatatypeDoesNotExist, datatypeName, part.getName());
            list.add(new Message(msgcode, text, Message.ERROR, (Object)part, new String[]{propertyName}));
            return null;
        }
        if (datatype instanceof ValueDatatype) {
            list.add(((ValueDatatype)datatype).checkReadyToUse(), new ObjectProperty((Object)part, propertyName), true);
        }
        if (datatype.isVoid() && !voidAllowed) {
            String text = Messages.ValidationUtils_msgVoidNotAllowed;
            list.add(new Message("", text, Message.ERROR, (Object)part, new String[]{propertyName}));
        }
        return datatype;
    }

    public static final ValueDatatype checkValueDatatypeReference(String datatypeName, boolean voidAllowed, IIpsObjectPart part, String propertyName, String msgcode, MessageList list) {
        if (!ValidationUtils.checkStringPropertyNotEmpty(datatypeName, "Datatype", part, propertyName, msgcode, list)) {
            return null;
        }
        ValueDatatype datatype = part.getIpsProject().findValueDatatype(datatypeName);
        if (datatype == null) {
            String text = MessageFormat.format(Messages.ValidationUtils_msgDatatypeDoesNotExist, datatypeName, part.getName());
            list.add(new Message(msgcode, text, Message.ERROR, (Object)part, new String[]{propertyName}));
            return null;
        }
        list.add(datatype.checkReadyToUse(), new ObjectProperty((Object)part, propertyName), true);
        if (datatype.isVoid() && !voidAllowed) {
            String text = Messages.ValidationUtils_msgVoidNotAllowed;
            list.add(new Message(msgcode, text, Message.ERROR, (Object)part, new String[]{propertyName}));
        }
        return datatype;
    }

    public static final boolean checkValue(String valueDatatype, String value, IIpsObjectPart part, String propertyName, MessageList list) {
        return ValidationUtils.checkValue(part.getIpsProject().findValueDatatype(valueDatatype), valueDatatype, value, part, propertyName, list);
    }

    public static final boolean checkValue(ValueDatatype datatype, String datatypeName, String value, Object part, String propertyName, MessageList list) {
        if (datatype == null) {
            String text = MessageFormat.format(Messages.ValidationUtils_VALUE_VALUEDATATYPE_NOT_FOUND, propertyName, value, datatypeName);
            Message msg = new Message("CantCheckValueBecauseValueDatatypeCantBeFound", text, Message.ERROR, part, new String[]{propertyName});
            list.add(msg);
            return false;
        }
        if (datatype.checkReadyToUse().containsErrorMsg()) {
            String text = MessageFormat.format(Messages.ValidationUtils_VALUEDATATYPE_INVALID, propertyName, datatype.getName());
            Message msg = new Message("CantCheckValueBecauseValueDatatypeIsInvalid", text, Message.WARNING, part, new String[]{propertyName});
            list.add(msg);
            return false;
        }
        return ValidationUtils.checkParsable(datatype, value, part, propertyName, list);
    }

    public static boolean checkParsable(ValueDatatype datatype, String value, Object part, String propertyName, MessageList list) {
        if (!datatype.isParsable(value)) {
            String text = Datatype.MONEY.equals((Object)datatype) ? MessageFormat.format(Messages.ValidationUtils_NO_INSTANCE_OF_VALUEDATATYPE_MONEY, propertyName, value, datatype.getName()) : MessageFormat.format(Messages.ValidationUtils_NO_INSTANCE_OF_VALUEDATATYPE, value, propertyName, datatype.getName());
            Message msg = new Message("ValueIsNotInstanceOfValueDatatype", text, Message.ERROR, part, new String[]{propertyName});
            list.add(msg);
            return false;
        }
        return true;
    }

    public static final boolean checkStringPropertyNotEmpty(String propertyValue, String propertyDisplayName, Validatable object, String propertyName, String msgCode, MessageList list) {
        if (IpsStringUtils.isEmpty((String)propertyValue)) {
            String text = MessageFormat.format(Messages.ValidationUtils_msgPropertyMissing, StringUtils.capitalize((String)propertyDisplayName));
            list.add(new Message(msgCode, text, Message.ERROR, (Object)object, new String[]{propertyName}));
            return false;
        }
        return true;
    }

    public static boolean validateFieldName(String name, IIpsProject ipsProject) {
        Runtime.Version sourceVersion = ipsProject.getJavaProject().getSourceVersion();
        boolean isValidFieldName = JavaConventions.validateName((String)StringUtils.capitalize((String)name), (Runtime.Version)sourceVersion);
        if (isValidFieldName) {
            return JavaConventions.validateName((String)StringUtils.uncapitalize((String)name), (Runtime.Version)sourceVersion);
        }
        return isValidFieldName;
    }

    public static MessageList validateJavaTypeName(String name) {
        return JavaConventions.validateTypeName((String)name);
    }

    public static boolean validateJavaIdentifier(String name, IIpsProject ipsProject) {
        Runtime.Version sourceVersion = ipsProject.getJavaProject().getSourceVersion();
        return JavaConventions.validateName((String)name, (Runtime.Version)sourceVersion);
    }
}

