/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal;

import org.faktorips.devtools.model.internal.IMetaModelValidator;
import org.faktorips.devtools.model.internal.Messages;
import org.faktorips.devtools.model.valueset.IValueSet;
import org.faktorips.runtime.MessageList;

public class ValueSetNullIncompatibleValidator
implements IMetaModelValidator {
    public static final String MSGCODE_INCOMPATIBLE_VALUESET = "ValueSetNullIncompatibleValidator_NullIncompatible";
    private final IValueSet presentValueset;
    private final IValueSet currentValueset;

    public ValueSetNullIncompatibleValidator(IValueSet presetValueset, IValueSet currentValueset) {
        this.presentValueset = presetValueset;
        this.currentValueset = currentValueset;
    }

    @Override
    public MessageList validateIfPossible() {
        MessageList messageList = new MessageList();
        this.validateAndAppendMessages(messageList);
        return messageList;
    }

    @Override
    public boolean canValidate() {
        return this.currentValueset != null && this.presentValueset != null;
    }

    @Override
    public void validateAndAppendMessages(MessageList messageList) {
        if (this.canValidate()) {
            this.validateInternal(messageList);
        }
    }

    private void validateInternal(MessageList messageList) {
        if (this.isNullIncompatible()) {
            messageList.newError(MSGCODE_INCOMPATIBLE_VALUESET, Messages.ValueSetNullIncompatibleValidator_Msg_NullNotAllowed, (Object)this.currentValueset, new String[]{"containsNull"});
        }
    }

    private boolean isNullIncompatible() {
        return this.currentValueset.isContainsNull() && !this.presentValueset.isContainsNull();
    }
}

