/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.devtools.model.internal.ipsobject.Messages;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XsdValidationHandler
implements ErrorHandler {
    private final Set<String> xsdValidationErrors = new LinkedHashSet<String>();
    private final Set<String> xsdValidationWarnings = new LinkedHashSet<String>();

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        String localizedMessage = exception.getLocalizedMessage();
        IpsLog.log((IStatus)new IpsStatus(2, this.createLogMessage(localizedMessage)));
        if (this.isXsdSchemaMissingError(localizedMessage)) {
            this.xsdValidationWarnings.add(Messages.IpsSrcFileContent_msgXsdValidationReferenzIsMissing);
        } else {
            this.xsdValidationWarnings.add(localizedMessage);
        }
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        String localizedMessage = exception.getLocalizedMessage();
        if (this.isXsdSchemaMissingError(localizedMessage)) {
            this.warning(exception);
        } else {
            IpsLog.log((IStatus)new IpsStatus(4, this.createLogMessage(localizedMessage)));
            this.xsdValidationErrors.add(localizedMessage);
        }
    }

    public Set<String> getXsdValidationErrors() {
        return Set.copyOf(this.xsdValidationErrors);
    }

    public Set<String> getXsdValidationWarnings() {
        return Set.copyOf(this.xsdValidationWarnings);
    }

    private boolean isXsdSchemaMissingError(String localizedMessage) {
        return StringUtils.startsWith((CharSequence)localizedMessage, (CharSequence)"cvc-elt.1.a");
    }

    private String createLogMessage(String localizedMessage) {
        return "XSD validation: " + localizedMessage;
    }

    public void clear() {
        this.xsdValidationErrors.clear();
        this.xsdValidationWarnings.clear();
    }
}

