/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.builder;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.faktorips.devtools.abstraction.Abstractions;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.builder.IDependencyGraph;
import org.faktorips.devtools.model.dependency.IDependency;
import org.faktorips.devtools.model.ipsobject.IIpsObject;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.util.ArgumentCheck;
import org.faktorips.util.MultiMap;

public class DependencyGraph
implements Serializable,
IDependencyGraph {
    public static final boolean TRACE_DEPENDENCY_GRAPH_MANAGEMENT = Boolean.parseBoolean(Abstractions.getDebugOption((String)"org.faktorips.devtools.model/trace/dependencygraphmanagement"));
    private static final long serialVersionUID = 5692023485881401223L;
    private final MultiMap<Object, IDependency> dependantsForMap = MultiMap.createWithSetsAsValues();
    private final MultiMap<QualifiedNameType, IDependency> dependsOnMap = MultiMap.createWithSetsAsValues();
    private transient IIpsProject ipsProject;

    public DependencyGraph(IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object)ipsProject, (Object)this);
        this.ipsProject = ipsProject;
        this.init();
    }

    @Override
    public IIpsProject getIpsProject() {
        return this.ipsProject;
    }

    public void setIpsProject(IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object)ipsProject, (Object)this);
        if (this.ipsProject == null) {
            this.ipsProject = ipsProject;
            return;
        }
        if (!this.ipsProject.equals(ipsProject)) {
            this.ipsProject = ipsProject;
            this.init();
        }
    }

    @Override
    public void reInit() {
        this.init();
    }

    private void init() {
        this.dependantsForMap.clear();
        this.dependsOnMap.clear();
        ArrayList<IIpsSrcFile> allSrcFiles = new ArrayList<IIpsSrcFile>();
        this.ipsProject.collectAllIpsSrcFilesOfSrcFolderEntries(allSrcFiles);
        for (IIpsSrcFile file : allSrcFiles) {
            if (!file.exists()) continue;
            IIpsObject ipsObject = file.getIpsObject();
            this.addEntries(ipsObject);
        }
    }

    private void addEntries(IIpsObject ipsObject) {
        IDependency[] dependencies = ipsObject.dependsOn();
        if (dependencies != null) {
            QualifiedNameType qualifiedNameType = ipsObject.getQualifiedNameType();
            this.addEntriesToDependsOnMap(qualifiedNameType, dependencies);
            this.addEntryToDependantsForMap(dependencies);
        }
    }

    private void addEntriesToDependsOnMap(QualifiedNameType requestedNameType, IDependency[] dependsOn) {
        this.dependsOnMap.putReplace((Object)requestedNameType, Arrays.asList(dependsOn));
    }

    private void addEntryToDependantsForMap(IDependency[] dependsOn) {
        IDependency[] iDependencyArray = dependsOn;
        int n = dependsOn.length;
        int n2 = 0;
        while (n2 < n) {
            IDependency element = iDependencyArray[n2];
            this.dependantsForMap.put(element.getTarget(), (Object[])new IDependency[]{element});
            ++n2;
        }
    }

    @Override
    public IDependency[] getDependants(QualifiedNameType id) {
        Collection<IDependency> qualfiedNameTypes = this.getDependantsAsList(id);
        if (this.isUsedAsDatatype(id)) {
            Collection<IDependency> additionalNameTypes = this.getDependantsAsList(id.getName());
            if (qualfiedNameTypes == null) {
                qualfiedNameTypes = additionalNameTypes;
            } else if (additionalNameTypes != null) {
                qualfiedNameTypes.addAll(additionalNameTypes);
            }
        }
        if (qualfiedNameTypes == null) {
            return new IDependency[0];
        }
        return qualfiedNameTypes.toArray(new IDependency[qualfiedNameTypes.size()]);
    }

    private boolean isUsedAsDatatype(QualifiedNameType id) {
        return id.getIpsObjectType().equals(IpsObjectType.POLICY_CMPT_TYPE) || id.getIpsObjectType().equals(IpsObjectType.PRODUCT_CMPT_TYPE) || id.getIpsObjectType().equals(IpsObjectType.ENUM_TYPE);
    }

    private Collection<IDependency> getDependantsAsList(Object target) {
        return new ArrayList<IDependency>(this.dependantsForMap.get(target));
    }

    @Override
    public void update(QualifiedNameType qName) {
        if (qName == null) {
            return;
        }
        this.removeDependency(qName);
        IIpsObject ipsObject = this.ipsProject.findIpsObject(qName);
        if (ipsObject != null) {
            this.addEntries(ipsObject);
        }
    }

    private void removeDependency(QualifiedNameType qName) {
        Collection dependsOnList = this.dependsOnMap.remove((Object)qName);
        if (dependsOnList != null && !dependsOnList.isEmpty()) {
            for (IDependency dependency : dependsOnList) {
                Collection<IDependency> dependants = this.getDependantsAsList(dependency.getTarget());
                if (dependants == null) continue;
                for (IDependency dependant : dependants) {
                    if (!dependant.getSource().equals(qName)) continue;
                    this.dependantsForMap.remove(dependency.getTarget(), (Object)dependant);
                }
            }
        }
    }

    public String toString() {
        return "DependencyGraph for " + this.ipsProject.getName();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.ipsProject != null ? this.ipsProject.getName() : null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        String projectName = (String)s.readObject();
        if (projectName != null) {
            this.ipsProject = IIpsModel.get().getIpsProject(projectName);
        }
    }
}

