/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.builder;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.faktorips.devtools.model.DependencyType;
import org.faktorips.devtools.model.builder.IDependencyGraph;
import org.faktorips.devtools.model.dependency.IDependency;
import org.faktorips.devtools.model.enums.IEnumContent;
import org.faktorips.devtools.model.enums.IEnumType;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.util.MultiMap;

public class DependencyResolver {
    private final IIpsProject referenceProject;
    private final IIpsProject ipsProject;
    private final IDependencyGraph graph;
    private final MultiMap<IIpsProject, IDependency> dependenciesForProjectMap;

    public DependencyResolver(IIpsProject ipsProject) {
        this.ipsProject = ipsProject;
        this.referenceProject = ipsProject;
        this.graph = this.getDependencyGraph();
        this.dependenciesForProjectMap = MultiMap.createWithSetsAsValues();
    }

    private DependencyResolver(IIpsProject ipsProject, DependencyResolver previousResolver) {
        this.ipsProject = ipsProject;
        this.graph = this.getDependencyGraph();
        this.referenceProject = previousResolver.referenceProject;
        this.dependenciesForProjectMap = previousResolver.dependenciesForProjectMap;
    }

    private IDependencyGraph getDependencyGraph() {
        return this.ipsProject.getDependencyGraph();
    }

    public MultiMap<IIpsProject, IDependency> collectDependenciesForIncrementalBuild(List<IIpsSrcFile> addedOrChangedIpsSrcFiles, List<IIpsSrcFile> removedIpsSrcFiles) {
        if (this.canCollectDependencies()) {
            this.collectDependenciesFor(addedOrChangedIpsSrcFiles);
            this.collectDependenciesFor(removedIpsSrcFiles);
        }
        return this.dependenciesForProjectMap;
    }

    private boolean canCollectDependencies() {
        return this.graph != null && this.ipsProject.canBeBuild();
    }

    private void collectDependenciesFor(List<IIpsSrcFile> ipsSrcFiles) {
        for (IIpsSrcFile ipsSrcFile : ipsSrcFiles) {
            this.collectDependencies(ipsSrcFile.getQualifiedNameType(), new HashSet<IIpsProject>(), EnumSet.allOf(DependencyType.class));
        }
    }

    void collectDependencies(QualifiedNameType root, Set<IIpsProject> visitedProjects, EnumSet<DependencyType> transitiveTypes) {
        if (this.canCollectDependencies()) {
            this.collectEnumContentDependencies(root, transitiveTypes);
            this.collectDependencies(root, transitiveTypes);
            this.collectDependenciesOfDependantProjects(root, visitedProjects, transitiveTypes);
        }
    }

    private void collectEnumContentDependencies(QualifiedNameType root, EnumSet<DependencyType> transitiveTypes) {
        IIpsProject enumTypeProject;
        IEnumContent enumContent;
        if (this.isEnumContent(root) && transitiveTypes.contains((Object)DependencyType.DATATYPE) && (enumContent = this.findEnumContentIpsObject(root)) != null && (enumTypeProject = this.getEnumTypeProject(enumContent)) != null) {
            this.collectEnumTypeDependencies(enumContent, enumTypeProject, transitiveTypes);
        }
    }

    private boolean isEnumContent(QualifiedNameType root) {
        return IpsObjectType.ENUM_CONTENT.equals(root.getIpsObjectType());
    }

    private IEnumContent findEnumContentIpsObject(QualifiedNameType root) {
        return (IEnumContent)this.ipsProject.findIpsObject(root);
    }

    private IIpsProject getEnumTypeProject(IEnumContent enumContent) {
        IEnumType enumType = enumContent.findEnumType(this.ipsProject);
        if (enumType != null) {
            return enumType.getIpsProject();
        }
        return null;
    }

    private void collectEnumTypeDependencies(IEnumContent enumContent, IIpsProject enumTypeProject, EnumSet<DependencyType> transitiveTypes) {
        HashSet<IIpsProject> visitedProjectsForEnumContent = new HashSet<IIpsProject>();
        DependencyResolver enumTypedependencyResolver = new DependencyResolver(enumTypeProject, this);
        QualifiedNameType enumType = new QualifiedNameType(enumContent.getEnumType(), IpsObjectType.ENUM_TYPE);
        enumTypedependencyResolver.collectDependencies(enumType, visitedProjectsForEnumContent, transitiveTypes);
    }

    private void collectDependencies(QualifiedNameType root, EnumSet<DependencyType> transitiveTypes) {
        IDependency[] dependencies;
        IDependency[] iDependencyArray = dependencies = this.graph.getDependants(root);
        int n = dependencies.length;
        int n2 = 0;
        while (n2 < n) {
            IDependency dependency = iDependencyArray[n2];
            if (!this.isAlreadyCollected(dependency) && this.isProperDependency(dependency, transitiveTypes)) {
                if (this.ipsProject.equals(this.referenceProject) || this.ipsProject.isReferencing(this.referenceProject)) {
                    this.dependenciesForProjectMap.put((Object)this.ipsProject, (Object[])new IDependency[]{dependency});
                }
                this.collectTransitivDependencies(dependency, transitiveTypes);
            }
            ++n2;
        }
    }

    private boolean isAlreadyCollected(IDependency dependency) {
        return this.dependenciesForProjectMap.get((Object)this.ipsProject).contains(dependency);
    }

    private boolean isProperDependency(IDependency dependency, EnumSet<DependencyType> transitiveTypes) {
        return transitiveTypes.contains((Object)dependency.getType());
    }

    private void collectTransitivDependencies(IDependency dependency, EnumSet<DependencyType> transitiveTypes) {
        this.collectDependencies(dependency.getSource(), new HashSet<IIpsProject>(), dependency.getType().getNextTransitiveTypes(transitiveTypes, this.ipsProject));
    }

    private void collectDependenciesOfDependantProjects(QualifiedNameType root, Set<IIpsProject> visitedProjects, EnumSet<DependencyType> transitiveTypes) {
        IIpsProject[] dependantProjects;
        visitedProjects.add(this.ipsProject);
        IIpsProject[] iIpsProjectArray = dependantProjects = this.ipsProject.findReferencingProjects(false);
        int n = dependantProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsProject dependantProject = iIpsProjectArray[n2];
            if (!visitedProjects.contains(dependantProject) && (dependantProject.equals(this.referenceProject) || this.referenceProject.isReferencing(dependantProject) || dependantProject.isReferencing(this.referenceProject))) {
                DependencyResolver dependencyResolver = new DependencyResolver(dependantProject, this);
                dependencyResolver.collectDependencies(root, visitedProjects, transitiveTypes);
            }
            ++n2;
        }
    }

    public MultiMap<IIpsProject, IDependency> getCollectedDependencies() {
        return this.dependenciesForProjectMap;
    }
}

