/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.builder;

import org.apache.commons.lang3.StringUtils;
import org.faktorips.datatype.Datatype;
import org.faktorips.devtools.model.ipsproject.IJavaNamingConvention;

public class JavaNamingConvention
implements IJavaNamingConvention {
    @Override
    public String getPublishedInterfaceName(String name) {
        return "I" + name;
    }

    @Override
    public String getImplementationClassName(String name) {
        return name;
    }

    @Override
    public String getImplementationClassNameForPublishedInterfaceName(String publishedInterfaceName) {
        return this.getImplementationClassName(publishedInterfaceName.substring(1));
    }

    @Override
    public String getConstantClassVarName(String propertyName) {
        return StringUtils.upperCase((String)propertyName);
    }

    @Override
    public String getMemberVarName(String propertyName) {
        return StringUtils.uncapitalize((String)propertyName);
    }

    @Override
    public String getMultiValueMemberVarName(String propertyNamePlural) {
        return StringUtils.uncapitalize((String)propertyNamePlural);
    }

    @Override
    public String getMultiValueGetterMethodName(String propertyNamePlural) {
        return "get" + StringUtils.capitalize((String)propertyNamePlural);
    }

    @Override
    public String getGetterMethodName(String propertyName, Class<?> datatype) {
        if (datatype.equals(Datatype.PRIMITIVE_BOOLEAN.getClass())) {
            return "is" + StringUtils.capitalize((String)propertyName);
        }
        return "get" + StringUtils.capitalize((String)propertyName);
    }

    @Override
    public String getGetterMethodName(String propertyName, Datatype datatype) {
        if (datatype.equals(Datatype.PRIMITIVE_BOOLEAN)) {
            return "is" + StringUtils.capitalize((String)propertyName);
        }
        return "get" + StringUtils.capitalize((String)propertyName);
    }

    @Override
    public String getGetterMethodName(String propertyName) {
        return "get" + StringUtils.capitalize((String)propertyName);
    }

    @Override
    public String getSetterMethodName(String propertyName) {
        return "set" + StringUtils.capitalize((String)propertyName);
    }

    @Override
    public int getModifierForPublicInterfaceMethod() {
        return 1;
    }

    @Override
    public String getTypeName(String name) {
        return StringUtils.capitalize((String)name);
    }

    @Override
    public String getEnumLiteral(String name) {
        String enumLiteral = StringUtils.upperCase((String)name);
        enumLiteral = enumLiteral.replace("\u00c4", "AE");
        enumLiteral = enumLiteral.replace("\u00d6", "OE");
        enumLiteral = enumLiteral.replace("\u00dc", "UE");
        enumLiteral = enumLiteral.replace("\u00df", "SS");
        return this.getValidJavaIdentifier(enumLiteral);
    }

    @Override
    public String getValidJavaIdentifier(String identifier) {
        char[] characters = identifier.toCharArray();
        int i = 0;
        while (i < characters.length) {
            if (!Character.isJavaIdentifierPart(characters[i])) {
                characters[i] = 95;
            }
            ++i;
        }
        return Character.isJavaIdentifierStart(characters[0]) ? String.valueOf(characters) : String.valueOf('_') + String.valueOf(characters);
    }

    @Override
    public String getToDoMarker() {
        return "TODO";
    }
}

