/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.builder.flidentifier;

import java.util.LinkedList;
import java.util.List;
import org.faktorips.datatype.Datatype;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.IMultiLanguageSupport;
import org.faktorips.devtools.model.internal.builder.flidentifier.IdentifierProposal;
import org.faktorips.devtools.model.internal.builder.flidentifier.ParsingContext;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.IdentifierNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.IdentifierNodeFactory;
import org.faktorips.devtools.model.ipsobject.IDescribedElement;
import org.faktorips.devtools.model.ipsobject.ILabeledElement;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.IExpression;
import org.faktorips.devtools.model.util.TextRegion;
import org.faktorips.runtime.internal.IpsStringUtils;

public abstract class AbstractIdentifierNodeParser {
    public static final String NAME_DESCRIPTION_SEPERATOR = " - ";
    private final ParsingContext parsingContext;
    private Datatype contextType;
    private TextRegion textRegion;

    public AbstractIdentifierNodeParser(ParsingContext parsingContext) {
        this.parsingContext = parsingContext;
        this.setContextType(this.getExpression().findProductCmptType(this.getIpsProject()));
    }

    public ParsingContext getParsingContext() {
        return this.parsingContext;
    }

    public IdentifierNode parse(TextRegion textRegion) {
        this.textRegion = textRegion;
        if (this.getPreviousNode() == null) {
            this.setContextType(this.getExpression().findProductCmptType(this.getIpsProject()));
        } else {
            this.setContextType(this.getPreviousNode().getDatatype());
        }
        return this.parse();
    }

    protected abstract IdentifierNode parse();

    public IExpression getExpression() {
        return this.getParsingContext().getExpression();
    }

    public IIpsProject getIpsProject() {
        return this.getParsingContext().getIpsProject();
    }

    protected String getIdentifierPart() {
        return this.textRegion.getTextRegionString();
    }

    public Datatype getContextType() {
        return this.contextType;
    }

    public boolean isAllowedType() {
        return true;
    }

    public void setContextType(Datatype contextType) {
        this.contextType = contextType;
    }

    protected boolean isContextTypeFormulaType() {
        return this.isAllowedType() && this.getContextType() == this.getExpression().findProductCmptType(this.getIpsProject());
    }

    public IdentifierNode getPreviousNode() {
        return this.getParsingContext().getPreviousNode();
    }

    public LinkedList<IdentifierNode> getPreviousNodes() {
        return this.getParsingContext().getNodes();
    }

    public IdentifierNodeFactory nodeFactory() {
        return new IdentifierNodeFactory(this.getTextRegion(), this.getIpsProject());
    }

    public TextRegion getTextRegion() {
        return this.textRegion;
    }

    public abstract List<IdentifierProposal> getProposals(String var1);

    protected String getNameAndDescription(IIpsElement ipsElement, IMultiLanguageSupport multiLanguageSupport) {
        return this.getNameAndDescription(this.getName(ipsElement, multiLanguageSupport), this.getDescription(ipsElement, multiLanguageSupport));
    }

    protected String getNameAndDescription(String name, String description) {
        StringBuilder result = new StringBuilder();
        result.append(name);
        if (IpsStringUtils.isNotBlank((String)description)) {
            result.append(NAME_DESCRIPTION_SEPERATOR).append(description);
        }
        return result.toString();
    }

    protected String getName(IIpsElement ipsElement, IMultiLanguageSupport multiLanguageSupport) {
        if (ipsElement instanceof ILabeledElement) {
            return multiLanguageSupport.getLocalizedLabel((ILabeledElement)ipsElement);
        }
        return ipsElement.getName();
    }

    protected String getDescription(IIpsElement ipsElement, IMultiLanguageSupport multiLanguageSupport) {
        if (ipsElement instanceof IDescribedElement) {
            return multiLanguageSupport.getLocalizedDescription((IDescribedElement)ipsElement);
        }
        return null;
    }
}

