/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.builder.flidentifier;

import java.util.Locale;
import org.faktorips.codegen.CodeFragment;
import org.faktorips.devtools.model.internal.builder.flidentifier.IdentifierNodeGenerator;
import org.faktorips.devtools.model.internal.builder.flidentifier.IdentifierNodeGeneratorFactory;
import org.faktorips.devtools.model.internal.builder.flidentifier.IdentifierParser;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.IdentifierNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.IdentifierNodeType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.IExpression;
import org.faktorips.fl.CompilationResult;
import org.faktorips.fl.ExprCompiler;
import org.faktorips.fl.IdentifierResolver;
import org.faktorips.util.ArgumentCheck;

public abstract class AbstractIdentifierResolver<T extends CodeFragment>
implements IdentifierResolver<T> {
    private final IExpression expression;
    private final ExprCompiler<T> exprCompiler;
    private final IIpsProject ipsProject;
    private final IdentifierParser parser;

    public AbstractIdentifierResolver(IExpression expression, ExprCompiler<T> exprCompiler) {
        ArgumentCheck.notNull((Object)expression, (Object)this);
        ArgumentCheck.notNull(exprCompiler, (Object)this);
        this.expression = expression;
        this.exprCompiler = exprCompiler;
        this.ipsProject = expression.getIpsProject();
        this.parser = new IdentifierParser(expression, this.ipsProject);
    }

    public IExpression getExpression() {
        return this.expression;
    }

    public ExprCompiler<T> getExprCompiler() {
        return this.exprCompiler;
    }

    public IIpsProject getIpsProject() {
        return this.ipsProject;
    }

    public IdentifierParser getParser() {
        return this.parser;
    }

    public CompilationResult<T> compile(String identifier, ExprCompiler<T> exprCompiler, Locale locale) {
        IdentifierNode identifierNode = this.parseIdentifier(identifier);
        IdentifierNodeType nodeType = IdentifierNodeType.getNodeType(identifierNode.getClass());
        IdentifierNodeGenerator<T> generator = nodeType.getGenerator(this.getGeneratorFactory());
        CompilationResult<T> contextCompilationResult = this.getStartingCompilationResult();
        return generator.generateNode(identifierNode, contextCompilationResult);
    }

    public IdentifierNode parseIdentifier(String identifier) {
        return this.getParser().parse(identifier);
    }

    protected abstract IdentifierNodeGeneratorFactory<T> getGeneratorFactory();

    protected abstract CompilationResult<T> getStartingCompilationResult();
}

