/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.builder.flidentifier;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.faktorips.devtools.model.IMultiLanguageSupport;
import org.faktorips.devtools.model.internal.builder.flidentifier.IdentifierProposal;
import org.faktorips.devtools.model.internal.builder.flidentifier.IdentifierProposalCollector;
import org.faktorips.devtools.model.internal.builder.flidentifier.Messages;
import org.faktorips.devtools.model.internal.builder.flidentifier.ParsingContext;
import org.faktorips.devtools.model.internal.builder.flidentifier.TypeBasedIdentifierParser;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.IdentifierNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.IdentifierNodeType;
import org.faktorips.devtools.model.pctype.IPolicyCmptType;
import org.faktorips.devtools.model.type.IAssociation;
import org.faktorips.util.StringUtil;

public class AssociationParser
extends TypeBasedIdentifierParser {
    static final String ASSOCIATION_TARGET_SEPERATOR = " -> ";
    static final String INDEX_PROPOSAL = "[0]";
    static final String QUALIFIER_PROPOSAL = "[\"";
    static final String QUALIFIER_PROPOSAL_LABEL = "[\"...\"]";

    public AssociationParser(ParsingContext parsingContext) {
        super(parsingContext);
    }

    @Override
    public boolean isAllowedType() {
        return super.isAllowedType() && super.getContextType() instanceof IPolicyCmptType;
    }

    @Override
    public IPolicyCmptType getContextType() {
        return (IPolicyCmptType)super.getContextType();
    }

    @Override
    protected IdentifierNode parseInternal() {
        IPolicyCmptType policyCmptType = this.getContextType();
        IAssociation association = policyCmptType.findAssociation(this.getAssociationName(), this.getIpsProject());
        if (association != null) {
            return this.createNodeFor(association);
        }
        return null;
    }

    private IdentifierNode createNodeFor(IAssociation association) {
        return this.nodeFactory().createAssociationNode(association, this.isListOfTypeContext());
    }

    protected String getAssociationName() {
        return this.getIdentifierPart();
    }

    @Override
    public List<IdentifierProposal> getProposals(String prefix) {
        if (this.isAllowedType()) {
            return this.getProposalsFor(prefix);
        }
        return Collections.emptyList();
    }

    private void addAssociationProposals(IAssociation association, String prefix, IdentifierProposalCollector collector) {
        collector.addMatchingNode(this.getText(association, ""), this.getDisplayText(association), this.getDescription(association), prefix, IdentifierNodeType.ASSOCIATION);
        collector.addMatchingNode(this.getText(association, INDEX_PROPOSAL), this.getIndexDisplayText(association), this.getIndexDescription(association), prefix, IdentifierNodeType.ASSOCIATION);
        collector.addMatchingNode(this.getText(association, QUALIFIER_PROPOSAL), this.getQualifierDisplayText(association), this.getQualifierDescription(association), prefix, IdentifierNodeType.ASSOCIATION);
    }

    private String getText(IAssociation association, String proposalSuffix) {
        return String.valueOf(association.getName()) + proposalSuffix;
    }

    private List<IAssociation> getAllAssociations() {
        return this.getContextType().findAllAssociations(this.getIpsProject());
    }

    private List<IdentifierProposal> getProposalsFor(String prefixSuffix) {
        IdentifierProposalCollector collector = new IdentifierProposalCollector();
        List<IAssociation> allAssociations = this.getAllAssociations();
        for (IAssociation association : allAssociations) {
            this.addAssociationProposals(association, prefixSuffix, collector);
        }
        return collector.getProposals();
    }

    String getDisplayText(IAssociation association) {
        return String.valueOf(this.getText(association, "")) + this.getAssociationTarget(association, association.is1ToMany());
    }

    String getIndexDisplayText(IAssociation association) {
        return String.valueOf(this.getText(association, INDEX_PROPOSAL)) + this.getAssociationTarget(association, false);
    }

    private String getQualifierDisplayText(IAssociation association) {
        return String.valueOf(this.getText(association, QUALIFIER_PROPOSAL_LABEL)) + this.getAssociationTarget(association, association.is1ToManyIgnoringQualifier());
    }

    private String getAssociationTarget(IAssociation association, boolean oneToMany) {
        String associationTarget = ASSOCIATION_TARGET_SEPERATOR;
        associationTarget = oneToMany ? String.valueOf(associationTarget) + MessageFormat.format(Messages.AssociationParser_ListDatatypeDescriptionPrefix, this.getUnqualifiedTargetName(association)) : String.valueOf(associationTarget) + this.getUnqualifiedTargetName(association);
        return associationTarget;
    }

    private String getUnqualifiedTargetName(IAssociation association) {
        return StringUtil.unqualifiedName((String)association.getTarget());
    }

    String getDescription(IAssociation association) {
        IMultiLanguageSupport multiLanguageSupport = this.getParsingContext().getMultiLanguageSupport();
        StringBuilder description = new StringBuilder();
        description.append(this.getDisplayText(association)).append("\n\n").append(multiLanguageSupport.getLocalizedDescription(association));
        return description.toString();
    }

    String getIndexDescription(IAssociation association) {
        IMultiLanguageSupport multiLanguageSupport = this.getParsingContext().getMultiLanguageSupport();
        StringBuilder description = new StringBuilder();
        description.append(this.getIndexDisplayText(association)).append("\n\n").append(Messages.QualifierAndIndexParser_descriptionIndex).append("\n\n").append(multiLanguageSupport.getLocalizedDescription(association));
        return description.toString();
    }

    String getQualifierDescription(IAssociation association) {
        IMultiLanguageSupport multiLanguageSupport = this.getParsingContext().getMultiLanguageSupport();
        StringBuilder description = new StringBuilder();
        description.append(this.getQualifierDisplayText(association)).append("\n\n").append(Messages.QualifierAndIndexParser_descriptionQualifierUndefined).append("\n\n").append(multiLanguageSupport.getLocalizedDescription(association));
        return description.toString();
    }
}

