/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.builder.flidentifier;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.IMultiLanguageSupport;
import org.faktorips.devtools.model.fl.IdentifierFilter;
import org.faktorips.devtools.model.fl.IdentifierKind;
import org.faktorips.devtools.model.internal.builder.flidentifier.IdentifierProposal;
import org.faktorips.devtools.model.internal.builder.flidentifier.IdentifierProposalCollector;
import org.faktorips.devtools.model.internal.builder.flidentifier.Messages;
import org.faktorips.devtools.model.internal.builder.flidentifier.ParsingContext;
import org.faktorips.devtools.model.internal.builder.flidentifier.TypeBasedIdentifierParser;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.IdentifierNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.IdentifierNodeType;
import org.faktorips.devtools.model.pctype.IPolicyCmptType;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAttribute;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.devtools.model.type.IAttribute;
import org.faktorips.devtools.model.type.IType;
import org.faktorips.runtime.Message;

public class AttributeParser
extends TypeBasedIdentifierParser {
    public static final char VALUE_SUFFIX_SEPARATOR_CHAR = '@';
    public static final String DEFAULT_VALUE_SUFFIX = "@default";
    private final IdentifierFilter identifierFilter;

    public AttributeParser(ParsingContext parsingContext, IdentifierFilter identifierFilter) {
        super(parsingContext);
        this.identifierFilter = identifierFilter;
    }

    @Override
    public IdentifierNode parseInternal() {
        try {
            return this.parseToNode();
        }
        catch (IpsException e) {
            IpsLog.log(e);
            return this.nodeFactory().createInvalidIdentifier(Message.newInfo((String)"FLC-UndefinedIdentifier", (String)Messages.AbstractParameterIdentifierResolver_msgErrorRetrievingAttribute));
        }
    }

    private IdentifierNode parseToNode() {
        boolean defaultValueAccess = this.isDefaultValueAccess(this.getIdentifierPart());
        String attributeName = this.getAttributeName(this.getIdentifierPart(), defaultValueAccess);
        List<IAttribute> attributes = this.findAttributes();
        return this.createNode(defaultValueAccess, attributeName, attributes);
    }

    private boolean isDefaultValueAccess(String attributeName) {
        return this.getContextType() instanceof IPolicyCmptType && attributeName.endsWith(DEFAULT_VALUE_SUFFIX);
    }

    private String getAttributeName(String identifier, boolean defaultValueAccess) {
        if (defaultValueAccess) {
            return identifier.substring(0, identifier.lastIndexOf(64));
        }
        return identifier;
    }

    private IdentifierNode createNode(boolean defaultValueAccess, String attributeName, List<IAttribute> attributes) {
        for (IAttribute anAttribute : attributes) {
            if (!attributeName.equals(anAttribute.getName())) continue;
            if (this.isAllowd(anAttribute, defaultValueAccess)) {
                return this.nodeFactory().createAttributeNode(anAttribute, defaultValueAccess, this.isListOfTypeContext());
            }
            return this.createInvalidIdentifierNode();
        }
        return null;
    }

    protected List<IAttribute> findAttributes() {
        if (this.isContextTypeFormulaType()) {
            return this.getExpression().findMatchingProductCmptTypeAttributes();
        }
        if (this.isAllowedType()) {
            return this.getPolicyAndProductAttributesFromIType();
        }
        return Collections.emptyList();
    }

    @Override
    public List<IdentifierProposal> getProposals(String prefix) {
        IdentifierProposalCollector collector = new IdentifierProposalCollector();
        List<IAttribute> attributes = this.findAttributes();
        for (IAttribute attribute : attributes) {
            this.addProposal(attribute, false, prefix, collector);
            this.addProposal(attribute, true, prefix, collector);
        }
        return collector.getProposals();
    }

    private void addProposal(IAttribute attribute, boolean defaultAccess, String prefix, IdentifierProposalCollector collector) {
        if (this.isProposalAllowed(attribute, defaultAccess)) {
            collector.addMatchingNode(this.getText(attribute, defaultAccess), this.getDescription(attribute, defaultAccess), prefix, IdentifierNodeType.ATTRIBUTE);
        }
    }

    private boolean isProposalAllowed(IAttribute attribute, boolean defaultAccess) {
        return (attribute instanceof IPolicyCmptTypeAttribute || !defaultAccess) && this.isAllowd(attribute, defaultAccess);
    }

    private List<IAttribute> getPolicyAndProductAttributesFromIType() {
        ArrayList<IAttribute> attributes = new ArrayList<IAttribute>();
        IType contextType = this.getContextType();
        attributes.addAll(this.findAllAttributesFor(contextType));
        attributes.addAll(this.findProductAttributesIfAvailable(contextType));
        return attributes;
    }

    private List<IAttribute> findAllAttributesFor(IType contextType) {
        return contextType.findAllAttributes(this.getIpsProject());
    }

    private List<IAttribute> findProductAttributesIfAvailable(IType contextType) {
        IProductCmptType productCmptType;
        if (contextType instanceof IPolicyCmptType && (productCmptType = this.findProductCmptType((IPolicyCmptType)contextType)) != null) {
            return this.findAllAttributesFor(productCmptType);
        }
        return Collections.emptyList();
    }

    private IProductCmptType findProductCmptType(IPolicyCmptType policyCmptType) {
        return policyCmptType.findProductCmptType(this.getIpsProject());
    }

    private boolean isAllowd(IAttribute anAttribute, boolean isDefaultIdentifier) {
        return this.identifierFilter.isIdentifierAllowed(anAttribute, IdentifierKind.getDefaultIdentifierOrAttribute(isDefaultIdentifier));
    }

    private IdentifierNode createInvalidIdentifierNode() {
        return this.nodeFactory().createInvalidIdentifier(Message.newError((String)"FLC-UndefinedIdentifier", (String)MessageFormat.format(Messages.AbstractParameterIdentifierResolver_msgIdentifierNotAllowed, this.getIdentifierPart())));
    }

    public String getText(IAttribute attribute, boolean defaultValueAccess) {
        if (defaultValueAccess) {
            return String.valueOf(attribute.getName()) + DEFAULT_VALUE_SUFFIX;
        }
        return attribute.getName();
    }

    public String getDescription(IAttribute attribute, boolean defaultValueAccess) {
        IMultiLanguageSupport multiLanguageSupport = this.getParsingContext().getMultiLanguageSupport();
        String name = this.getName(attribute, multiLanguageSupport);
        if (defaultValueAccess) {
            name = MessageFormat.format(Messages.AttributeParser_defaultOfName, name);
        }
        return this.getNameAndDescription(name, this.getDescription((IIpsElement)attribute, multiLanguageSupport));
    }
}

