/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.builder.flidentifier;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.faktorips.datatype.EnumDatatype;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.IMultiLanguageSupport;
import org.faktorips.devtools.model.enums.EnumTypeDatatypeAdapter;
import org.faktorips.devtools.model.internal.builder.flidentifier.AbstractIdentifierNodeParser;
import org.faktorips.devtools.model.internal.builder.flidentifier.IdentifierProposal;
import org.faktorips.devtools.model.internal.builder.flidentifier.IdentifierProposalCollector;
import org.faktorips.devtools.model.internal.builder.flidentifier.Messages;
import org.faktorips.devtools.model.internal.builder.flidentifier.ParsingContext;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.EnumClassNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.IdentifierNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.IdentifierNodeType;
import org.faktorips.runtime.Message;

public class EnumParser
extends AbstractIdentifierNodeParser {
    private final Map<String, EnumDatatype> enumDatatypes = this.createEnumMap();

    public EnumParser(ParsingContext parsingContext) {
        super(parsingContext);
    }

    private Map<String, EnumDatatype> createEnumMap() {
        EnumDatatype[] enumtypes = this.getExpression().getEnumDatatypesAllowedInFormula();
        HashMap<String, EnumDatatype> newEnumDatatypes = new HashMap<String, EnumDatatype>(enumtypes.length);
        EnumDatatype[] enumDatatypeArray = enumtypes;
        int n = enumtypes.length;
        int n2 = 0;
        while (n2 < n) {
            EnumDatatype enumtype = enumDatatypeArray[n2];
            newEnumDatatypes.put(enumtype.getName(), enumtype);
            ++n2;
        }
        return newEnumDatatypes;
    }

    @Override
    protected IdentifierNode parse() {
        if (this.isContextTypeFormulaType()) {
            return this.parseEnumClass();
        }
        if (this.isAllowedType() && this.getContextType() instanceof EnumClassNode.EnumClass) {
            return this.parseEnumDatatype();
        }
        return null;
    }

    private IdentifierNode parseEnumClass() {
        EnumDatatype enumType = this.enumDatatypes.get(this.getIdentifierPart());
        if (enumType != null) {
            return this.nodeFactory().createEnumClassNode(new EnumClassNode.EnumClass(enumType));
        }
        return null;
    }

    private IdentifierNode parseEnumDatatype() {
        String[] valueIds;
        EnumDatatype enumType = ((EnumClassNode.EnumClass)this.getContextType()).getEnumDatatype();
        String[] stringArray = valueIds = enumType.getAllValueIds(true);
        int n = valueIds.length;
        int n2 = 0;
        while (n2 < n) {
            String enumValueId = stringArray[n2];
            if (Objects.equals(enumValueId, this.getIdentifierPart())) {
                return this.nodeFactory().createEnumValueNode(enumValueId, enumType);
            }
            ++n2;
        }
        return this.nodeFactory().createInvalidIdentifier(Message.newError((String)"FLC-UndefinedIdentifier", (String)MessageFormat.format(Messages.EnumParser_msgErrorInvalidEnumValue, this.getIdentifierPart(), enumType.getName())));
    }

    @Override
    public List<IdentifierProposal> getProposals(String prefix) {
        IdentifierProposalCollector collector = new IdentifierProposalCollector();
        if (this.isContextTypeFormulaType()) {
            this.addEnumClassProposals(prefix, collector);
        } else if (this.getContextType() instanceof EnumClassNode.EnumClass) {
            this.addEnumValueProposals(prefix, collector);
        }
        return collector.getProposals();
    }

    private void addEnumClassProposals(String prefix, IdentifierProposalCollector collector) {
        EnumDatatype[] enumDatatypesAllowedInFormula;
        EnumDatatype[] enumDatatypeArray = enumDatatypesAllowedInFormula = this.getExpression().getEnumDatatypesAllowedInFormula();
        int n = enumDatatypesAllowedInFormula.length;
        int n2 = 0;
        while (n2 < n) {
            EnumDatatype enumDatatype = enumDatatypeArray[n2];
            collector.addMatchingNode(this.getText(enumDatatype), this.getDescription(enumDatatype), prefix, IdentifierNodeType.ENUM_CLASS);
            ++n2;
        }
    }

    private String getText(EnumDatatype enumDatatype) {
        return enumDatatype.getName();
    }

    /*
     * WARNING - void declaration
     */
    protected String getDescription(EnumDatatype enumDatatype) {
        EnumDatatype enumDatatype2 = enumDatatype;
        if (enumDatatype2 instanceof EnumTypeDatatypeAdapter) {
            void enumTypeDatatypeAdapter;
            EnumTypeDatatypeAdapter enumTypeDatatypeAdapter2 = (EnumTypeDatatypeAdapter)enumDatatype2;
            EnumTypeDatatypeAdapter cfr_ignored_0 = (EnumTypeDatatypeAdapter)enumDatatype2;
            IMultiLanguageSupport multiLanguageSupport = this.getParsingContext().getMultiLanguageSupport();
            return this.getNameAndDescription(enumTypeDatatypeAdapter.getEnumType(), multiLanguageSupport);
        }
        return MessageFormat.format(Messages.EnumParser_description, this.getText(enumDatatype));
    }

    private void addEnumValueProposals(String prefix, IdentifierProposalCollector collector) {
        String[] valueIds;
        EnumDatatype enumDatatype = ((EnumClassNode.EnumClass)this.getContextType()).getEnumDatatype();
        String[] stringArray = valueIds = enumDatatype.getAllValueIds(false);
        int n = valueIds.length;
        int n2 = 0;
        while (n2 < n) {
            String enumValueId = stringArray[n2];
            collector.addMatchingNode(enumValueId, this.getLabel(enumValueId, enumDatatype), "", prefix, IdentifierNodeType.ENUM_VALUE);
            ++n2;
        }
    }

    private String getLabel(String enumValueId, EnumDatatype enumDatatype) {
        return String.valueOf(enumValueId) + "(" + enumDatatype.getValueName(enumValueId, IIpsModelExtensions.get().getModelPreferences().getDatatypeFormattingLocale()) + ")";
    }
}

