/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.builder.flidentifier;

import org.faktorips.codegen.CodeFragment;
import org.faktorips.devtools.model.internal.builder.flidentifier.IdentifierNodeGeneratorFactory;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.IdentifierNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.IdentifierNodeType;
import org.faktorips.fl.CompilationResult;

public abstract class IdentifierNodeGenerator<T extends CodeFragment> {
    public static final String DEFAULT_VALUE_SUFFIX = "@default";
    private final IdentifierNodeGeneratorFactory<T> nodeBuilderFactory;

    public IdentifierNodeGenerator(IdentifierNodeGeneratorFactory<T> factory) {
        this.nodeBuilderFactory = factory;
    }

    public CompilationResult<T> generateNode(IdentifierNode identifierNode, CompilationResult<T> contextCompilationResult) {
        return this.generateNodeAndSuccessors(identifierNode, contextCompilationResult);
    }

    private CompilationResult<T> generateNodeAndSuccessors(IdentifierNode identifierNode, CompilationResult<T> predecessorCompilationResult) {
        CompilationResult<T> compilationResult = this.getCompilationResultForCurrentNode(identifierNode, predecessorCompilationResult);
        return this.getSuccessorCompilationResultIfApplicable(identifierNode, compilationResult);
    }

    private CompilationResult<T> getSuccessorCompilationResultIfApplicable(IdentifierNode identifierNode, CompilationResult<T> compilationResult) {
        if (compilationResult != null && !compilationResult.failed() && identifierNode.hasSuccessor()) {
            return this.getSuccessorCompilationResult(identifierNode, compilationResult);
        }
        return compilationResult;
    }

    private CompilationResult<T> getSuccessorCompilationResult(IdentifierNode identifierNode, CompilationResult<T> compilationResult) {
        IdentifierNode successorNode = identifierNode.getSuccessor();
        IdentifierNodeGenerator<T> successorBuilder = this.getGeneratorFor(successorNode);
        return successorBuilder.generateNode(successorNode, compilationResult);
    }

    protected IdentifierNodeGenerator<T> getGeneratorFor(IdentifierNode node) {
        IdentifierNodeType nodeType = IdentifierNodeType.getNodeType(node.getClass());
        return nodeType.getGenerator(this.getNodeGeneratorFactory());
    }

    protected abstract CompilationResult<T> getCompilationResultForCurrentNode(IdentifierNode var1, CompilationResult<T> var2);

    protected IdentifierNodeGeneratorFactory<T> getNodeGeneratorFactory() {
        return this.nodeBuilderFactory;
    }
}

