/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.builder.flidentifier;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.fl.IdentifierFilter;
import org.faktorips.devtools.model.internal.builder.flidentifier.AbstractIdentifierNodeParser;
import org.faktorips.devtools.model.internal.builder.flidentifier.AssociationParser;
import org.faktorips.devtools.model.internal.builder.flidentifier.AttributeParser;
import org.faktorips.devtools.model.internal.builder.flidentifier.EnumParser;
import org.faktorips.devtools.model.internal.builder.flidentifier.IdentifierProposal;
import org.faktorips.devtools.model.internal.builder.flidentifier.Messages;
import org.faktorips.devtools.model.internal.builder.flidentifier.ParameterParser;
import org.faktorips.devtools.model.internal.builder.flidentifier.ParsingContext;
import org.faktorips.devtools.model.internal.builder.flidentifier.QualifierAndIndexParser;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.IdentifierNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.IdentifierNodeFactory;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.IExpression;
import org.faktorips.devtools.model.util.TextRegion;
import org.faktorips.runtime.Message;

public class IdentifierParser {
    private static final char DEFAULT_SEPERATOR = '.';
    private static final char QUALIFIER_SEPERATOR = '[';
    private final IdentifierFilter identifierFilter;
    private final ParsingContext parsingContext;
    private final Map<AbstractIdentifierNodeParser, Character> parsers = new LinkedHashMap<AbstractIdentifierNodeParser, Character>();
    private IdentifierMatcher matcher;

    public IdentifierParser(IExpression expression, IIpsProject ipsProject) {
        this(expression, ipsProject, IIpsModelExtensions.get().getIdentifierFilter());
    }

    public IdentifierParser(IExpression expression, IIpsProject ipsProject, IdentifierFilter identifierFilter) {
        this.parsingContext = new ParsingContext(expression, ipsProject);
        this.identifierFilter = identifierFilter;
        this.initParsers();
    }

    private void initParsers() {
        this.parsers.put(new ParameterParser(this.parsingContext), Character.valueOf('.'));
        this.parsers.put(new AttributeParser(this.parsingContext, this.identifierFilter), Character.valueOf('.'));
        this.parsers.put(new AssociationParser(this.parsingContext), Character.valueOf('.'));
        this.parsers.put(new QualifierAndIndexParser(this.parsingContext), Character.valueOf('['));
        this.parsers.put(new EnumParser(this.parsingContext), Character.valueOf('.'));
    }

    public IdentifierNode parse(String identifier) {
        this.initNewParse(identifier);
        return this.parseNextPart();
    }

    private IdentifierNode parseNextPart() {
        for (Map.Entry<AbstractIdentifierNodeParser, Character> parserEntry : this.parsers.entrySet()) {
            IdentifierNode node;
            if (!this.isResponsibleForCurrentTextRegion(parserEntry) || (node = parserEntry.getKey().parse(this.matcher.getTextRegion())) == null) continue;
            if (this.matcher.hasNextIdentifierPart()) {
                this.parsingContext.pushNode(node);
                this.matcher.nextIdentifierPart();
                node.setSuccessor(this.parseNextPart());
            }
            return node;
        }
        return new IdentifierNodeFactory(this.matcher.getTextRegion(), this.parsingContext.getIpsProject()).createInvalidIdentifier(Message.newError((String)"FLC-UndefinedIdentifier", (String)MessageFormat.format(Messages.IdentifierParser_msgErrorInvalidIdentifier, this.matcher.getIdentifierPart())));
    }

    private boolean isResponsibleForCurrentTextRegion(Map.Entry<AbstractIdentifierNodeParser, Character> parserEntry) {
        return this.isParserSpecificSeparator(parserEntry.getValue().charValue());
    }

    private boolean isParserSpecificSeparator(char separator) {
        TextRegion textRegion = this.matcher.getTextRegion();
        return textRegion.getStart() == 0 || textRegion.isRelativeChar(-1, separator);
    }

    public List<IdentifierProposal> getProposals(String existingContent) {
        this.parse(existingContent);
        ArrayList<IdentifierProposal> result = new ArrayList<IdentifierProposal>();
        if (this.isLegalSyntaxUpToNow()) {
            for (Map.Entry<AbstractIdentifierNodeParser, Character> parserEntry : this.parsers.entrySet()) {
                if (!this.isResponsibleForCurrentTextRegion(parserEntry)) continue;
                result.addAll(this.getProposalsFrom(parserEntry));
            }
        }
        return result;
    }

    private boolean isLegalSyntaxUpToNow() {
        return this.matcher.hitEnd();
    }

    private List<IdentifierProposal> getProposalsFrom(Map.Entry<AbstractIdentifierNodeParser, Character> parserEntry) {
        return parserEntry.getKey().getProposals(this.matcher.getIdentifierPart());
    }

    private void initNewParse(String identifier) {
        this.parsingContext.init();
        this.matcher = new IdentifierMatcher(identifier);
    }

    protected static class IdentifierMatcher {
        private static final String IDENTIFIER_SEPERATOR_REGEX = "[\\.\\[]";
        private static final Pattern IDENTIFIER_SEPERATOR_PATTERN = Pattern.compile("[\\.\\[]");
        private final String identifier;
        private final Matcher matcher;
        private TextRegion textRegion;

        public IdentifierMatcher(String identifier) {
            this.identifier = identifier;
            this.matcher = IDENTIFIER_SEPERATOR_PATTERN.matcher(identifier);
            this.find(0);
        }

        public void nextIdentifierPart() {
            int sequenceStart = this.matcher.end();
            this.find(sequenceStart);
        }

        private void find(int sequenceStart) {
            this.textRegion = this.matcher.find() ? new TextRegion(this.identifier, sequenceStart, this.matcher.start()) : new TextRegion(this.identifier, sequenceStart, this.identifier.length());
        }

        public boolean hasNextIdentifierPart() {
            return !this.matcher.hitEnd();
        }

        public boolean hitEnd() {
            return this.matcher.hitEnd();
        }

        public String getIdentifierPart() {
            return this.textRegion.getTextRegionString();
        }

        public TextRegion getTextRegion() {
            return this.textRegion;
        }
    }
}

