/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.builder.flidentifier;

import java.util.Objects;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.IdentifierNodeType;
import org.faktorips.util.ArgumentCheck;

public class IdentifierProposal
implements Comparable<IdentifierProposal> {
    private final String text;
    private final String label;
    private final String description;
    private final String prefix;
    private final IdentifierNodeType nodeType;

    public IdentifierProposal(String text, String label, String description, String prefix, IdentifierNodeType nodeType) {
        ArgumentCheck.notNull((Object[])new Object[]{text, label, description, prefix, nodeType});
        this.text = text;
        this.label = label;
        this.description = description;
        this.prefix = prefix;
        this.nodeType = nodeType;
    }

    public String getText() {
        return this.text;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public IdentifierNodeType getNodeType() {
        return this.nodeType;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public int compareTo(IdentifierProposal o) {
        if (this.getNodeType().equals((Object)o.getNodeType())) {
            return this.getText().compareTo(o.getText());
        }
        return this.getNodeType().getProposalSortOrder() - o.getNodeType().getProposalSortOrder();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.label, this.nodeType, this.prefix, this.text});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IdentifierProposal other = (IdentifierProposal)obj;
        return this.text.equals(other.text) && this.label.equals(other.label) && this.description.equals(other.description) && this.prefix.equals(other.prefix) && this.nodeType == other.nodeType;
    }
}

