/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.builder.flidentifier;

import java.text.MessageFormat;
import java.util.List;
import org.faktorips.datatype.Datatype;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.IMultiLanguageSupport;
import org.faktorips.devtools.model.internal.builder.flidentifier.AbstractIdentifierNodeParser;
import org.faktorips.devtools.model.internal.builder.flidentifier.IdentifierProposal;
import org.faktorips.devtools.model.internal.builder.flidentifier.IdentifierProposalCollector;
import org.faktorips.devtools.model.internal.builder.flidentifier.Messages;
import org.faktorips.devtools.model.internal.builder.flidentifier.ParsingContext;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.IdentifierNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.IdentifierNodeType;
import org.faktorips.devtools.model.method.IFormulaMethod;
import org.faktorips.devtools.model.method.IParameter;

public class ParameterParser
extends AbstractIdentifierNodeParser {
    public ParameterParser(ParsingContext parsingContext) {
        super(parsingContext);
    }

    @Override
    protected IdentifierNode parse() {
        if (this.isContextTypeFormulaType()) {
            IParameter[] params;
            IParameter[] iParameterArray = params = this.getParameters();
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                IParameter param = iParameterArray[n2];
                if (param.getName().equals(this.getIdentifierPart())) {
                    return this.nodeFactory().createParameterNode(param);
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public List<IdentifierProposal> getProposals(String prefix) {
        IdentifierProposalCollector collector = new IdentifierProposalCollector();
        if (this.isContextTypeFormulaType()) {
            IParameter[] parameters;
            IParameter[] iParameterArray = parameters = this.getParameters();
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                IParameter parameter = iParameterArray[n2];
                collector.addMatchingNode(parameter.getName(), this.getDescription(parameter), prefix, IdentifierNodeType.PARAMETER);
                ++n2;
            }
        }
        return collector.getProposals();
    }

    String getDescription(IParameter parameter) {
        Datatype datatype = parameter.findDatatype(this.getIpsProject());
        if (datatype instanceof IIpsElement) {
            IMultiLanguageSupport multiLanguageSupport = this.getParsingContext().getMultiLanguageSupport();
            return this.getNameAndDescription((IIpsElement)datatype, multiLanguageSupport);
        }
        return MessageFormat.format(Messages.ParameterParser_description, parameter.getName(), parameter.getDatatype());
    }

    protected IParameter[] getParameters() {
        IFormulaMethod formulaSignature = this.getExpression().findFormulaSignature(this.getIpsProject());
        if (formulaSignature != null) {
            return formulaSignature.getParameters();
        }
        return new IParameter[0];
    }
}

