/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.builder.flidentifier;

import java.util.LinkedList;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.IMultiLanguageSupport;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.IdentifierNode;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.IExpression;

public class ParsingContext {
    private final IExpression expression;
    private final LinkedList<IdentifierNode> nodes = new LinkedList();
    private final IIpsProject ipsProject;
    private final IMultiLanguageSupport multiLanguageSupport;

    public ParsingContext(IExpression expression, IIpsProject ipsProject) {
        this(expression, ipsProject, IIpsModel.get().getMultiLanguageSupport());
    }

    public ParsingContext(IExpression expression, IIpsProject ipsProject, IMultiLanguageSupport multiLanguageSupport) {
        this.expression = expression;
        this.ipsProject = ipsProject;
        this.multiLanguageSupport = multiLanguageSupport;
    }

    public void init() {
        this.nodes.clear();
    }

    public void pushNode(IdentifierNode node) {
        this.nodes.push(node);
    }

    public LinkedList<IdentifierNode> getNodes() {
        return new LinkedList<IdentifierNode>(this.nodes);
    }

    public IdentifierNode getPreviousNode() {
        return this.nodes.peek();
    }

    public IExpression getExpression() {
        return this.expression;
    }

    public IIpsProject getIpsProject() {
        return this.ipsProject;
    }

    public IMultiLanguageSupport getMultiLanguageSupport() {
        return this.multiLanguageSupport;
    }
}

