/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.builder.flidentifier;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.internal.builder.flidentifier.IdentifierProposal;
import org.faktorips.devtools.model.internal.builder.flidentifier.IdentifierProposalCollector;
import org.faktorips.devtools.model.internal.builder.flidentifier.Messages;
import org.faktorips.devtools.model.internal.builder.flidentifier.ParsingContext;
import org.faktorips.devtools.model.internal.builder.flidentifier.TypeBasedIdentifierParser;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.AssociationNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.IdentifierNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.IdentifierNodeType;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.QualifierNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.contextcollector.ContextProductCmptFinder;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.pctype.IPolicyCmptType;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.runtime.Message;

public class QualifierAndIndexParser
extends TypeBasedIdentifierParser {
    public static final String QUALIFIER_START = "[";
    public static final String QUALIFIER_END = "]";
    private static final String QUALIFIER_QUOTATION = "\"";

    public QualifierAndIndexParser(ParsingContext parsingContext) {
        super(parsingContext);
    }

    @Override
    public boolean isAllowedType() {
        return super.isAllowedType() && super.getContextType() instanceof IPolicyCmptType;
    }

    @Override
    protected IdentifierNode parseInternal() {
        if (!this.isValidPreviousNode()) {
            return null;
        }
        if (this.isIndex() && !this.isListOfTypeContext()) {
            return this.invalidIndexNode();
        }
        if (this.isQualifier()) {
            return this.createQualifierNode();
        }
        if (this.isIndex()) {
            return this.createIndexNode();
        }
        return null;
    }

    private boolean isValidPreviousNode() {
        return this.getPreviousNode() instanceof AssociationNode || this.getPreviousNode() instanceof QualifierNode && this.isIndex();
    }

    private IdentifierNode invalidIndexNode() {
        return this.nodeFactory().createInvalidIdentifier(Message.newError((String)"FLC-NoIndexFor1to1Association", (String)MessageFormat.format(Messages.AbstractParameterIdentifierResolver_noIndexFor1to1Association0, this.getIdentifierPart())));
    }

    private IdentifierNode createQualifierNode() {
        try {
            IProductCmpt productCmpt = this.findProductCmpt();
            return this.nodeFactory().createQualifierNode(productCmpt, this.getQualifier(), this.isListOfType());
        }
        catch (IpsException e) {
            IpsLog.log(e);
            return this.nodeFactory().createInvalidIdentifier(Message.newError((String)"FLC-UnknownQualifier", (String)MessageFormat.format(Messages.QualifierAndIndexParser_errorMsg_errorWhileSearchingProductCmpt, this.getQualifier())));
        }
    }

    private boolean isListOfType() {
        AssociationNode associationNode = (AssociationNode)this.getPreviousNode();
        return associationNode.isListContext() || associationNode.getAssociation().is1ToManyIgnoringQualifier();
    }

    private IProductCmpt findProductCmpt() {
        Collection<IIpsSrcFile> foundProductCmpts = this.findProductCmptByName();
        if (foundProductCmpts != null) {
            for (IIpsSrcFile ipsSrcFile : foundProductCmpts) {
                IProductCmpt foundProductCmpt = (IProductCmpt)ipsSrcFile.getIpsObject();
                if (!this.isMatchingProductCmptType(foundProductCmpt)) continue;
                return foundProductCmpt;
            }
        }
        return null;
    }

    private Collection<IIpsSrcFile> findProductCmptByName() {
        Collection<IIpsSrcFile> foundProductCmpt = this.getIpsProject().findProductCmptByUnqualifiedName(this.getQualifier());
        if (foundProductCmpt.isEmpty()) {
            IProductCmpt foundProductCmptByQName = this.getIpsProject().findProductCmpt(this.getQualifier());
            if (foundProductCmptByQName != null) {
                return Arrays.asList(foundProductCmptByQName.getIpsSrcFile());
            }
            return Collections.emptyList();
        }
        return foundProductCmpt;
    }

    private boolean isMatchingProductCmptType(IProductCmpt productCmpt) {
        IProductCmptType foundProductCmptType = productCmpt.findProductCmptType(this.getIpsProject());
        return foundProductCmptType.isSubtypeOrSameType(this.findProductCmptType(), this.getIpsProject());
    }

    private IProductCmptType findProductCmptType() {
        return ((IPolicyCmptType)this.getContextType()).findProductCmptType(this.getIpsProject());
    }

    private IdentifierNode createIndexNode() {
        try {
            return this.nodeFactory().createIndexBasedAssociationNode(this.getIndex(), this.getContextType());
        }
        catch (NumberFormatException e) {
            return this.handleInvalidIndex(e);
        }
    }

    private IdentifierNode handleInvalidIndex(NumberFormatException e) {
        IpsLog.log(e);
        return this.nodeFactory().createInvalidIdentifier(Message.newError((String)"FLC-UnknownQualifier", (String)MessageFormat.format(Messages.AssociationParser_msgErrorAssociationQualifierOrIndex, this.getQualifierOrIndex(), this.getIdentifierPart())));
    }

    private boolean isQualifier() {
        return this.getIdentifierPart().startsWith(QUALIFIER_QUOTATION) && this.getIdentifierPart().endsWith("\"]");
    }

    private boolean isIndex() {
        return this.getIdentifierPart().endsWith(QUALIFIER_END) && !this.isQualifier();
    }

    private int getIndexOrQualifierEnd() {
        return this.getIdentifierPart().indexOf(QUALIFIER_END);
    }

    private String getQualifier() {
        return this.getQualifierOrIndex().substring(1, this.getQualifierOrIndex().length() - 1);
    }

    private int getIndex() {
        return Integer.parseInt(this.getQualifierOrIndex());
    }

    private String getQualifierOrIndex() {
        return this.getIdentifierPart().substring(0, this.getIndexOrQualifierEnd());
    }

    @Override
    public List<IdentifierProposal> getProposals(String prefix) {
        IdentifierProposalCollector collector = new IdentifierProposalCollector();
        if (this.getPreviousNode() instanceof AssociationNode || this.getPreviousNode() instanceof QualifierNode) {
            this.addIndexProposal(prefix, collector);
        }
        if (this.getPreviousNode() instanceof AssociationNode) {
            this.addQualifierProposal(prefix, collector);
        }
        return collector.getProposals();
    }

    private void addIndexProposal(String prefix, IdentifierProposalCollector collector) {
        String text = this.getIndexText(0);
        collector.addMatchingNode(text, QUALIFIER_START + text, this.getIndexDescription(), prefix, IdentifierNodeType.INDEX);
    }

    private void addQualifierProposal(String prefix, IdentifierProposalCollector collector) {
        List<IProductCmpt> contextProductCmpts = new ContextProductCmptFinder(this.getParsingContext().getNodes(), this.getExpression(), this.getIpsProject()).getContextProductCmpts();
        for (IProductCmpt productCmpt : contextProductCmpts) {
            this.addQualifierProposal(productCmpt, prefix, collector);
        }
    }

    public String getIndexText(int index) {
        return String.valueOf(index) + QUALIFIER_END;
    }

    public String getIndexDescription() {
        return Messages.QualifierAndIndexParser_descriptionIndex;
    }

    private void addQualifierProposal(IProductCmpt productCmpt, String prefix, IdentifierProposalCollector collector) {
        String text = this.getQualifierText(productCmpt);
        collector.addMatchingNode(text, QUALIFIER_START + text, this.getQualifierDescription(productCmpt), prefix, IdentifierNodeType.QUALIFIER);
    }

    public String getQualifierText(IProductCmpt productCmpt) {
        return String.valueOf('\"') + productCmpt.getName() + '\"' + QUALIFIER_END;
    }

    public String getQualifierDescription(IProductCmpt productCmpt) {
        return MessageFormat.format(Messages.QualifierAndIndexParser_descriptionQualifier, productCmpt.getName());
    }
}

