/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.builder.flidentifier.ast;

import org.faktorips.datatype.AbstractDatatype;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.EnumDatatype;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.IdentifierNode;
import org.faktorips.devtools.model.util.TextRegion;

public class EnumClassNode
extends IdentifierNode {
    EnumClassNode(EnumClass datatype, TextRegion textRegion) {
        super((Datatype)datatype, textRegion);
    }

    public EnumClass getDatatype() {
        return (EnumClass)super.getDatatype();
    }

    public static class EnumClass
    extends AbstractDatatype {
        private static final String CLASS_NAME = Class.class.getSimpleName();
        private final EnumDatatype enumDatatype;

        public EnumClass(EnumDatatype enumDatatype) {
            this.enumDatatype = enumDatatype;
        }

        public String getName() {
            return String.valueOf(CLASS_NAME) + "<" + this.getEnumDatatype().getName() + ">";
        }

        public String getQualifiedName() {
            return this.getName();
        }

        public boolean isPrimitive() {
            return false;
        }

        public boolean isAbstract() {
            return false;
        }

        public boolean isValueDatatype() {
            return false;
        }

        public EnumDatatype getEnumDatatype() {
            return this.enumDatatype;
        }
    }
}

