/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.builder.flidentifier.ast;

import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.ListOfTypeDatatype;
import org.faktorips.devtools.model.util.TextRegion;

public abstract class IdentifierNode {
    private final Datatype datatype;
    private IdentifierNode successor;
    private final TextRegion textRegion;

    protected IdentifierNode(Datatype datatype, TextRegion textRegion) {
        this(datatype, false, textRegion);
    }

    protected IdentifierNode(Datatype datatype, boolean listOfTypes, TextRegion textRegion) {
        this.textRegion = textRegion;
        this.datatype = listOfTypes && datatype != null ? new ListOfTypeDatatype(datatype) : datatype;
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public IdentifierNode getSuccessor() {
        return this.successor;
    }

    public void setSuccessor(IdentifierNode successor) {
        this.successor = successor;
    }

    public boolean hasSuccessor() {
        return this.getSuccessor() != null;
    }

    public boolean isListOfTypeDatatype() {
        return this.datatype instanceof ListOfTypeDatatype;
    }

    public TextRegion getTextRegion() {
        return this.textRegion;
    }
}

