/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.builder.flidentifier.ast;

import java.text.MessageFormat;
import org.faktorips.datatype.EnumDatatype;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.internal.builder.flidentifier.Messages;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.AssociationNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.AttributeNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.EnumClassNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.EnumValueNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.IdentifierNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.IndexNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.InvalidIdentifierNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.ParameterNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.QualifierNode;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.method.IParameter;
import org.faktorips.devtools.model.pctype.IPolicyCmptType;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.type.IAssociation;
import org.faktorips.devtools.model.type.IAttribute;
import org.faktorips.devtools.model.type.IType;
import org.faktorips.devtools.model.util.TextRegion;
import org.faktorips.runtime.Message;

public class IdentifierNodeFactory {
    private final IIpsProject ipsProject;
    private final TextRegion textRegion;

    public IdentifierNodeFactory(TextRegion textRegion, IIpsProject ipsProject) {
        this.textRegion = textRegion;
        this.ipsProject = ipsProject;
    }

    public IdentifierNode createParameterNode(IParameter parameter) {
        try {
            ParameterNode parameterNode = new ParameterNode(parameter, this.textRegion, this.ipsProject);
            if (parameterNode.getDatatype() == null) {
                return this.createInvalidNoDatatype(parameter.getDatatype());
            }
            return parameterNode;
        }
        catch (IpsException e) {
            IpsLog.log(e);
            return this.createInvalidDatatypeError(parameter.getDatatype());
        }
    }

    public IdentifierNode createAttributeNode(IAttribute attribute, boolean defaultValueAccess, boolean listOfTypes) {
        AttributeNode attributeNode = new AttributeNode(attribute, defaultValueAccess, listOfTypes, this.ipsProject, this.textRegion);
        if (attributeNode.getDatatype() == null) {
            return this.createInvalidNoDatatype(attribute.getDatatype());
        }
        return attributeNode;
    }

    private IdentifierNode createInvalidNoDatatype(String datatypeName) {
        return this.createInvalidIdentifier(Message.newError((String)"FLC-UndefinedIdentifier", (String)MessageFormat.format(Messages.AbstractParameterIdentifierResolver_msgDatatypeCanNotBeResolved, datatypeName, this.textRegion.getTextRegionString())));
    }

    private IdentifierNode createInvalidDatatypeError(String datatypeName) {
        return this.createInvalidIdentifier(Message.newError((String)"FLC-UndefinedIdentifier", (String)MessageFormat.format(Messages.AbstractParameterIdentifierResolver_msgErrorDatatypeResolving, datatypeName, this.textRegion.getTextRegionString())));
    }

    public IdentifierNode createAssociationNode(IAssociation association, boolean listOfType) {
        try {
            return new AssociationNode(association, listOfType, this.textRegion, this.ipsProject);
        }
        catch (IpsException e) {
            IpsLog.log(e);
            return this.createInvalidAssociationTargetNode(association.getTarget());
        }
    }

    public IdentifierNode createQualifierNode(IProductCmpt productCmpt, String qualifier, boolean listOfTypes) {
        if (this.checkProductCmpt(productCmpt)) {
            return this.createInvalidQualifierMessage(qualifier);
        }
        IPolicyCmptType targetType = productCmpt.findPolicyCmptType(this.ipsProject);
        return new QualifierNode(productCmpt, targetType, listOfTypes, this.textRegion);
    }

    private InvalidIdentifierNode createInvalidQualifierMessage(String qualifier) {
        return this.createInvalidIdentifier(Message.newError((String)"FLC-UnknownQualifier", (String)MessageFormat.format(Messages.AssociationParser_msgErrorAssociationQualifier, qualifier)));
    }

    private boolean checkProductCmpt(IProductCmpt productCmpt) {
        return productCmpt == null || productCmpt.getRuntimeId() == null;
    }

    public IdentifierNode createIndexBasedAssociationNode(int index, IType targetType) {
        return new IndexNode(index, targetType, this.textRegion);
    }

    private IdentifierNode createInvalidAssociationTargetNode(String targetName) {
        return this.createInvalidIdentifier(Message.newError((String)"FLC-UndefinedIdentifier", (String)MessageFormat.format(Messages.AbstractParameterIdentifierResolver_noAssociationTarget, targetName, this.textRegion.getTextRegionString())));
    }

    public EnumClassNode createEnumClassNode(EnumClassNode.EnumClass datatype) {
        return new EnumClassNode(datatype, this.textRegion);
    }

    public EnumValueNode createEnumValueNode(String enumValue, EnumDatatype enumDatatype) {
        return new EnumValueNode(enumValue, enumDatatype, this.textRegion);
    }

    public InvalidIdentifierNode createInvalidIdentifier(Message message) {
        return new InvalidIdentifierNode(message, this.textRegion);
    }
}

