/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.builder.flidentifier.ast;

import org.faktorips.codegen.CodeFragment;
import org.faktorips.devtools.model.internal.builder.flidentifier.IdentifierNodeGenerator;
import org.faktorips.devtools.model.internal.builder.flidentifier.IdentifierNodeGeneratorFactory;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.AssociationNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.AttributeNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.EnumClassNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.EnumValueNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.IdentifierNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.IndexNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.InvalidIdentifierNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.ParameterNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.QualifierNode;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum IdentifierNodeType {
    PARAMETER(ParameterNode.class, -1){

        @Override
        public <T extends CodeFragment> IdentifierNodeGenerator<T> getGenerator(IdentifierNodeGeneratorFactory<T> factory) {
            return factory.getGeneratorForParameterNode();
        }
    }
    ,
    ATTRIBUTE(AttributeNode.class, 2){

        @Override
        public <T extends CodeFragment> IdentifierNodeGenerator<T> getGenerator(IdentifierNodeGeneratorFactory<T> factory) {
            return factory.getGeneratorForAttributeNode();
        }
    }
    ,
    ASSOCIATION(AssociationNode.class, 3){

        @Override
        public <T extends CodeFragment> IdentifierNodeGenerator<T> getGenerator(IdentifierNodeGeneratorFactory<T> factory) {
            return factory.getGeneratorForAssociationNode();
        }
    }
    ,
    INDEX(IndexNode.class, 4){

        @Override
        public <T extends CodeFragment> IdentifierNodeGenerator<T> getGenerator(IdentifierNodeGeneratorFactory<T> factory) {
            return factory.getGeneratorForIndexBasedAssociationNode();
        }
    }
    ,
    QUALIFIER(QualifierNode.class, 5){

        @Override
        public <T extends CodeFragment> IdentifierNodeGenerator<T> getGenerator(IdentifierNodeGeneratorFactory<T> factory) {
            return factory.getGeneratorForQualifiedAssociationNode();
        }
    }
    ,
    ENUM_CLASS(EnumClassNode.class, 6){

        @Override
        public <T extends CodeFragment> IdentifierNodeGenerator<T> getGenerator(IdentifierNodeGeneratorFactory<T> factory) {
            return factory.getGeneratorForEnumClassNode();
        }
    }
    ,
    ENUM_VALUE(EnumValueNode.class, 7){

        @Override
        public <T extends CodeFragment> IdentifierNodeGenerator<T> getGenerator(IdentifierNodeGeneratorFactory<T> factory) {
            return factory.getGeneratorForEnumValueNode();
        }
    }
    ,
    INVALID_IDENTIFIER(InvalidIdentifierNode.class, Integer.MAX_VALUE){

        @Override
        public <T extends CodeFragment> IdentifierNodeGenerator<T> getGenerator(IdentifierNodeGeneratorFactory<T> factory) {
            return factory.getGeneratorForInvalidNode();
        }
    };

    private final Class<? extends IdentifierNode> nodeClass;
    private final int proposalSortOrder;

    private IdentifierNodeType(Class<? extends IdentifierNode> nodeClass, int proposalSortOrder) {
        this.nodeClass = nodeClass;
        this.proposalSortOrder = proposalSortOrder;
    }

    public static IdentifierNodeType getNodeType(Class<? extends IdentifierNode> nodeClass) {
        IdentifierNodeType[] identifierNodeTypeArray = IdentifierNodeType.values();
        int n = identifierNodeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IdentifierNodeType value = identifierNodeTypeArray[n2];
            if (value.getNodeClass().equals(nodeClass)) {
                return value;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Illegal node class " + nodeClass);
    }

    public int getProposalSortOrder() {
        return this.proposalSortOrder;
    }

    public Class<? extends IdentifierNode> getNodeClass() {
        return this.nodeClass;
    }

    public abstract <T extends CodeFragment> IdentifierNodeGenerator<T> getGenerator(IdentifierNodeGeneratorFactory<T> var1);
}

