/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.builder.flidentifier.contextcollector;

import java.util.GregorianCalendar;
import java.util.Set;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.IdentifierNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.contextcollector.ContextProductCmptFinder;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.IExpression;
import org.faktorips.devtools.model.productcmpt.IFormula;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.productcmpt.IProductCmptGeneration;

public abstract class AbstractProductCmptCollector {
    private final ContextProductCmptFinder finder;
    private final IdentifierNode node;

    protected AbstractProductCmptCollector(IdentifierNode node, ContextProductCmptFinder finder) {
        this.node = node;
        this.finder = finder;
    }

    public IIpsProject getIpsProject() {
        return this.finder.getIpsProject();
    }

    public IdentifierNode getNode() {
        return this.node;
    }

    protected IProductCmptGeneration getOriginGeneration() {
        IFormula formula;
        if (this.getExpression() instanceof IFormula && (formula = (IFormula)this.getExpression()).getPropertyValueContainer() instanceof IProductCmptGeneration) {
            return (IProductCmptGeneration)formula.getPropertyValueContainer();
        }
        return null;
    }

    private IExpression getExpression() {
        return this.finder.getExpression();
    }

    protected GregorianCalendar getValidFrom() {
        IProductCmptGeneration originGeneration = this.getOriginGeneration();
        if (originGeneration != null) {
            return originGeneration.getValidFrom();
        }
        return null;
    }

    protected abstract Set<IProductCmpt> getContextProductCmpts();

    protected Set<IProductCmpt> getPreviousContextProductCmpts() {
        AbstractProductCmptCollector collector = this.finder.createCollector();
        return collector.getContextProductCmpts();
    }
}

