/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.builder.flidentifier.contextcollector;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.AssociationNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.contextcollector.AbstractProductCmptCollector;
import org.faktorips.devtools.model.internal.builder.flidentifier.contextcollector.ContextProductCmptFinder;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.pctype.IPolicyCmptType;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.productcmpt.IProductCmptGeneration;
import org.faktorips.devtools.model.productcmpt.IProductCmptLink;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.devtools.model.type.IAssociation;
import org.faktorips.devtools.model.type.IType;

public class AssociationCollector
extends AbstractProductCmptCollector {
    protected AssociationCollector(AssociationNode node, ContextProductCmptFinder finder) {
        super(node, finder);
    }

    @Override
    public AssociationNode getNode() {
        return (AssociationNode)super.getNode();
    }

    private IAssociation getAssociation() {
        return this.getNode().getAssociation();
    }

    @Override
    protected Set<IProductCmpt> getContextProductCmpts() {
        Set<IProductCmpt> contextProductCmpts = this.getPreviousContextProductCmpts();
        if (contextProductCmpts == null) {
            return this.getAllProductCmpts();
        }
        return this.getLinkedProductCmpts(contextProductCmpts);
    }

    /*
     * WARNING - void declaration
     */
    private Set<IProductCmpt> getAllProductCmpts() {
        LinkedHashSet<IProductCmpt> result = new LinkedHashSet<IProductCmpt>();
        IType target = this.getAssociation().findTarget(this.getIpsProject());
        IType iType = target;
        if (iType instanceof IPolicyCmptType) {
            void policyCmptType;
            IPolicyCmptType iPolicyCmptType = (IPolicyCmptType)iType;
            IPolicyCmptType cfr_ignored_0 = (IPolicyCmptType)iType;
            IProductCmptType productCmptType = policyCmptType.findProductCmptType(this.getIpsProject());
            Collection<IIpsSrcFile> productComponents = productCmptType.searchProductComponents(true);
            for (IIpsSrcFile ipsSrcFile : productComponents) {
                result.add((IProductCmpt)ipsSrcFile.getIpsObject());
            }
        }
        return result;
    }

    private Set<IProductCmpt> getLinkedProductCmpts(Set<IProductCmpt> contextProductCmpts) {
        LinkedHashSet<IProductCmpt> newContextCmpts = new LinkedHashSet<IProductCmpt>();
        IAssociation matchingAssociation = this.getAssociation().findMatchingAssociation();
        if (matchingAssociation == null) {
            return null;
        }
        for (IProductCmpt productCmpt : contextProductCmpts) {
            this.addLinkedProductCmpts(productCmpt, matchingAssociation, newContextCmpts);
        }
        return newContextCmpts;
    }

    private void addLinkedProductCmpts(IProductCmpt productCmpt, IAssociation matchingAssociation, Set<IProductCmpt> newContextCmpts) {
        List<IProductCmptLink> links = this.getLinks(productCmpt, matchingAssociation.getName());
        for (IProductCmptLink cmptLink : links) {
            newContextCmpts.add(cmptLink.findTarget(this.getIpsProject()));
        }
    }

    private List<IProductCmptLink> getLinks(IProductCmpt productCmpt, String productAssociationName) {
        List links = productCmpt.getLinksAsList(productAssociationName);
        if (!links.isEmpty()) {
            return links;
        }
        IProductCmptGeneration generation = this.getGeneration(productCmpt);
        if (generation != null) {
            return generation.getLinksAsList(productAssociationName);
        }
        return Collections.emptyList();
    }

    private IProductCmptGeneration getGeneration(IProductCmpt productCmpt) {
        IProductCmptGeneration generationEffectiveOn = productCmpt.getGenerationEffectiveOn(this.getValidFrom());
        if (generationEffectiveOn != null) {
            return generationEffectiveOn;
        }
        return productCmpt.getLatestProductCmptGeneration();
    }
}

