/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.builder.flidentifier.contextcollector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.AssociationNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.IdentifierNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.ParameterNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.QualifierNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.contextcollector.AbstractProductCmptCollector;
import org.faktorips.devtools.model.internal.builder.flidentifier.contextcollector.AssociationCollector;
import org.faktorips.devtools.model.internal.builder.flidentifier.contextcollector.DefaultCollector;
import org.faktorips.devtools.model.internal.builder.flidentifier.contextcollector.ParameterCollector;
import org.faktorips.devtools.model.internal.builder.flidentifier.contextcollector.QualifierCollector;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.IExpression;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;

public class ContextProductCmptFinder {
    private final LinkedList<IdentifierNode> nodes;
    private final IExpression expression;
    private final IIpsProject ipsProject;

    public ContextProductCmptFinder(LinkedList<IdentifierNode> nodes, IExpression expression, IIpsProject ipsProject) {
        this.nodes = nodes;
        this.expression = expression;
        this.ipsProject = ipsProject;
    }

    public List<IProductCmpt> getContextProductCmpts() {
        Set<IProductCmpt> contextProductCmpts = this.createCollector().getContextProductCmpts();
        if (contextProductCmpts == null) {
            return Collections.emptyList();
        }
        ArrayList<IProductCmpt> result = new ArrayList<IProductCmpt>(contextProductCmpts);
        Collections.sort(result, Comparator.comparing(IIpsElement::getName));
        return result;
    }

    protected AbstractProductCmptCollector createCollector() {
        IdentifierNode node = this.nodes.isEmpty() ? null : this.nodes.pop();
        if (node instanceof AssociationNode) {
            return new AssociationCollector((AssociationNode)node, this);
        }
        if (node instanceof ParameterNode) {
            return new ParameterCollector((ParameterNode)node, this);
        }
        if (node instanceof QualifierNode) {
            return new QualifierCollector((QualifierNode)node, this);
        }
        return new DefaultCollector(node, this);
    }

    protected IIpsProject getIpsProject() {
        return this.ipsProject;
    }

    protected IExpression getExpression() {
        return this.expression;
    }
}

