/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.datatype;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.codegen.DatatypeHelper;
import org.faktorips.datatype.Datatype;
import org.faktorips.devtools.model.plugin.ExtensionPoints;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.plugin.IpsStatus;

public class DatatypeDefinition {
    static final String DATATYPE_DEFINTIION = "datatypeDefinition";
    static final String DATATYPE_CLASS = "datatypeClass";
    static final String HELPER_CLASS = "helperClass";
    private static final String ILLEGAL_DEFINITION = "Illegal datatype definition %s. Expected Config Element <datatypeDefinition> but was %s";
    private final Datatype datatype;
    private final DatatypeHelper helper;

    public DatatypeDefinition(IExtension extension, IConfigurationElement configElement) {
        if (!StringUtils.equalsIgnoreCase((CharSequence)DATATYPE_DEFINTIION, (CharSequence)configElement.getName())) {
            String text = String.format(ILLEGAL_DEFINITION, extension.getUniqueIdentifier(), configElement.getName());
            IpsLog.log((IStatus)new IpsStatus(text));
            this.datatype = null;
            this.helper = null;
            return;
        }
        Datatype datatypeObj = ExtensionPoints.createExecutableExtension(extension, configElement, DATATYPE_CLASS, Datatype.class);
        if (datatypeObj instanceof Datatype) {
            this.datatype = datatypeObj;
            DatatypeHelper helperObj = ExtensionPoints.createExecutableExtension(extension, configElement, HELPER_CLASS, DatatypeHelper.class);
            if (helperObj instanceof DatatypeHelper) {
                this.helper = helperObj;
                this.helper.setDatatype(this.datatype);
            } else {
                this.helper = null;
            }
        } else {
            this.datatype = null;
            this.helper = null;
        }
    }

    public boolean hasDatatype() {
        return this.datatype != null;
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public boolean hasHelper() {
        return this.helper != null;
    }

    public DatatypeHelper getHelper() {
        return this.helper;
    }
}

