/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.datatype;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.datatype.DefaultGenericEnumDatatype;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.datatype.IDynamicEnumDatatype;
import org.faktorips.devtools.model.internal.datatype.DynamicValueDatatype;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.w3c.dom.Element;

public class DynamicEnumDatatype
extends DynamicValueDatatype
implements IDynamicEnumDatatype {
    public DynamicEnumDatatype(IIpsProject ipsProject) {
        super(ipsProject);
    }

    public String[] getAllValueIds(boolean includeNull) {
        if (this.getAdaptedClass() == null) {
            throw new RuntimeException("Datatype " + this.getQualifiedName() + ", Class " + this.getAdaptedClassName() + " not found.");
        }
        DefaultGenericEnumDatatype datatype = new DefaultGenericEnumDatatype(this.getAdaptedClass());
        datatype.setToStringMethodName(this.getToStringMethodName());
        datatype.setAllValuesMethodName(this.getAllValuesMethodName());
        return datatype.getAllValueIds(includeNull);
    }

    @Override
    public String getValueName(String id) {
        if (!this.isSupportingNames()) {
            IpsLog.log((IStatus)new IpsStatus("The getName(String) method is not supported by this enumeration class: " + this.getAdaptedClass()));
            return id;
        }
        DefaultGenericEnumDatatype datatype = new DefaultGenericEnumDatatype(this.getAdaptedClass());
        datatype.setIsSupportingNames(this.isSupportingNames());
        datatype.setGetNameMethodName(this.getGetNameMethodName());
        datatype.setValueOfMethodName(this.getValueOfMethodName());
        datatype.setToStringMethodName(this.getToStringMethodName());
        try {
            return datatype.getValueName(id, IIpsModelExtensions.get().getModelPreferences().getDatatypeFormattingLocale());
        }
        catch (Exception e) {
            IpsLog.log((IStatus)new IpsStatus("Error getting name for enum value id " + id, e));
            return id;
        }
    }

    public Object getValueByName(String name, Locale locale) {
        if (IpsStringUtils.isBlank((String)this.getGetValueByNameMethodName())) {
            return Arrays.stream(this.getAllValueIds(false)).map(arg_0 -> ((DynamicEnumDatatype)this).getValue(arg_0)).filter(v -> Objects.equals(name, this.getNameFromValue(v, locale))).findFirst().orElse(null);
        }
        return super.getValueByName(name, locale);
    }

    @Override
    public void writeToXml(Element element) {
        super.writeToXml(element);
        element.setAttribute("isEnumType", "true");
        if (this.getAllValuesMethodName() != null) {
            element.setAttribute("getAllValuesMethod", this.getAllValuesMethodName());
        }
    }
}

