/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.datatype;

import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import org.faktorips.datatype.EnumDatatype;
import org.faktorips.datatype.GenericValueDatatype;
import org.faktorips.devtools.abstraction.AJavaProject;
import org.faktorips.devtools.model.IClassLoaderProvider;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.datatype.IDynamicValueDatatype;
import org.faktorips.devtools.model.internal.datatype.DynamicEnumDatatype;
import org.faktorips.devtools.model.ipsproject.IClasspathContentsChangeListener;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.plugin.NamedDataTypeDisplay;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.faktorips.util.MethodAccess;
import org.w3c.dom.Element;

public class DynamicValueDatatype
extends GenericValueDatatype
implements IDynamicValueDatatype {
    public static final String MSGCODE_PREFIX_GET_NAME_METHOD = "GENERIC DATATYPE-getNameMethod";
    public static final String MSGCODE_GET_NAME_METHOD_IS_BLANK = "GENERIC DATATYPE-getNameMethod is empty or blank";
    public static final String MSGCODE_PREFIX_GET_VALUE_BY_NAME_METHOD = "GENERIC DATATYPE-getValueByName";
    public static final String MSGCODE_GET_VALUE_BY_NAME_METHOD_IS_BLANK = "GENERIC DATATYPE-getValueByName is empty or blank";
    private IIpsProject ipsProject;
    private IClassLoaderProvider classLoaderProvider;
    private IClasspathContentsChangeListener listener;
    private boolean isSupportingNames = false;
    private String getNameMethodName = "";
    private String getValueByNameMethodName = "";
    private String className;
    private Class<?> adaptedClass;

    public DynamicValueDatatype(IIpsProject ipsProject) {
        this.ipsProject = ipsProject;
    }

    @Override
    public void setAdaptedClassName(String className) {
        this.className = className;
        this.clearCache();
    }

    @Override
    public void setAdaptedClass(Class<?> clazz) {
        this.adaptedClass = clazz;
        this.className = clazz.getName();
    }

    @Override
    public String getAdaptedClassName() {
        return this.className;
    }

    protected void clearCache() {
        super.clearCache();
        this.adaptedClass = null;
    }

    @Override
    public Class<?> getAdaptedClass() {
        if (this.adaptedClass == null) {
            try {
                this.classLoaderProvider = this.ipsProject.getClassLoaderProviderForJavaProject();
                this.adaptedClass = this.classLoaderProvider.getClassLoader().loadClass(this.className);
                this.listener = this::clearCacheAndRemoveListener;
                this.classLoaderProvider.addClasspathChangeListener(this.listener);
            }
            catch (Throwable t) {
                IpsLog.log(t);
                this.adaptedClass = null;
            }
        }
        return this.adaptedClass;
    }

    private void clearCacheAndRemoveListener(AJavaProject project) {
        this.clearCache();
        IIpsModel.get().getIpsProject(project.getProject()).getClassLoaderProviderForJavaProject().removeClasspathChangeListener(this.listener);
        this.listener = null;
    }

    @Override
    public void writeToXml(Element element) {
        if (this.getAdaptedClassName() != null) {
            element.setAttribute("javaClass", this.getAdaptedClassName());
        }
        if (this.getQualifiedName() != null) {
            element.setAttribute("id", this.getQualifiedName());
        }
        if (this.getValueOfMethodName() != null) {
            element.setAttribute("valueOfMethod", this.getValueOfMethodName());
        }
        if (this.getIsParsableMethodName() != null) {
            element.setAttribute("isParsableMethod", this.getIsParsableMethodName());
        }
        if (this.getToStringMethodName() != null) {
            element.setAttribute("valueToStringMethod", this.getToStringMethodName());
        }
        if (this.getGetNameMethodName() != null) {
            element.setAttribute("getNameMethod", this.getGetNameMethodName());
        }
        if (this.getGetValueByNameMethodName() != null) {
            element.setAttribute("getValueByNameMethod", this.getGetValueByNameMethodName());
        }
        if (this.getAllValuesMethodName() != null) {
            element.setAttribute("getAllValuesMethod", this.getAllValuesMethodName());
        }
        element.setAttribute("isSupportingNames", Boolean.toString(this.isSupportingNames()));
        if (this.hasNullObject()) {
            ValueToXmlHelper.addValueToElement((String)this.getNullObjectId(), (Element)element, (String)"NullObjectId");
        }
    }

    public static final DynamicValueDatatype createFromXml(IIpsProject ipsProject, Element element) {
        DynamicValueDatatype datatype = DynamicValueDatatype.createDynamicValueOrEnumDatatype(ipsProject, element);
        String javaClass = element.getAttribute("valueClass");
        if (IpsStringUtils.isEmpty((String)javaClass)) {
            javaClass = element.getAttribute("javaClass");
        }
        datatype.setAdaptedClassName(javaClass);
        datatype.setQualifiedName(element.getAttribute("id"));
        if (element.hasAttribute("valueOfMethod")) {
            datatype.setValueOfMethodName(element.getAttribute("valueOfMethod"));
        } else {
            datatype.setValueOfMethodName(null);
        }
        if (element.hasAttribute("isParsableMethod")) {
            datatype.setIsParsableMethodName(element.getAttribute("isParsableMethod"));
        } else {
            datatype.setIsParsableMethodName(null);
        }
        if (element.hasAttribute("valueToStringMethod")) {
            datatype.setToStringMethodName(element.getAttribute("valueToStringMethod"));
        } else {
            datatype.setToStringMethodName("toString");
        }
        if (element.hasAttribute("getNameMethod")) {
            datatype.setGetNameMethodName(element.getAttribute("getNameMethod"));
        } else {
            datatype.setGetNameMethodName(null);
        }
        if (element.hasAttribute("getValueByNameMethod")) {
            datatype.setGetValueByNameMethodName(element.getAttribute("getValueByNameMethod"));
        } else {
            datatype.setGetValueByNameMethodName(null);
        }
        if (element.hasAttribute("getAllValuesMethod")) {
            datatype.setAllValuesMethodName(element.getAttribute("getAllValuesMethod"));
        } else {
            datatype.setAllValuesMethodName(null);
        }
        String isSupporting = element.getAttribute("isSupportingNames");
        datatype.setIsSupportingNames(IpsStringUtils.isEmpty((String)isSupporting) ? false : Boolean.parseBoolean(isSupporting));
        Element nullObjectEl = XmlUtil.getFirstElement(element, "NullObjectId");
        if (nullObjectEl == null) {
            datatype.setNullObjectDefined(false);
            datatype.setNullObjectId(null);
        } else {
            datatype.setNullObjectDefined(true);
            datatype.setNullObjectId(ValueToXmlHelper.getValueFromElement((Element)element, (String)"NullObjectId"));
        }
        return datatype;
    }

    private static DynamicValueDatatype createDynamicValueOrEnumDatatype(IIpsProject ipsProject, Element element) {
        String isEnumTypeString = element.getAttribute("isEnumType");
        DynamicValueDatatype datatype = IpsStringUtils.isEmpty((String)isEnumTypeString) || !Boolean.parseBoolean(isEnumTypeString) ? new DynamicValueDatatype(ipsProject) : new DynamicEnumDatatype(ipsProject);
        return datatype;
    }

    @Override
    public void setIsSupportingNames(boolean supporting) {
        this.isSupportingNames = supporting;
    }

    public boolean isSupportingNames() {
        return this.isSupportingNames;
    }

    @Override
    public void setGetNameMethodName(String getNameMethodName) {
        this.getNameMethodName = getNameMethodName;
    }

    @Override
    public String getGetNameMethodName() {
        return this.getNameMethodName;
    }

    public String getValueName(String id) {
        return this.getValueName(id, IIpsModelExtensions.get().getModelPreferences().getDatatypeFormattingLocale());
    }

    public String getValueName(String id, Locale locale) {
        if (IpsStringUtils.isBlank((String)this.getNameMethodName)) {
            throw new UnsupportedOperationException("This value type does not support a getName() method, value type class: " + this.getAdaptedClass());
        }
        return this.getValueNameFromClass(id, locale);
    }

    public Object getValueByName(String valueName) {
        if (IpsStringUtils.isBlank((String)this.getValueByNameMethodName) && IpsStringUtils.isBlank((String)this.getAllValuesMethodName())) {
            throw new UnsupportedOperationException("This value type does not support a getValueByName(String) method, value type class: " + this.getAdaptedClass());
        }
        if (IpsStringUtils.isBlank((String)this.getValueByNameMethodName)) {
            return this.findValueByNameInAllValues(valueName);
        }
        return this.getValueByNameFromClass(valueName);
    }

    private Object findValueByNameInAllValues(String valueName) {
        Object result = this.getAllValuesMethod().invokeStatic("to get all values", new Object[0]);
        Object[] values = result instanceof Collection ? ((Collection)result).toArray(Object[]::new) : (Object[])result;
        return Arrays.stream(values).filter(v -> Objects.equals(valueName, this.getNameFromValue(v, IIpsModelExtensions.get().getModelPreferences().getDatatypeFormattingLocale()))).findFirst().orElseThrow(() -> new IllegalArgumentException(String.valueOf(valueName) + " could not be found in all values."));
    }

    @Override
    public String getGetValueByNameMethodName() {
        return this.getValueByNameMethodName;
    }

    @Override
    public void setGetValueByNameMethodName(String name) {
        this.getValueByNameMethodName = name;
    }

    public MessageList checkReadyToUse() {
        MessageList ml = super.checkReadyToUse();
        if (this.isSupportingNames()) {
            this.checkGetValueByName(ml);
            this.checkGetName(ml);
        }
        return ml;
    }

    private MethodAccess getGetValueByNameMethod() {
        return MethodAccess.of(this.getAdaptedClass(), (String)this.getGetValueByNameMethodName(), (Class[])new Class[]{CharSequence.class});
    }

    private void checkGetValueByName(MessageList ml) {
        if (IpsStringUtils.isBlank((String)this.getGetValueByNameMethodName())) {
            if (IpsStringUtils.isBlank((String)this.getAllValuesMethodName())) {
                if (NamedDataTypeDisplay.NAME.equals((Object)IIpsModelExtensions.get().getModelPreferences().getNamedDataTypeDisplay())) {
                    ml.add(Message.newError((String)MSGCODE_GET_VALUE_BY_NAME_METHOD_IS_BLANK, (String)("The datatype display type is \"Name\" but no getValueByNameMethod or getAllValuesMethod are configured for the datatype " + this.getName() + ". Either define one of these methods or change the datatype display type to \"Name and Id\" and perform a clean build.")));
                }
                if (!(this instanceof EnumDatatype)) {
                    ml.add(Message.newError((String)MSGCODE_GET_VALUE_BY_NAME_METHOD_IS_BLANK, (String)("SupportingNames is true but no getValueByNameMethod or getAllValuesMethod is configured for datatype " + this.getName())));
                }
            }
            return;
        }
        this.getGetValueByNameMethod().check(ml, MSGCODE_PREFIX_GET_VALUE_BY_NAME_METHOD).exists().isStatic().returnTypeIsCompatible(new Class[]{this.getAdaptedClass()});
    }

    private Object getValueByNameFromClass(String valueName) {
        if (valueName == null) {
            return null;
        }
        return this.getGetValueByNameMethod().invokeStatic("to get the value for a name", new Object[]{valueName});
    }

    private MethodAccess getNameMethod() {
        return MethodAccess.of(this.getAdaptedClass(), (String)this.getGetNameMethodName(), (Class[])new Class[0]);
    }

    private MethodAccess getNameMethodWithLocale() {
        return MethodAccess.of(this.getAdaptedClass(), (String)this.getGetNameMethodName(), (Class[])new Class[]{Locale.class});
    }

    private void checkGetName(MessageList ml) {
        if (IpsStringUtils.isBlank((String)this.getGetNameMethodName())) {
            ml.add(Message.newError((String)MSGCODE_GET_NAME_METHOD_IS_BLANK, (String)"SupportingNames is true but no getNameMethod is configured."));
            return;
        }
        this.getNameMethod().check(ml, MSGCODE_PREFIX_GET_NAME_METHOD).exists().isNotStatic().returnTypeIsCompatible(new Class[]{String.class});
    }

    private String getValueNameFromClass(String id, Locale locale) {
        Object value = this.getValue(id);
        return this.getNameFromValue(value, locale);
    }

    protected String getNameFromValue(Object value, Locale locale) {
        if (value == null) {
            return null;
        }
        String methodDescription = "to get the value name";
        MethodAccess nameMethodWithLocale = this.getNameMethodWithLocale();
        return nameMethodWithLocale.exists() ? (String)nameMethodWithLocale.invoke(methodDescription, value, new Object[]{locale}) : (String)this.getNameMethod().invoke(methodDescription, value, new Object[0]);
    }
}

