/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.dependency;

import java.io.Serializable;
import org.faktorips.devtools.model.DependencyType;
import org.faktorips.devtools.model.dependency.IDependency;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.util.ArgumentCheck;

public class DatatypeDependency
implements IDependency,
Serializable {
    private static final long serialVersionUID = 6487956167551523725L;
    private QualifiedNameType source;
    private String target;
    private DependencyType type;
    private int hashCode;

    public DatatypeDependency(QualifiedNameType source, String target) {
        ArgumentCheck.notNull((Object)source, (Object)this);
        ArgumentCheck.notNull((Object)target, (Object)this);
        this.source = source;
        this.target = target;
        this.type = DependencyType.DATATYPE;
        this.calculateHashCode();
    }

    @Override
    public QualifiedNameType getSource() {
        return this.source;
    }

    public String getTargetAsQualifiedName() {
        return this.target;
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    @Override
    public DependencyType getType() {
        return this.type;
    }

    private void calculateHashCode() {
        int result = 17;
        result = result * 37 + this.source.hashCode();
        this.hashCode = result = result * 37 + this.target.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void other;
        Object object = obj;
        if (!(object instanceof DatatypeDependency)) {
            return false;
        }
        DatatypeDependency datatypeDependency = (DatatypeDependency)object;
        DatatypeDependency cfr_ignored_0 = (DatatypeDependency)object;
        return this.getSource().equals(other.getSource()) && this.getTarget().equals(other.getTarget()) && this.getType().equals((Object)other.getType());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "(" + this.source.toString() + " -> " + this.target + ", type: " + (Object)((Object)this.type) + ")";
    }
}

