/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.dependency;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.dependency.IDependencyDetail;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;
import org.faktorips.devtools.model.ipsproject.IIpsPackageFragment;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.devtools.model.util.BeanUtil;
import org.faktorips.util.ArgumentCheck;

public class DependencyDetail
implements IDependencyDetail {
    private IIpsObjectPartContainer part;
    private String propertyName;

    public DependencyDetail(IIpsObjectPartContainer part, String propertyName) {
        ArgumentCheck.notNull((Object)part, (Object)"The part of a DependencyDetail must not be null");
        ArgumentCheck.notNull((Object)propertyName, (Object)"The propertyName of a DependencyDetail must not be null");
        this.part = part;
        this.propertyName = propertyName;
    }

    @Override
    public IIpsObjectPartContainer getPart() {
        return this.part;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public void refactorAfterRename(IIpsPackageFragment targetIpsPackageFragment, String newName) {
        try {
            this.updateProperty(targetIpsPackageFragment, newName);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IpsException((IStatus)new IpsStatus(e));
        }
    }

    private void updateProperty(IIpsPackageFragment targetIpsPackageFragment, String newName) throws IllegalAccessException, InvocationTargetException {
        PropertyDescriptor property = BeanUtil.getPropertyDescriptor(this.getPart().getClass(), this.getPropertyName());
        String newQualifiedName = this.buildQualifiedName(targetIpsPackageFragment, newName);
        property.getWriteMethod().invoke((Object)this.getPart(), newQualifiedName);
    }

    private String buildQualifiedName(IIpsPackageFragment ipsPackageFragment, String name) {
        return ipsPackageFragment.isDefaultPackage() ? name : String.valueOf(ipsPackageFragment.getName()) + "." + name;
    }

    public int hashCode() {
        return Objects.hash(this.part, this.propertyName);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void other;
        Object object;
        if (this == obj) {
            return true;
        }
        if (obj == null || !((object = obj) instanceof DependencyDetail)) {
            return false;
        }
        DependencyDetail dependencyDetail = (DependencyDetail)object;
        DependencyDetail cfr_ignored_0 = (DependencyDetail)object;
        return Objects.equals(this.part, other.part) && Objects.equals(this.propertyName, other.propertyName);
    }
}

