/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.dependency;

import java.io.Serializable;
import org.faktorips.devtools.model.DependencyType;
import org.faktorips.devtools.model.dependency.IDependency;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.util.ArgumentCheck;

public class IpsObjectDependency
implements IDependency,
Serializable {
    private static final long serialVersionUID = -4763466997240470890L;
    private QualifiedNameType source;
    private QualifiedNameType target;
    private int hashCode;
    private DependencyType dependencyType;

    private IpsObjectDependency(QualifiedNameType source, QualifiedNameType target, DependencyType dependencyType) {
        ArgumentCheck.notNull((Object)source, (Object)this);
        ArgumentCheck.notNull((Object)target, (Object)this);
        ArgumentCheck.notNull((Object)((Object)dependencyType), (Object)this);
        this.source = source;
        this.target = target;
        this.dependencyType = dependencyType;
        this.calculateHashCode();
    }

    public static final IpsObjectDependency create(QualifiedNameType source, QualifiedNameType target, DependencyType dependencyType) {
        return new IpsObjectDependency(source, target, dependencyType);
    }

    public static final IpsObjectDependency createSubtypeDependency(QualifiedNameType source, QualifiedNameType target) {
        return new IpsObjectDependency(source, target, DependencyType.SUBTYPE);
    }

    public static final IpsObjectDependency createConfiguredByDependency(QualifiedNameType source, QualifiedNameType target) {
        return new IpsObjectDependency(source, target, DependencyType.CONFIGUREDBY);
    }

    public static final IpsObjectDependency createConfiguresDependency(QualifiedNameType source, QualifiedNameType target) {
        return new IpsObjectDependency(source, target, DependencyType.CONFIGURES);
    }

    public static final IpsObjectDependency createReferenceDependency(QualifiedNameType source, QualifiedNameType target) {
        return new IpsObjectDependency(source, target, DependencyType.REFERENCE);
    }

    public static final IpsObjectDependency createCompostionMasterDetailDependency(QualifiedNameType source, QualifiedNameType target) {
        return new IpsObjectDependency(source, target, DependencyType.REFERENCE_COMPOSITION_MASTER_DETAIL);
    }

    public static final IpsObjectDependency createInstanceOfDependency(QualifiedNameType source, QualifiedNameType target) {
        return new IpsObjectDependency(source, target, DependencyType.INSTANCEOF);
    }

    @Override
    public QualifiedNameType getSource() {
        return this.source;
    }

    public QualifiedNameType getTargetAsQNameType() {
        return this.target;
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    @Override
    public DependencyType getType() {
        return this.dependencyType;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void other;
        Object object = o;
        if (!(object instanceof IpsObjectDependency)) {
            return false;
        }
        IpsObjectDependency ipsObjectDependency = (IpsObjectDependency)object;
        IpsObjectDependency cfr_ignored_0 = (IpsObjectDependency)object;
        return this.dependencyType.equals((Object)other.getType()) && this.target.equals(other.getTarget()) && this.source.equals(other.getSource());
    }

    private void calculateHashCode() {
        int result = 17;
        result = result * 37 + this.target.hashCode();
        result = result * 37 + this.source.hashCode();
        this.hashCode = result = result * 37 + this.dependencyType.hashCode();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "(" + this.source.toString() + " -> " + this.target.toString() + ", type: " + (Object)((Object)this.dependencyType) + ")";
    }
}

