/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.enums;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.abstraction.util.JavaConventions;
import org.faktorips.devtools.model.enums.EnumTypeDatatypeAdapter;
import org.faktorips.devtools.model.enums.IEnumAttribute;
import org.faktorips.devtools.model.enums.IEnumLiteralNameAttribute;
import org.faktorips.devtools.model.enums.IEnumType;
import org.faktorips.devtools.model.internal.enums.Messages;
import org.faktorips.devtools.model.internal.ipsobject.AtomicIpsObjectPart;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.util.DatatypeUtil;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EnumAttribute
extends AtomicIpsObjectPart
implements IEnumAttribute {
    private String datatype = "";
    private boolean inherited = false;
    private boolean unique = false;
    private boolean identifier = false;
    private boolean usedAsNameInFaktorIpsUi = false;
    private boolean multilingual;

    public EnumAttribute(IEnumType parent, String id) {
        super(parent, id);
    }

    @Override
    public void setName(String name) {
        ArgumentCheck.notNull((Object)name);
        String oldName = this.name;
        this.name = name;
        this.valueChanged(oldName, name, "name");
    }

    @Override
    public void setDatatype(String datatype) {
        ArgumentCheck.notNull((Object)datatype);
        String oldDatatype = this.datatype;
        this.datatype = datatype;
        this.valueChanged(oldDatatype, datatype);
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement("EnumAttribute");
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        this.name = element.getAttribute("name");
        this.datatype = element.getAttribute("datatype");
        this.unique = XmlUtil.getBooleanAttributeOrFalse(element, "unique");
        this.multilingual = XmlUtil.getBooleanAttributeOrFalse(element, "multilingual");
        this.identifier = XmlUtil.getBooleanAttributeOrFalse(element, "identifier");
        this.usedAsNameInFaktorIpsUi = XmlUtil.getBooleanAttributeOrFalse(element, "usedAsNameInFaktorIpsUi");
        this.inherited = XmlUtil.getBooleanAttributeOrFalse(element, "inherited");
        super.initPropertiesFromXml(element, id);
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("name", this.name);
        element.setAttribute("datatype", this.datatype);
        if (this.unique) {
            element.setAttribute("unique", String.valueOf(this.unique));
        }
        if (this.multilingual) {
            element.setAttribute("multilingual", String.valueOf(this.multilingual));
        }
        if (this.identifier) {
            element.setAttribute("identifier", String.valueOf(this.identifier));
        }
        if (this.usedAsNameInFaktorIpsUi) {
            element.setAttribute("usedAsNameInFaktorIpsUi", String.valueOf(this.usedAsNameInFaktorIpsUi));
        }
        if (this.inherited) {
            element.setAttribute("inherited", String.valueOf(this.inherited));
        }
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        this.validateName(list, ipsProject);
        if (!this.inherited) {
            this.validateDatatype(list, ipsProject);
            this.validateDuplicateIndicator(list, new IdentifierIndicationProvider());
            this.validateDuplicateIndicator(list, new DisplayNameIndicationProvider());
            this.validateAllowedAsIdentifier(list);
        } else {
            this.validateInherited(list, ipsProject);
            this.validateSupertypeMismatchLingual(list, ipsProject);
        }
    }

    private void validateAllowedAsIdentifier(MessageList list) {
        if (this.isIdentifier() && this.isMultilingual()) {
            list.add(new Message("ENUMATTRIBUTE-IdentifierNotAllowed", MessageFormat.format(Messages.EnumAttribute_MultilingualCannotBeIdentifier, this.getName()), Message.ERROR, (Object)this, new String[]{"multilingual", "identifier"}));
        }
    }

    private void validateSupertypeMismatchLingual(MessageList list, IIpsProject ipsProject) {
        if (this.checkSupertypeMissmatchLingual(ipsProject)) {
            list.add(new Message("ENUMATTRIBUTE-EnumAttributeInheritedLingualMismatch", Messages.EnumAttribute_InheritedMultiLingualMismatch, Message.ERROR, (Object)this, new String[]{"multilingual"}));
        }
    }

    private boolean checkSupertypeMissmatchLingual(IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object)ipsProject);
        IEnumAttribute superEnumAttribute = this.findSuperEnumAttribute(ipsProject);
        if (superEnumAttribute == null) {
            return false;
        }
        return this.multilingual ^ superEnumAttribute.isMultilingual();
    }

    private void validateName(MessageList list, IIpsProject ipsProject) {
        if (this.name.length() == 0) {
            String text = Messages.EnumAttribute_NameMissing;
            Message validationMessage = new Message("ENUMATTRIBUTE-EnumAttributeNameMissing", text, Message.ERROR, (Object)this, new String[]{"name"});
            list.add(validationMessage);
            return;
        }
        Runtime.Version sourceVersion = ipsProject.getJavaProject().getSourceVersion();
        if (!JavaConventions.validateName((String)this.name, (Runtime.Version)sourceVersion)) {
            String text = MessageFormat.format(Messages.EnumAttribute_NameNotAValidFieldName, this.name);
            Message validationMessage = new Message("ENUMATTRIBUTE-EnumAttributeNameNotAValidFieldName", text, Message.ERROR, (Object)this, new String[]{"name"});
            list.add(validationMessage);
            return;
        }
        int numberEnumAttributesThisName = 0;
        for (IEnumAttribute enumAttribute : this.getEnumType().getEnumAttributes(true)) {
            if (enumAttribute.getName().equals(this.name)) {
                ++numberEnumAttributesThisName;
            }
            if (numberEnumAttributesThisName <= 1) continue;
            String text = MessageFormat.format(Messages.EnumAttribute_DuplicateName, this.name);
            Message validationMessage = new Message("ENUMATTRIBUTE-EnumAttributeDuplicateName", text, Message.ERROR, (Object)this, new String[]{"name"});
            list.add(validationMessage);
            return;
        }
        List<IEnumAttribute> allEnumAttributes = this.getEnumType().findAllEnumAttributes(true, ipsProject);
        numberEnumAttributesThisName = 0;
        for (IEnumAttribute enumAttribute : allEnumAttributes) {
            if (enumAttribute.getName().equals(this.name)) {
                ++numberEnumAttributesThisName;
            }
            if (numberEnumAttributesThisName <= 1) continue;
            String text = MessageFormat.format(Messages.EnumAttribute_DuplicateNameInSupertypeHierarchy, this.name);
            Message validationMessage = new Message("ENUMATTRIBUTE-EnumAttributeDuplicateNameInSupertypeHierarchy", text, Message.ERROR, (Object)this, new String[]{"name"});
            list.add(validationMessage);
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validateDatatype(MessageList list, IIpsProject ipsProject) {
        Datatype datatype;
        Object adaptedEnumType;
        Datatype datatype2;
        Message validationMessage;
        String text;
        IEnumType enumType = this.getEnumType();
        Datatype ipsDatatype = this.getIpsProject().findDatatype(this.datatype);
        if (this.datatype.length() == 0) {
            String text2 = Messages.EnumAttribute_DatatypeMissing;
            Message validationMessage2 = new Message("ENUMATTRIBUTE-EnumAttributeDatatypeMissing", text2, Message.ERROR, (Object)this, new String[]{"datatype"});
            list.add(validationMessage2);
            return;
        }
        if (ipsDatatype == null) {
            String text3 = MessageFormat.format(Messages.EnumAttribute_DatatypeDoesNotExist, this.datatype);
            Message validationMessage3 = new Message("ENUMATTRIBUTE-EnumAttributeDatatypeDoesNotExist", text3, Message.ERROR, (Object)this, new String[]{"datatype"});
            list.add(validationMessage3);
            return;
        }
        if (ipsDatatype.isVoid()) {
            text = Messages.EnumAttribute_DatatypeIsVoid;
            validationMessage = new Message("ENUMATTRIBUTE-EnumAttributeDatatypeIsVoid", text, Message.ERROR, (Object)this, new String[]{"datatype"});
            list.add(validationMessage);
        }
        if (ipsDatatype.isAbstract()) {
            text = MessageFormat.format(Messages.EnumAttribute_DatatypeIsAbstract, this.datatype);
            validationMessage = new Message("ENUMATTRIBUTE-EnumAttributeDatatypeIsAbstract", text, Message.ERROR, (Object)this, new String[]{"datatype"});
            list.add(validationMessage);
        }
        if ((datatype2 = ipsDatatype) instanceof EnumTypeDatatypeAdapter) {
            void adapter;
            EnumTypeDatatypeAdapter enumTypeDatatypeAdapter = (EnumTypeDatatypeAdapter)datatype2;
            EnumTypeDatatypeAdapter cfr_ignored_0 = (EnumTypeDatatypeAdapter)datatype2;
            adaptedEnumType = adapter.getEnumType();
            if (adaptedEnumType.isSubEnumTypeOrSelf(enumType, ipsProject)) {
                text = Messages.EnumAttribute_DatatypeIsContainingEnumTypeOrSubclass;
                validationMessage = new Message("ENUMATTRIBUTE-EnumAttributeDatatypeIsContainingEnumTypeOrSubclass", text, Message.ERROR, (Object)this, new String[]{"datatype"});
                list.add(validationMessage);
            }
        }
        if ((datatype = ipsDatatype) instanceof EnumTypeDatatypeAdapter) {
            void enumDatatypeAdapter;
            adaptedEnumType = (EnumTypeDatatypeAdapter)datatype;
            EnumTypeDatatypeAdapter cfr_ignored_1 = (EnumTypeDatatypeAdapter)datatype;
            IEnumType enumDatatype = enumDatatypeAdapter.getEnumType();
            if (enumType.isInextensibleEnum() && !enumDatatype.isInextensibleEnum()) {
                text = MessageFormat.format(Messages.EnumAttribute_EnumDatatypeDoesNotContainValuesButParentEnumTypeDoes, enumDatatype.getQualifiedName());
                validationMessage = new Message("ENUMATTRIBUTE-EnumAttributeEnumDatatypeDoesNotContainValuesButParentEnumTypeDoes", text, Message.ERROR, (Object)this, new String[]{"datatype"});
                list.add(validationMessage);
            }
        }
    }

    private void validateInherited(MessageList list, IIpsProject ipsProject) {
        if (!this.getEnumType().hasSuperEnumType()) {
            String text = Messages.EnumAttribute_InheritedButNoSupertype;
            Message validationMessage = new Message("ENUMATTRIBUTE-EnumAttributeInheritedButNoSupertype", text, Message.ERROR, (Object)this, new String[]{"inherited"});
            list.add(validationMessage);
            return;
        }
        if (this.getEnumType().hasExistingSuperEnumType(ipsProject) && this.findSuperEnumAttribute(ipsProject) == null) {
            String text = MessageFormat.format(Messages.EnumAttribute_NoSuchAttributeInSupertypeHierarchy, this.name);
            Message validationMessage = new Message("ENUMATTRIBUTE-EnumAttributeNoSuchAttributeInSupertypeHierarchy", text, Message.ERROR, (Object)this, new String[]{"name", "inherited"});
            list.add(validationMessage);
        }
    }

    @Override
    public boolean isInherited() {
        return this.inherited;
    }

    @Override
    public void setInherited(boolean isInherited) {
        boolean oldIsInherited = this.inherited;
        this.inherited = isInherited;
        this.valueChanged(oldIsInherited, isInherited);
        if (isInherited) {
            this.setDatatype("");
            this.setUnique(false);
            this.setIdentifier(false);
            this.setUsedAsNameInFaktorIpsUi(false);
        }
    }

    @Override
    public IEnumType getEnumType() {
        return (IEnumType)this.getParent();
    }

    @Override
    public String getDatatype() {
        return this.datatype;
    }

    @Override
    public void setMultilingual(boolean multilingual) {
        boolean oldMultilingual = this.multilingual;
        this.multilingual = multilingual;
        this.valueChanged(oldMultilingual, multilingual, "multilingual");
    }

    @Override
    public boolean isMultilingual() {
        return this.isMultilingualSupported() && this.multilingual;
    }

    @Override
    public boolean isMultilingualSupported() {
        return Datatype.STRING.equals((Object)this.findDatatype(this.getIpsProject()));
    }

    @Override
    public ValueDatatype findDatatype(IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object)ipsProject);
        if (this.inherited) {
            IEnumAttribute superEnumAttribute = this.findSuperEnumAttribute(ipsProject);
            if (superEnumAttribute == null) {
                return null;
            }
            return superEnumAttribute.findDatatype(ipsProject);
        }
        return ipsProject.findValueDatatype(this.datatype);
    }

    @Override
    public ValueDatatype findDatatypeIgnoreEnumContents(IIpsProject ipsProject) {
        ValueDatatype foundDatatype = this.findDatatype(ipsProject);
        if (DatatypeUtil.isExtensibleEnumType((Datatype)foundDatatype)) {
            EnumTypeDatatypeAdapter enumDatatype = (EnumTypeDatatypeAdapter)foundDatatype;
            return new EnumTypeDatatypeAdapter(enumDatatype.getEnumType(), null);
        }
        return foundDatatype;
    }

    @Override
    public IEnumAttribute findSuperEnumAttribute(IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object)ipsProject);
        if (!this.inherited) {
            return null;
        }
        IEnumType enumType = this.getEnumType();
        return enumType.findEnumAttributeIncludeSupertypeOriginals(ipsProject, this.name);
    }

    @Override
    public List<IEnumAttribute> searchInheritedCopies(IIpsProject ipsProject) {
        Set<IEnumType> subclassingEnumTypes = this.getEnumType().searchSubclassingEnumTypes();
        ArrayList<IEnumAttribute> inheritedAttributeCopies = new ArrayList<IEnumAttribute>(subclassingEnumTypes.size());
        for (IEnumType subclassingEnumType : subclassingEnumTypes) {
            IEnumAttribute inheritedAttribute = subclassingEnumType.getEnumAttributeIncludeSupertypeCopies(this.name);
            if (inheritedAttribute == null) continue;
            inheritedAttributeCopies.add(inheritedAttribute);
        }
        return inheritedAttributeCopies;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public void setUnique(boolean uniqueIdentifier) {
        boolean oldIsUniqueIdentifier = this.unique;
        this.unique = uniqueIdentifier;
        this.valueChanged(oldIsUniqueIdentifier, uniqueIdentifier);
    }

    @Override
    public boolean findIsUnique(IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object)ipsProject);
        if (this.inherited) {
            IEnumAttribute superEnumAttribute = this.findSuperEnumAttribute(ipsProject);
            if (superEnumAttribute == null) {
                return false;
            }
            return superEnumAttribute.isUnique();
        }
        return this.isUnique();
    }

    @Override
    public boolean isIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean isUsedAsNameInFaktorIpsUi() {
        return this.usedAsNameInFaktorIpsUi;
    }

    @Override
    public void setIdentifier(boolean usedAsIdInFaktorIpsUi) {
        boolean oldUsedAsIdInFaktorIpsUi = this.identifier;
        this.identifier = usedAsIdInFaktorIpsUi;
        this.valueChanged(oldUsedAsIdInFaktorIpsUi, usedAsIdInFaktorIpsUi);
    }

    @Override
    public void setUsedAsNameInFaktorIpsUi(boolean usedAsNameInFaktorIpsUi) {
        boolean oldUsedAsNameInFaktorIpsUi = this.usedAsNameInFaktorIpsUi;
        this.usedAsNameInFaktorIpsUi = usedAsNameInFaktorIpsUi;
        this.valueChanged(oldUsedAsNameInFaktorIpsUi, usedAsNameInFaktorIpsUi);
    }

    @Override
    public boolean findIsIdentifier(IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object)ipsProject);
        if (this.inherited) {
            IEnumAttribute superEnumAttribute = this.findSuperEnumAttribute(ipsProject);
            if (superEnumAttribute == null) {
                return false;
            }
            return superEnumAttribute.isIdentifier();
        }
        return this.isIdentifier();
    }

    @Override
    public boolean findIsUsedAsNameInFaktorIpsUi(IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object)ipsProject);
        if (this.inherited) {
            IEnumAttribute superEnumAttribute = this.findSuperEnumAttribute(ipsProject);
            if (superEnumAttribute == null) {
                return false;
            }
            return superEnumAttribute.isUsedAsNameInFaktorIpsUi();
        }
        return this.isUsedAsNameInFaktorIpsUi();
    }

    @Override
    public boolean isLiteralNameDefaultValueProvider() {
        IEnumLiteralNameAttribute literalNameAttribute = this.getEnumType().getEnumLiteralNameAttribute();
        return literalNameAttribute == null ? false : literalNameAttribute.getDefaultValueProviderAttribute().equals(this.name);
    }

    private void validateDuplicateIndicator(MessageList list, IndicationProvider indicationProvider) {
        List<IEnumAttribute> enumAttributes = this.getEnumType().getEnumAttributesIncludeSupertypeCopies(false);
        if (indicationProvider.uiValue()) {
            int numberOfIndicatedAttributes = 0;
            for (IEnumAttribute currentEnumAttribute : enumAttributes) {
                if (indicationProvider.modelValue(currentEnumAttribute)) {
                    ++numberOfIndicatedAttributes;
                }
                if (numberOfIndicatedAttributes <= 1) continue;
                list.add(indicationProvider.message());
                break;
            }
        }
    }

    @Override
    public boolean isEnumLiteralNameAttribute() {
        return this instanceof IEnumLiteralNameAttribute;
    }

    private class DisplayNameIndicationProvider
    implements IndicationProvider {
        private DisplayNameIndicationProvider() {
        }

        @Override
        public Message message() {
            String text = Messages.EnumAttribute_DuplicateUsedAsNameInFaktorIpsUi;
            return new Message("ENUMATTRIBUTE-EnumAttributeDuplicateUsedAsNameInFaktorIpsUi", text, Message.ERROR, (Object)EnumAttribute.this, new String[]{"usedAsNameInFaktorIpsUi"});
        }

        @Override
        public boolean modelValue(IEnumAttribute enumAttribute) {
            return enumAttribute.isUsedAsNameInFaktorIpsUi();
        }

        @Override
        public boolean uiValue() {
            return EnumAttribute.this.usedAsNameInFaktorIpsUi;
        }

        @Override
        public String getPropertyName() {
            return "usedAsNameInFaktorIpsUi";
        }

        @Override
        public String getPropertyDisplayName() {
            return Messages.EnumAttribute_PropertyDisplayNameDisplayName;
        }
    }

    private class IdentifierIndicationProvider
    implements IndicationProvider {
        private IdentifierIndicationProvider() {
        }

        @Override
        public Message message() {
            String text = Messages.EnumAttribute_DuplicateUsedAsIdInFaktorIpsUi;
            return new Message("ENUMATTRIBUTE-EnumAttributeDuplicateUsedAsIdInFaktorIpsUi", text, Message.ERROR, (Object)EnumAttribute.this, new String[]{"identifier"});
        }

        @Override
        public boolean modelValue(IEnumAttribute enumAttribute) {
            return enumAttribute.isIdentifier();
        }

        @Override
        public boolean uiValue() {
            return EnumAttribute.this.identifier;
        }

        @Override
        public String getPropertyName() {
            return "identifier";
        }

        @Override
        public String getPropertyDisplayName() {
            return Messages.EnumAttribute_PropertyDisplayName_Identifier;
        }
    }

    private static interface IndicationProvider {
        public boolean uiValue();

        public boolean modelValue(IEnumAttribute var1);

        public Message message();

        public String getPropertyName();

        public String getPropertyDisplayName();
    }
}

