/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.enums;

import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.enums.IEnumAttribute;
import org.faktorips.devtools.model.enums.IEnumAttributeValue;
import org.faktorips.devtools.model.enums.IEnumLiteralNameAttributeValue;
import org.faktorips.devtools.model.enums.IEnumType;
import org.faktorips.devtools.model.enums.IEnumValueContainer;
import org.faktorips.devtools.model.internal.enums.EnumType;
import org.faktorips.devtools.model.internal.enums.EnumValue;
import org.faktorips.devtools.model.internal.enums.EnumValueContainer;
import org.faktorips.devtools.model.internal.enums.Messages;
import org.faktorips.devtools.model.internal.ipsobject.AtomicIpsObjectPart;
import org.faktorips.devtools.model.internal.value.InternationalStringValue;
import org.faktorips.devtools.model.internal.value.StringValue;
import org.faktorips.devtools.model.internal.value.ValueUtil;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.value.IValue;
import org.faktorips.devtools.model.value.ValueFactory;
import org.faktorips.devtools.model.value.ValueType;
import org.faktorips.devtools.model.value.ValueTypeMismatch;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.internal.InternationalStringXmlReaderWriter;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.ArgumentCheck;
import org.faktorips.values.LocalizedString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EnumAttributeValue
extends AtomicIpsObjectPart
implements IEnumAttributeValue {
    private static final String IS_NULL = "isNull";
    private IValue<?> value;
    private final PropertyChangeListener propertyChangeListener = evt -> {
        boolean bl = this.valueChanged(null, evt.getNewValue());
    };

    public EnumAttributeValue(EnumValue parent, String id) {
        super(parent, id);
        this.setValueInternal(ValueFactory.createStringValue(null));
    }

    @Override
    public String getCaption(Locale locale) {
        IEnumAttribute foundEnumAttribute = this.findEnumAttribute(this.getIpsProject());
        if (foundEnumAttribute != null) {
            return foundEnumAttribute.getLabelValue(locale);
        }
        return super.getCaption(locale);
    }

    @Override
    public String getLastResortCaption() {
        IEnumAttribute foundEnumAttribute = this.findEnumAttribute(this.getIpsProject());
        if (foundEnumAttribute != null) {
            return StringUtils.capitalize((String)foundEnumAttribute.getName());
        }
        return super.getLastResortCaption();
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement("EnumAttributeValue");
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute(IS_NULL, Boolean.toString(this.isNullValue()));
        element.removeAttribute("id");
        if (this.getValue() != null) {
            Node valueNode = this.getValue().toXml(element.getOwnerDocument());
            element.appendChild(valueNode);
            if (this.getValueType() == ValueType.INTERNATIONAL_STRING) {
                Locale defaultLocale = this.getIpsProject().getReadOnlyProperties().getDefaultLanguage().getLocale();
                InternationalStringXmlReaderWriter.setDefaultLocaleInXml((Node)valueNode, (Locale)defaultLocale);
            }
        }
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.setValueInternal(ValueFactory.createValue(element));
    }

    @Override
    public IEnumAttribute findEnumAttribute(IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object)ipsProject);
        EnumValue enumValue = this.getEnumValue();
        IEnumValueContainer valueContainer = enumValue.getEnumValueContainer();
        IEnumType enumType = valueContainer.findEnumType(ipsProject);
        if (enumType == null) {
            return null;
        }
        return this.getEnumAttribute(enumType);
    }

    private IEnumAttribute getEnumAttribute(IEnumType enumType) {
        EnumValue enumValue = this.getEnumValue();
        int attributeValueIndex = enumValue.getIndexOfEnumAttributeValue(this);
        boolean includeLiteralName = this.getEnumValue().isEnumTypeValue();
        int enumAttributesCount = enumType.getEnumAttributesCountIncludeSupertypeCopies(includeLiteralName);
        if (enumAttributesCount != enumValue.getEnumAttributeValuesCount() || attributeValueIndex == -1 || enumAttributesCount < attributeValueIndex + 1) {
            return null;
        }
        List<IEnumAttribute> enumAttributes = enumType.getEnumAttributesIncludeSupertypeCopies(includeLiteralName);
        return enumAttributes.get(attributeValueIndex);
    }

    @Override
    public boolean isEnumLiteralNameAttributeValue() {
        return this instanceof IEnumLiteralNameAttributeValue;
    }

    private void setValueInternal(IValue<?> value) {
        if (this.value != null) {
            this.value.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.value = value;
        if (this.value != null) {
            this.value.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    @Override
    public String getStringValue() {
        if (this.getValue() != null) {
            return this.getValue().getContentAsString();
        }
        return null;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.getValueType(this.getValue());
    }

    @Override
    public IValue<?> getValue() {
        return this.value;
    }

    @Override
    public void setValue(IValue<?> newValue) {
        IValue<?> oldValue = this.getValue();
        this.setValueInternal(newValue);
        this.valueChanged(oldValue, newValue);
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        IEnumAttribute enumAttribute = this.findEnumAttribute(ipsProject);
        if (enumAttribute == null) {
            return;
        }
        IEnumType enumType = enumAttribute.getEnumType();
        if (this.getEnumValue().isEnumTypeValue() && enumType.isAbstract()) {
            return;
        }
        this.validateMultilingual(list, enumAttribute);
        ValueDatatype datatype = enumAttribute.findDatatype(ipsProject);
        if (this.getValue() != null) {
            datatype = this.getEnumValue().isEnumTypeValue() ? enumAttribute.findDatatypeIgnoreEnumContents(ipsProject) : enumAttribute.findDatatype(ipsProject);
            this.getValue().validate(datatype, enumAttribute.getDatatype(), this.getParent().getIpsProject(), list, new ObjectProperty((Object)this, "value"));
            if (this.isUniqueIdentifierEnumAttributeValue(enumAttribute)) {
                this.validateUniqueIdentifierEnumAttributeValue(list);
            }
        }
        IdentifierBoundaryValidator validator = new IdentifierBoundaryValidator(this, enumType, datatype, ipsProject);
        list.add(validator.validateIfPossible());
    }

    private void validateMultilingual(MessageList list, IEnumAttribute enumAttribute) {
        String defaultProjectLanguage = this.getIpsProject().getReadOnlyProperties().getDefaultLanguage().getLocale().getLanguage();
        ValueTypeMismatch typeMismatch = this.checkValueTypeMismatch(enumAttribute);
        if (ValueTypeMismatch.STRING_TO_INTERNATIONAL_STRING.equals((Object)typeMismatch)) {
            list.add(new Message("ENUMATTRIBUTEVALUE-InvalidValueType", MessageFormat.format(Messages.EnumAttributeValue_MultiLingual, enumAttribute.getName(), defaultProjectLanguage), Message.ERROR, new ObjectProperty((Object)this, "value")));
        } else if (ValueTypeMismatch.INTERNATIONAL_STRING_TO_STRING.equals((Object)typeMismatch)) {
            list.add(new Message("ENUMATTRIBUTEVALUE-InvalidValueType", MessageFormat.format(Messages.EnumAttributeValue_NotMultiLingual, enumAttribute.getName(), defaultProjectLanguage), Message.ERROR, new ObjectProperty((Object)this, "value")));
        }
    }

    @Override
    public ValueTypeMismatch checkValueTypeMismatch(IEnumAttribute enumAttribute) {
        return ValueTypeMismatch.getMismatch(this.getValue(), enumAttribute.isMultilingual());
    }

    @Override
    public void fixValueType(boolean multilingual) {
        ValueTypeMismatch typeMismatch = ValueTypeMismatch.getMismatch(this.getValue(), multilingual);
        if (ValueTypeMismatch.STRING_TO_INTERNATIONAL_STRING.equals((Object)typeMismatch)) {
            this.convertStringToInternationalString();
        } else if (ValueTypeMismatch.INTERNATIONAL_STRING_TO_STRING.equals((Object)typeMismatch)) {
            this.convertInternationalStringToString();
        }
    }

    private void convertStringToInternationalString() {
        InternationalStringValue internationalStringValue = new InternationalStringValue();
        String stringValue = this.getStringValue() != null ? this.getStringValue() : "";
        internationalStringValue.getContent().add(new LocalizedString(this.getIpsProject().getReadOnlyProperties().getDefaultLanguage().getLocale(), stringValue));
        this.setValueInternal(internationalStringValue);
    }

    private void convertInternationalStringToString() {
        String content = this.getValue().getDefaultLocalizedContent(this.getIpsProject());
        this.setValueInternal(new StringValue(content));
    }

    private void validateUniqueIdentifierEnumAttributeValue(MessageList list) {
        IValue<?> uniqueIdentifierValue = this.getValue();
        ValueUtil valueUtil = ValueUtil.createUtil(uniqueIdentifierValue);
        boolean uniqueIdentifierValueMissing = valueUtil.isPartlyEmpty(this.getIpsProject());
        if (uniqueIdentifierValueMissing) {
            String text = Messages.EnumAttributeValue_UniqueIdentifierValueEmpty;
            Message validationMessage = new Message("ENUMATTRIBUTEVALUE-EnumAttributeValueUniqueIdentifierValueEmpty", text, Message.ERROR, (Object)this, new String[]{"value"});
            list.add(validationMessage);
            return;
        }
        EnumValueContainer enumValueContainerImpl = (EnumValueContainer)this.getEnumValue().getEnumValueContainer();
        List<String> uniqueIdentifierViolations = enumValueContainerImpl.getUniqueIdentifierViolations(this);
        for (String invalidString : uniqueIdentifierViolations) {
            String text = MessageFormat.format(Messages.EnumAttributeValue_UniqueIdentifierValueNotUnique, invalidString);
            Message validationMessage = new Message("ENUMATTRIBUTEVALUE-EnumAttributeValueIdentifierNotUnique", text, Message.ERROR, (Object)this, new String[]{"value"});
            list.add(validationMessage);
        }
    }

    private boolean isUniqueIdentifierEnumAttributeValue(IEnumAttribute enumAttribute) {
        return enumAttribute.findIsUnique(this.getIpsProject());
    }

    @Override
    public EnumValue getEnumValue() {
        return (EnumValue)this.getParent();
    }

    @Override
    public boolean isNullValue() {
        boolean isNull = true;
        if (this.getValue() != null) {
            isNull = this.getValue().getContent() == null;
        }
        return isNull;
    }

    public static class IdentifierBoundaryValidator {
        private final IEnumAttributeValue attributeValue;
        private final IIpsProject ipsProject;
        private final IEnumType enumType;
        private final ValueDatatype datatype;

        public IdentifierBoundaryValidator(IEnumAttributeValue attributeValue, IEnumType enumType, ValueDatatype datatype, IIpsProject ipsProject) {
            this.attributeValue = attributeValue;
            this.enumType = enumType;
            this.datatype = datatype;
            Assert.isNotNull((Object)ipsProject);
            this.ipsProject = ipsProject;
        }

        public MessageList validateIfPossible() {
            MessageList messageList = new MessageList();
            if (this.canValidate()) {
                this.validateAndAppendMessages(messageList);
            }
            return messageList;
        }

        public boolean canValidate() {
            return this.isValidateNecessary() && this.isIdentifierValue() && this.isIDValueParsable() && this.isBoundaryValueParsable();
        }

        private boolean isValidateNecessary() {
            if (this.enumType != null) {
                return ((EnumType)this.getEnumType()).isValidateIdentifierBoundaryOnDatatypeNecessary(this.enumType.getIdentifierBoundary());
            }
            return false;
        }

        private boolean isIdentifierValue() {
            return this.getAttributeValue() != null && this.getEnumType() != null && this.getAttributeValue().findEnumAttribute(this.getIpsProject()) == this.getIdentifierAttribute();
        }

        private boolean isIDValueParsable() {
            return this.hasDatatype() && this.getDatatype().isParsable(this.getIdAsString());
        }

        private boolean hasDatatype() {
            return this.getDatatype() != null;
        }

        private boolean isBoundaryValueParsable() {
            return this.isBoundaryValueDefined() && this.getDatatype().isParsable(this.getIdentifierBoundary());
        }

        private boolean isBoundaryValueDefined() {
            if (this.getEnumType() == null) {
                return false;
            }
            return !IpsStringUtils.isEmpty((String)this.getIdentifierBoundary());
        }

        protected void validateAndAppendMessages(MessageList messageList) {
            if (!this.isIdentitifierValid()) {
                String message = MessageFormat.format(this.getRawMessageForTypeOrContent(), this.getIdAsString(), this.getIdentifierBoundary());
                messageList.add(new Message("ENUMATTRIBUTEVALUE-IdDisallowedByEnumTypesIdentifierBoundary", message, Message.ERROR, new ObjectProperty((Object)this.getAttributeValue(), "value")));
            }
        }

        private String getRawMessageForTypeOrContent() {
            if (this.isValueOfEnumType()) {
                return Messages.EnumAttributeValue_Msg_IdNotAllowedByIdentifierBoundary_valueOfEnumType;
            }
            return Messages.EnumAttributeValue_Msg_IdNotAllowedByIdentifierBoundary_valueOfEnumContent;
        }

        private boolean isValueOfEnumType() {
            return this.isIdNameSpaceLessThanBoundary();
        }

        protected boolean isIdentitifierValid() {
            String candidateID = this.getIdAsString();
            String identifierBoundary = this.getIdentifierBoundary();
            int resultOfCompare = this.getDatatype().compare(candidateID, identifierBoundary);
            return this.allowsIdentifier(resultOfCompare);
        }

        private String getIdAsString() {
            return this.getAttributeValue().getStringValue();
        }

        private String getIdentifierBoundary() {
            return this.getEnumType().getIdentifierBoundary();
        }

        private boolean allowsIdentifier(int resultOfCompare) {
            return resultOfCompare < 0 == this.isValueOfEnumType();
        }

        private boolean isIdNameSpaceLessThanBoundary() {
            return this.getAttributeValue().getEnumValue().getEnumValueContainer().isIdentifierNamespaceBelowBoundary();
        }

        private IEnumAttribute getIdentifierAttribute() {
            return this.getEnumType().findIdentiferAttribute(this.getIpsProject());
        }

        private IEnumAttributeValue getAttributeValue() {
            return this.attributeValue;
        }

        private IIpsProject getIpsProject() {
            return this.ipsProject;
        }

        private IEnumType getEnumType() {
            return this.enumType;
        }

        private ValueDatatype getDatatype() {
            return this.datatype;
        }
    }
}

