/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.enums;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.faktorips.devtools.model.IPartReference;
import org.faktorips.devtools.model.dependency.IDependency;
import org.faktorips.devtools.model.dependency.IDependencyDetail;
import org.faktorips.devtools.model.enums.IEnumAttribute;
import org.faktorips.devtools.model.enums.IEnumContent;
import org.faktorips.devtools.model.enums.IEnumType;
import org.faktorips.devtools.model.enums.IEnumValue;
import org.faktorips.devtools.model.internal.dependency.IpsObjectDependency;
import org.faktorips.devtools.model.internal.enums.EnumAttributeReference;
import org.faktorips.devtools.model.internal.enums.EnumContentValidations;
import org.faktorips.devtools.model.internal.enums.EnumValueContainer;
import org.faktorips.devtools.model.internal.enums.Messages;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectPartCollection;
import org.faktorips.devtools.model.ipsobject.IFixDifferencesComposite;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Element;

public class EnumContent
extends EnumValueContainer
implements IEnumContent {
    private static final List<String> FIX_REQUIRING_ERROR_CODES = Arrays.asList("ENUMCONTENT-EnumContentEnumTypeDoesNotExist", "ENUMCONTENT-EnumContentEnumTypeIsAbstract", "ENUMCONTENT-EnumContentEnumTypeMissing", "ENUMCONTENT-EnumContentValuesArePartOfType", "ENUMCONTENT-EnumContentReferencedEnumAttributeNamesInvalid", "ENUMCONTENT-EnumContentReferencedEnumAttributeOrderingInvalid", "ENUMCONTENT-EnumContentReferencedEnumAttributesCountInvalid", "ENUMATTRIBUTEVALUE-InvalidValueType");
    private String enumType = "";
    private IpsObjectPartCollection<IPartReference> enumAttributeReferences = new IpsObjectPartCollection<IPartReference>(this, EnumAttributeReference.class, IPartReference.class, "EnumAttributeReference");

    public EnumContent(IIpsSrcFile file) {
        super(file);
    }

    @Override
    public IpsObjectType getIpsObjectType() {
        return IpsObjectType.ENUM_CONTENT;
    }

    @Override
    public IEnumType findEnumType(IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object)ipsProject);
        IIpsSrcFile ipsSrcFile = ipsProject.findIpsSrcFile(IpsObjectType.ENUM_TYPE, this.enumType);
        if (ipsSrcFile != null && ipsSrcFile.exists()) {
            return (IEnumType)ipsSrcFile.getIpsObject();
        }
        return null;
    }

    @Override
    public void setEnumType(String enumType) {
        ArgumentCheck.notNull((Object)enumType);
        String oldEnumType = this.enumType;
        this.enumType = enumType;
        this.valueChanged(oldEnumType, enumType);
        this.refreshEnumAttributeReferences();
    }

    @Override
    public List<IEnumValue> findAggregatedEnumValues() {
        List aggrregatedEnumValues = this.findEnumType(this.getIpsProject()).getEnumValues();
        aggrregatedEnumValues.addAll(this.getEnumValues());
        return aggrregatedEnumValues;
    }

    private void refreshEnumAttributeReferences() {
        IEnumType newEnumType = this.findEnumType(this.getIpsProject());
        if (newEnumType != null) {
            this.enumAttributeReferences.clear();
            List<IEnumAttribute> enumAttributes = newEnumType.getEnumAttributesIncludeSupertypeCopies(false);
            for (IEnumAttribute currentEnumAttribute : enumAttributes) {
                IPartReference reference = this.enumAttributeReferences.newPart();
                reference.setName(currentEnumAttribute.getName());
            }
        }
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        this.enumType = element.getAttribute("enumType");
        super.initPropertiesFromXml(element, id);
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("enumType", this.enumType);
    }

    @Override
    public String getEnumType() {
        return this.enumType;
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        EnumContentValidations.validateEnumType(list, this, this.enumType, ipsProject);
        if (list.containsErrorMsg()) {
            return;
        }
        IEnumType referencedEnumType = this.findEnumType(ipsProject);
        EnumContentValidations.validateEnumContentName(list, this, referencedEnumType, this.getQualifiedName());
        this.validateEnumAttributeReferences(list, referencedEnumType);
    }

    private void validateEnumAttributeReferences(MessageList validationMessageList, IEnumType enumType) {
        this.validateEnumAttributeReferencesCount(validationMessageList, enumType);
        if (validationMessageList.containsErrorMsg()) {
            return;
        }
        List<IEnumAttribute> enumAttributes = enumType.getEnumAttributesIncludeSupertypeCopies(false);
        this.validateEnumAttributeReferenceNames(validationMessageList, enumType, enumAttributes);
        if (validationMessageList.containsErrorMsg()) {
            return;
        }
        this.validateEnumAttributeReferenceOrdering(validationMessageList, enumType, enumAttributes);
    }

    private void validateEnumAttributeReferenceOrdering(MessageList validationMessageList, IEnumType enumType, List<IEnumAttribute> enumAttributes) {
        int i = 0;
        while (i < enumAttributes.size()) {
            String currentReference;
            String currentEnumAttributeName = enumAttributes.get(i).getName();
            if (!currentEnumAttributeName.equals(currentReference = this.enumAttributeReferences.getPart(i).getName())) {
                String text = MessageFormat.format(Messages.EnumContent_ReferencedEnumAttributesOrderingInvalid, enumType.getQualifiedName());
                Message validationMessage = new Message("ENUMCONTENT-EnumContentReferencedEnumAttributeOrderingInvalid", text, Message.ERROR, (Object)this);
                validationMessageList.add(validationMessage);
                break;
            }
            ++i;
        }
    }

    private void validateEnumAttributeReferenceNames(MessageList validationMessageList, IEnumType enumType, List<IEnumAttribute> enumAttributes) {
        for (IEnumAttribute currentEnumAttribute : enumAttributes) {
            if (this.containsEnumAttributeReference(currentEnumAttribute.getName())) continue;
            String text = MessageFormat.format(Messages.EnumContent_ReferencedEnumAttributeNamesInvalid, enumType.getQualifiedName());
            Message validationMessage = new Message("ENUMCONTENT-EnumContentReferencedEnumAttributeNamesInvalid", text, Message.ERROR, (Object)this);
            validationMessageList.add(validationMessage);
        }
    }

    private void validateEnumAttributeReferencesCount(MessageList validationMessageList, IEnumType enumType) {
        if (enumType.getEnumAttributesCountIncludeSupertypeCopies(false) != this.getEnumAttributeReferencesCount()) {
            String text = MessageFormat.format(Messages.EnumContent_ReferencedEnumAttributesCountInvalid, enumType.getQualifiedName());
            Message validationMessage = new Message("ENUMCONTENT-EnumContentReferencedEnumAttributesCountInvalid", text, Message.ERROR, (Object)this);
            validationMessageList.add(validationMessage);
        }
    }

    private boolean containsEnumAttributeReference(String name) {
        for (IPartReference currentReference : this.enumAttributeReferences) {
            if (!currentReference.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected IDependency[] dependsOn(Map<IDependency, List<IDependencyDetail>> details) {
        IpsObjectDependency enumTypeDependency = IpsObjectDependency.createInstanceOfDependency(this.getQualifiedNameType(), new QualifiedNameType(this.getEnumType(), IpsObjectType.ENUM_TYPE));
        this.addDetails(details, enumTypeDependency, this, "enumType");
        return new IDependency[]{enumTypeDependency};
    }

    @Override
    public List<IPartReference> getEnumAttributeReferences() {
        IIpsObjectPart[] parts;
        ArrayList<IPartReference> referencesList = new ArrayList<IPartReference>();
        IIpsObjectPart[] iIpsObjectPartArray = parts = this.enumAttributeReferences.getParts();
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsObjectPart part = iIpsObjectPartArray[n2];
            referencesList.add((IPartReference)part);
            ++n2;
        }
        return referencesList;
    }

    @Override
    public IPartReference getEnumAttributeReference(String name) {
        ArgumentCheck.notNull((Object)name);
        for (IPartReference reference : this.getEnumAttributeReferences()) {
            if (!reference.getName().equals(name)) continue;
            return reference;
        }
        return null;
    }

    @Override
    public int getEnumAttributeReferencesCount() {
        return this.enumAttributeReferences.size();
    }

    @Override
    public IIpsSrcFile findMetaClassSrcFile(IIpsProject ipsProject) {
        return ipsProject.findIpsSrcFile(IpsObjectType.ENUM_TYPE, this.getEnumType());
    }

    @Override
    public boolean containsDifferenceToModel(IIpsProject ipsProject) {
        return false;
    }

    @Override
    public void fixAllDifferencesToModel(IIpsProject ipsProject) {
    }

    @Override
    public IFixDifferencesComposite computeDeltaToModel(IIpsProject ipsProject) {
        return null;
    }

    @Override
    public String getMetaClass() {
        return this.getEnumType();
    }

    @Override
    public boolean isCapableOfContainingValues() {
        return this.findEnumType(this.getIpsProject()) == null ? false : !this.isFixToModelRequired();
    }

    @Override
    public boolean isFixToModelRequired() {
        MessageList messages = this.validate(this.getIpsProject());
        for (Message message : messages) {
            if (!FIX_REQUIRING_ERROR_CODES.contains(message.getCode())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isIdentifierNamespaceBelowBoundary() {
        return false;
    }
}

