/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.enums;

import java.text.MessageFormat;
import org.faktorips.devtools.model.enums.IEnumContent;
import org.faktorips.devtools.model.enums.IEnumType;
import org.faktorips.devtools.model.enums.Messages;
import org.faktorips.devtools.model.internal.ipsobject.DeprecationValidation;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.util.ArgumentCheck;

public abstract class EnumContentValidations {
    private EnumContentValidations() {
    }

    public static void validateEnumContentName(MessageList validationMessageList, IEnumContent enumContent, IEnumType enumType, String enumContentName) {
        ArgumentCheck.notNull((Object[])new Object[]{validationMessageList, enumType, enumContentName});
        String enumTypeEnumContentName = enumType.getEnumContentName();
        if (!enumContentName.equals(enumTypeEnumContentName)) {
            String text = MessageFormat.format(Messages.EnumContent_EnumContentNameNotCorrect, enumType.getQualifiedName());
            Message message = enumContent == null ? new Message("ENUMCONTENT-EnumContentNameNotCorrect", text, Message.ERROR) : new Message("ENUMCONTENT-EnumContentNameNotCorrect", text, Message.ERROR, (Object)enumContent);
            validationMessageList.add(message);
        }
    }

    public static void validateEnumType(MessageList validationMessageList, IEnumContent enumContent, String enumTypeQualifiedName, IIpsProject ipsProject) {
        String text;
        ObjectProperty[] objectProperties;
        ArgumentCheck.notNull((Object[])new Object[]{validationMessageList, enumTypeQualifiedName, ipsProject});
        if (enumContent != null) {
            ObjectProperty[] objectPropertyArray = new ObjectProperty[1];
            v1 = objectPropertyArray;
            objectPropertyArray[0] = new ObjectProperty((Object)enumContent, "enumType");
        } else {
            v1 = objectProperties = new ObjectProperty[]{};
        }
        if (enumTypeQualifiedName.length() == 0) {
            String text2 = Messages.EnumContent_EnumTypeMissing;
            validationMessageList.add(new Message("ENUMCONTENT-EnumContentEnumTypeMissing", text2, Message.ERROR, objectProperties));
            return;
        }
        IIpsSrcFile enumSrcFile = ipsProject.findIpsSrcFile(IpsObjectType.ENUM_TYPE, enumTypeQualifiedName);
        if (enumSrcFile == null) {
            String text3 = MessageFormat.format(Messages.EnumContent_EnumTypeDoesNotExist, enumTypeQualifiedName);
            validationMessageList.add(new Message("ENUMCONTENT-EnumContentEnumTypeDoesNotExist", text3, Message.ERROR, objectProperties));
            return;
        }
        IEnumType enumTypeRef = (IEnumType)enumSrcFile.getIpsObject();
        if (enumTypeRef.isInextensibleEnum()) {
            text = MessageFormat.format(Messages.EnumContent_ValuesArePartOfType, enumTypeQualifiedName);
            validationMessageList.add(new Message("ENUMCONTENT-EnumContentValuesArePartOfType", text, Message.ERROR, objectProperties));
        }
        if (enumTypeRef.isAbstract()) {
            text = MessageFormat.format(Messages.EnumContent_EnumTypeIsAbstract, enumTypeQualifiedName);
            validationMessageList.add(new Message("ENUMCONTENT-EnumContentEnumTypeIsAbstract", text, Message.ERROR, objectProperties));
        }
        DeprecationValidation.validateEnumTypeIsNotDeprecated(enumContent, enumTypeRef, ipsProject, validationMessageList);
    }
}

