/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.enums;

import java.text.MessageFormat;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.enums.IEnumAttribute;
import org.faktorips.devtools.model.enums.IEnumLiteralNameAttribute;
import org.faktorips.devtools.model.enums.IEnumType;
import org.faktorips.devtools.model.internal.enums.EnumAttribute;
import org.faktorips.devtools.model.internal.enums.Messages;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EnumLiteralNameAttribute
extends EnumAttribute
implements IEnumLiteralNameAttribute {
    private String defaultValueProviderAttribute = "";

    public EnumLiteralNameAttribute(IEnumType parent, String id) {
        super(parent, id);
    }

    @Override
    public void setDefaultValueProviderAttribute(String defaultValueProviderAttributeName) {
        ArgumentCheck.notNull((Object)defaultValueProviderAttributeName);
        String oldValue = this.defaultValueProviderAttribute;
        this.defaultValueProviderAttribute = defaultValueProviderAttributeName;
        this.valueChanged(oldValue, defaultValueProviderAttributeName);
    }

    @Override
    public String getDefaultValueProviderAttribute() {
        return this.defaultValueProviderAttribute;
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        this.defaultValueProviderAttribute = element.getAttribute("defaultValueProviderAttribute");
        super.initPropertiesFromXml(element, id);
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        if (IpsStringUtils.isNotBlank((String)this.defaultValueProviderAttribute)) {
            element.setAttribute("defaultValueProviderAttribute", this.defaultValueProviderAttribute);
        }
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        this.validateIsNeeded(list);
        if (list.containsErrorMsg()) {
            return;
        }
        this.validateDefaultValueProviderAttribute(list);
    }

    private void validateIsNeeded(MessageList list) {
        IEnumType enumType = this.getEnumType();
        if (enumType.isAbstract()) {
            String text = Messages.EnumLiteralNameAttribute_NotNeeded;
            Message msg = new Message("ENUMLITERALNAMEATTRIBUTE-EnumLiteralNameAttributeAttributeNotNeeded", text, Message.ERROR, (Object)this);
            list.add(msg);
        }
    }

    private void validateDefaultValueProviderAttribute(MessageList list) {
        if (IpsStringUtils.isEmpty((String)this.defaultValueProviderAttribute)) {
            return;
        }
        this.validateValueProviderAttributeExists(list);
        this.validateValueProviderAttributeHasStringDatatype(list);
    }

    private void validateValueProviderAttributeExists(MessageList list) {
        IEnumType enumType = this.getEnumType();
        if (this.isValueProviderAttributeMissing(enumType)) {
            String text = MessageFormat.format(Messages.EnumLiteralNameAttribute_DefaultValueProviderAttributeDoesNotExist, this.defaultValueProviderAttribute);
            Message msg = new Message("ENUMLITERALNAMEATTRIBUTE-EnumLiteralNameAttributeDefaultValueProviderAttributeDoesNotExist", text, Message.ERROR, (Object)this, new String[]{"defaultValueProviderAttribute"});
            list.add(msg);
        }
    }

    private boolean isValueProviderAttributeMissing(IEnumType enumType) {
        return !enumType.containsEnumAttributeIncludeSupertypeCopies(this.defaultValueProviderAttribute);
    }

    private void validateValueProviderAttributeHasStringDatatype(MessageList list) {
        IEnumType enumType = this.getEnumType();
        if (this.isValueProviderAttributeMissing(enumType)) {
            return;
        }
        IEnumAttribute providerAttribute = enumType.getEnumAttributeIncludeSupertypeCopies(this.defaultValueProviderAttribute);
        ValueDatatype datatype = providerAttribute.findDatatype(this.getIpsProject());
        if (datatype != null && !datatype.equals(Datatype.STRING)) {
            String text = MessageFormat.format(Messages.EnumLiteralNameAttribute_DefaultValueProviderAttributeNotOfDatatypeString, this.defaultValueProviderAttribute);
            Message msg = new Message("ENUMLITERALNAMEATTRIBUTE-EnumLiteralNameAttributeDefaultValueProviderAttributeNotOfDatatypeString", text, Message.ERROR, (Object)this, new String[]{"defaultValueProviderAttribute"});
            list.add(msg);
        }
    }

    @Override
    public void setIdentifier(boolean usedAsIdInFaktorIpsUi) {
        throw new UnsupportedOperationException("The identifier property is not used by EnumLiteralNameAttributes.");
    }

    @Override
    public void setInherited(boolean isInherited) {
        throw new UnsupportedOperationException("The inherited property is not used by EnumLiteralNameAttributes.");
    }

    @Override
    public void setUsedAsNameInFaktorIpsUi(boolean usedAsNameInFaktorIpsUi) {
        throw new UnsupportedOperationException("The usedAsName property is not used by EnumLiteralNameAttributes.");
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement("EnumLiteralNameAttribute");
    }
}

