/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.enums;

import java.text.MessageFormat;
import org.faktorips.devtools.model.enums.IEnumLiteralNameAttributeValue;
import org.faktorips.devtools.model.internal.enums.EnumAttributeValue;
import org.faktorips.devtools.model.internal.enums.EnumValue;
import org.faktorips.devtools.model.internal.enums.Messages;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EnumLiteralNameAttributeValue
extends EnumAttributeValue
implements IEnumLiteralNameAttributeValue {
    private static final String UNDERLINE = "_";

    public EnumLiteralNameAttributeValue(EnumValue parent, String id) {
        super(parent, id);
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        if (this.isNullValue()) {
            return;
        }
        char[] characters = this.getValue().getContentAsString().toCharArray();
        int i = 0;
        while (i < characters.length) {
            boolean validCharacter;
            boolean bl = validCharacter = i == 0 ? Character.isJavaIdentifierStart(characters[i]) : Character.isJavaIdentifierPart(characters[i]);
            if (!validCharacter) {
                this.createErrorMessage(list);
                break;
            }
            ++i;
        }
        if (UNDERLINE.equals(this.getValue().getContentAsString())) {
            this.createErrorMessage(list);
        }
    }

    private void createErrorMessage(MessageList list) {
        String text = MessageFormat.format(Messages.EnumLiteralNameAttributeValue_ValueIsNotAValidJavaIdentifier, this.getValue());
        Message msg = new Message("ENUMLITERALNAMEATTRIBUTEVALUE-EnumLiteralNameAttributeValueIsNoValidJavaIdentifier", text, Message.ERROR, (Object)this, new String[]{"value"});
        list.add(msg);
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement("EnumLiteralNameAttributeValue");
    }

    @Override
    public String getName() {
        return this.getStringValue();
    }
}

