/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.enums;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.dependency.IDependency;
import org.faktorips.devtools.model.dependency.IDependencyDetail;
import org.faktorips.devtools.model.enums.EnumTypeHierarchyVisitor;
import org.faktorips.devtools.model.enums.IEnumAttribute;
import org.faktorips.devtools.model.enums.IEnumContent;
import org.faktorips.devtools.model.enums.IEnumLiteralNameAttribute;
import org.faktorips.devtools.model.enums.IEnumType;
import org.faktorips.devtools.model.enums.IEnumValue;
import org.faktorips.devtools.model.internal.IpsModel;
import org.faktorips.devtools.model.internal.SingleEventModification;
import org.faktorips.devtools.model.internal.ValidationUtils;
import org.faktorips.devtools.model.internal.dependency.DatatypeDependency;
import org.faktorips.devtools.model.internal.dependency.IpsObjectDependency;
import org.faktorips.devtools.model.internal.enums.EnumAttribute;
import org.faktorips.devtools.model.internal.enums.EnumLiteralNameAttribute;
import org.faktorips.devtools.model.internal.enums.EnumTypeValidations;
import org.faktorips.devtools.model.internal.enums.EnumValueContainer;
import org.faktorips.devtools.model.internal.enums.Messages;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectPartCollection;
import org.faktorips.devtools.model.internal.util.TreeSetHelper;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Element;

public class EnumType
extends EnumValueContainer
implements IEnumType {
    private String superEnumType = "";
    private boolean extensible = false;
    private String identifierBoundary;
    private String enumContentPackageFragment = "";
    private IpsObjectPartCollection<IEnumAttribute> enumAttributes = new IpsObjectPartCollection<IEnumAttribute>(this, EnumAttribute.class, IEnumAttribute.class, "EnumAttribute");
    private boolean isAbstract = false;

    public EnumType(IIpsSrcFile file) {
        super(file);
    }

    @Override
    public IpsObjectType getIpsObjectType() {
        return IpsObjectType.ENUM_TYPE;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public void setAbstract(boolean isAbstract) {
        boolean oldIsAbstract = this.isAbstract;
        this.isAbstract = isAbstract;
        if (isAbstract) {
            this.removePartThis(this.getEnumLiteralNameAttribute());
        }
        this.valueChanged(oldIsAbstract, isAbstract);
    }

    @Override
    public boolean containsValues() {
        return !this.getEnumValues().isEmpty();
    }

    @Override
    public boolean isExtensible() {
        return this.extensible;
    }

    @Override
    public void setExtensible(boolean extensible) {
        boolean oldExtensible = this.extensible;
        this.extensible = extensible;
        this.valueChanged(oldExtensible, extensible);
    }

    @Override
    public String getIdentifierBoundary() {
        return this.identifierBoundary;
    }

    @Override
    public void setIdentifierBoundary(String identifierBoundary) {
        String oldIdentifierBoundary = this.identifierBoundary;
        this.identifierBoundary = identifierBoundary;
        this.valueChanged(oldIdentifierBoundary, identifierBoundary);
    }

    @Override
    public String getSuperEnumType() {
        return this.superEnumType;
    }

    @Override
    public void setSuperEnumType(String superEnumTypeQualifiedName) {
        ArgumentCheck.notNull((Object)superEnumTypeQualifiedName);
        String oldSupertype = this.superEnumType;
        this.superEnumType = superEnumTypeQualifiedName;
        this.valueChanged(oldSupertype, this.superEnumType);
    }

    @Override
    public boolean isSubEnumTypeOf(IEnumType superEnumTypeCandidate, IIpsProject ipsProject) {
        if (superEnumTypeCandidate == null) {
            return false;
        }
        IEnumType foundSuperEnumType = this.findSuperEnumType(ipsProject);
        if (foundSuperEnumType == null) {
            return false;
        }
        if (superEnumTypeCandidate.equals(foundSuperEnumType)) {
            return true;
        }
        IsSubEnumTypeOfVisitor visitor = new IsSubEnumTypeOfVisitor(ipsProject, superEnumTypeCandidate);
        visitor.start(foundSuperEnumType);
        return visitor.isSubtype();
    }

    @Override
    public boolean isSubEnumTypeOrSelf(IEnumType superEnumTypeCandidate, IIpsProject ipsProject) {
        if (this.equals(superEnumTypeCandidate)) {
            return true;
        }
        return this.isSubEnumTypeOf(superEnumTypeCandidate, ipsProject);
    }

    @Override
    public List<IEnumAttribute> getEnumAttributes(boolean includeLiteralName) {
        return this.getEnumAttributesInternal(false, includeLiteralName);
    }

    @Override
    public List<IEnumAttribute> getEnumAttributesIncludeSupertypeCopies(boolean includeLiteralName) {
        return this.getEnumAttributesInternal(true, includeLiteralName);
    }

    private List<IEnumAttribute> getEnumAttributesInternal(boolean includeInheritedCopies, boolean includeLiteralNameAttributes) {
        IIpsObjectPart[] parts;
        ArrayList<IEnumAttribute> attributesList = new ArrayList<IEnumAttribute>();
        IIpsObjectPart[] iIpsObjectPartArray = parts = this.enumAttributes.getParts();
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            boolean literalNameAttribute;
            IIpsObjectPart currentIpsObjectPart = iIpsObjectPartArray[n2];
            IEnumAttribute currentEnumAttribute = (IEnumAttribute)currentIpsObjectPart;
            if ((!currentEnumAttribute.isInherited() || includeInheritedCopies) && ((literalNameAttribute = currentEnumAttribute instanceof IEnumLiteralNameAttribute) && includeLiteralNameAttributes || !literalNameAttribute)) {
                attributesList.add(currentEnumAttribute);
            }
            ++n2;
        }
        return attributesList;
    }

    @Override
    public List<IEnumAttribute> findAllEnumAttributes(boolean includeLiteralName, IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object)ipsProject);
        LinkedList<IEnumAttribute> allAttributes = new LinkedList<IEnumAttribute>();
        AttributeFinder collector = new AttributeFinder(this.getIpsProject(), allAttributes, includeLiteralName);
        collector.start(this);
        return allAttributes;
    }

    @Override
    public IEnumAttribute newEnumAttribute() {
        return this.createNewEnumAttribute(EnumAttribute.class);
    }

    @Override
    public IEnumLiteralNameAttribute newEnumLiteralNameAttribute() {
        IEnumLiteralNameAttribute literalNameAttribute = (IEnumLiteralNameAttribute)this.createNewEnumAttribute(EnumLiteralNameAttribute.class);
        literalNameAttribute.setName("LITERAL_NAME");
        literalNameAttribute.setDatatype(Datatype.STRING.getQualifiedName());
        literalNameAttribute.setUnique(true);
        return literalNameAttribute;
    }

    private IEnumAttribute createNewEnumAttribute(final Class<? extends IEnumAttribute> attributeClass) {
        return ((IpsModel)this.getIpsModel()).executeModificationsWithSingleEvent(new SingleEventModification<IEnumAttribute>(this.getIpsSrcFile()){
            private IEnumAttribute newEnumAttribute;

            @Override
            public boolean execute() {
                this.newEnumAttribute = EnumType.this.createNewEnumAttributeSingleEvent(attributeClass);
                return this.newEnumAttribute != null;
            }

            @Override
            public IEnumAttribute getResult() {
                return this.newEnumAttribute;
            }
        });
    }

    private IEnumAttribute createNewEnumAttributeSingleEvent(Class<? extends IEnumAttribute> attributeClass) {
        IEnumAttribute newEnumAttribute = this.newPart(attributeClass);
        for (IEnumValue currentEnumValue : this.getEnumValues()) {
            if (attributeClass.equals(EnumLiteralNameAttribute.class)) {
                currentEnumValue.newEnumLiteralNameAttributeValue();
                continue;
            }
            currentEnumValue.newEnumAttributeValue();
        }
        return newEnumAttribute;
    }

    @Override
    public IEnumType findEnumType(IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object)ipsProject);
        return this;
    }

    @Override
    public int getEnumAttributesCount(boolean includeLiteralName) {
        return this.getEnumAttributes(includeLiteralName).size();
    }

    @Override
    public int getEnumAttributesCountIncludeSupertypeCopies(boolean includeLiteralName) {
        return this.getEnumAttributesIncludeSupertypeCopies(includeLiteralName).size();
    }

    @Override
    public List<IEnumAttribute> findUniqueEnumAttributes(boolean includeLiteralName, IIpsProject ipsProject) {
        ArrayList<IEnumAttribute> uniqueEnumAttributes = new ArrayList<IEnumAttribute>(2);
        for (IEnumAttribute currentEnumAttribute : this.getEnumAttributesIncludeSupertypeCopies(includeLiteralName)) {
            if (!currentEnumAttribute.findIsUnique(ipsProject)) continue;
            uniqueEnumAttributes.add(currentEnumAttribute);
        }
        return uniqueEnumAttributes;
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        this.isAbstract = XmlUtil.getBooleanAttributeOrFalse(element, "abstract");
        this.extensible = XmlUtil.getBooleanAttributeOrFalse(element, "extensible");
        if (element.hasAttribute("identifierBoundary")) {
            this.identifierBoundary = element.getAttribute("identifierBoundary");
        }
        this.superEnumType = XmlUtil.getAttributeOrEmptyString(element, "superEnumType");
        this.enumContentPackageFragment = XmlUtil.getAttributeOrEmptyString(element, "enumContentName");
        this.initDeprecatedProperties(element);
        super.initPropertiesFromXml(element, id);
    }

    private void initDeprecatedProperties(Element element) {
        String containsValuesAttribute = element.getAttribute("containingValues");
        if (IpsStringUtils.isNotEmpty((String)containsValuesAttribute)) {
            this.extensible = !Boolean.parseBoolean(containsValuesAttribute);
        }
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        if (IpsStringUtils.isNotEmpty((String)this.superEnumType)) {
            element.setAttribute("superEnumType", this.superEnumType);
        }
        if (this.isAbstract) {
            element.setAttribute("abstract", String.valueOf(this.isAbstract));
        }
        if (this.extensible) {
            element.setAttribute("extensible", String.valueOf(this.extensible));
        }
        if (this.identifierBoundary != null) {
            element.setAttribute("identifierBoundary", this.identifierBoundary);
        }
        if (IpsStringUtils.isNotEmpty((String)this.enumContentPackageFragment)) {
            element.setAttribute("enumContentName", this.enumContentPackageFragment);
        }
    }

    @Override
    public int moveEnumAttribute(final IEnumAttribute enumAttribute, final boolean up) {
        ArgumentCheck.notNull((Object)enumAttribute);
        if (enumAttribute.getEnumType() != this) {
            throw new NoSuchElementException();
        }
        if (up ? enumAttribute == this.enumAttributes.getPart(0) : enumAttribute == this.enumAttributes.getPart(this.enumAttributes.size() - 1)) {
            return this.getIndexOfEnumAttribute(enumAttribute, true);
        }
        return ((IpsModel)this.getIpsModel()).executeModificationsWithSingleEvent(new SingleEventModification<Integer>(this.getIpsSrcFile()){
            private int[] newIndex;
            {
                super($anonymous0);
                this.newIndex = new int[0];
            }

            @Override
            public boolean execute() {
                int indexToMove = EnumType.this.getIndexOfEnumAttribute(enumAttribute, true);
                this.newIndex = EnumType.this.enumAttributes.moveParts(new int[]{indexToMove}, up);
                if (this.newIndex[0] != indexToMove) {
                    EnumType.this.moveEnumAttributeValues(indexToMove, EnumType.this.getEnumValues(), up);
                }
                return this.newIndex[0] != indexToMove;
            }

            @Override
            public Integer getResult() {
                return this.newIndex[0];
            }
        });
    }

    @Override
    public int getIndexOfEnumAttribute(IEnumAttribute enumAttribute, boolean considerLiteralName) {
        int indexOfEnumLiteralNameAttribute;
        ArgumentCheck.notNull((Object)enumAttribute);
        int indexOf = this.enumAttributes.indexOf(enumAttribute);
        if (!considerLiteralName && (indexOfEnumLiteralNameAttribute = this.getIndexOfEnumLiteralNameAttribute()) >= 0 && indexOfEnumLiteralNameAttribute < indexOf) {
            return indexOf - 1;
        }
        return indexOf;
    }

    @Override
    public int getIndexOfEnumLiteralNameAttribute() {
        if (this.getEnumLiteralNameAttribute() == null) {
            return -1;
        }
        return this.enumAttributes.indexOf(this.getEnumLiteralNameAttribute());
    }

    private void moveEnumAttributeValues(int enumAttributeIndex, List<IEnumValue> enumValues, boolean up) {
        for (IEnumValue currentEnumValue : enumValues) {
            currentEnumValue.moveEnumAttributeValue(currentEnumValue.getEnumAttributeValues().get(enumAttributeIndex), up);
        }
    }

    @Override
    public IEnumAttribute getEnumAttribute(String name) {
        ArgumentCheck.notNull((Object)name);
        return this.getEnumAttribute(name, false);
    }

    @Override
    public IEnumAttribute getEnumAttributeIncludeSupertypeCopies(String name) {
        ArgumentCheck.notNull((Object)name);
        return this.getEnumAttribute(name, true);
    }

    private IEnumAttribute getEnumAttribute(String name, boolean includeInherited) {
        List<IEnumAttribute> enumAttributesToSearch = includeInherited ? this.getEnumAttributesIncludeSupertypeCopies(true) : this.getEnumAttributes(true);
        for (IEnumAttribute currentEnumAttribute : enumAttributesToSearch) {
            if (!currentEnumAttribute.getName().equals(name)) continue;
            return currentEnumAttribute;
        }
        return null;
    }

    @Override
    public IEnumAttribute findEnumAttributeIncludeSupertypeOriginals(IIpsProject ipsProject, final String name) {
        ArgumentCheck.notNull((Object[])new Object[]{ipsProject, name});
        final ArrayList result = new ArrayList(1);
        EnumTypeHierarchyVisitor visitor = new EnumTypeHierarchyVisitor(ipsProject){

            @Override
            protected boolean visit(IEnumType currentType) {
                IEnumAttribute enumAttribute = currentType.getEnumAttribute(name);
                if (enumAttribute != null) {
                    result.add(enumAttribute);
                    return false;
                }
                return true;
            }
        };
        visitor.start(this);
        return result.isEmpty() ? null : (IEnumAttribute)result.get(0);
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        if (this.hasSuperEnumType()) {
            EnumTypeValidations.validateSuperEnumType(list, this, this.superEnumType, ipsProject);
        }
        EnumTypeValidations.validateSuperTypeHierarchy(list, this, ipsProject);
        if (this.hasSuperEnumType()) {
            if (list.containsErrorMsg()) {
                return;
            }
            this.validateInheritedAttributes(list, ipsProject);
        }
        this.validateLiteralNameAttribute(list);
        this.validateIdentifierAttribute(list, ipsProject);
        this.validateUsedAsNameInFaktorIpsUiAttribute(list, ipsProject);
        this.validateEnumContentAlreadyUsed(list, ipsProject);
        if (this.isValidateIdentifierBoundaryOnDatatypeNecessary(this.getIdentifierBoundary())) {
            this.validateIdentifierBoundaryOnDatatype(list);
        }
        EnumTypeValidations.validateEnumContentName(list, this, this.isAbstract(), this.isExtensible(), this.enumContentPackageFragment);
        if (this.getEnumValuesCount() > 0 && this.isAbstract) {
            String text = Messages.EnumType_EnumValuesObsolete;
            Message validationMessage = new Message("ENUMTYPE-EnumTypeEnumValuesObsolete", text, Message.WARNING, (Object)this);
            list.add(validationMessage);
        }
    }

    private void validateLiteralNameAttribute(MessageList validationMessageList) {
        if (this.isAbstract()) {
            return;
        }
        this.validateLiteralNameAttributeExists(validationMessageList);
        this.validateLiteralNameAttributeCount(validationMessageList);
    }

    private void validateIdentifierAttribute(MessageList validationMessageList, IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object[])new Object[]{ipsProject});
        if (this.isAbstract) {
            return;
        }
        if (this.findIdentiferAttribute(ipsProject) == null) {
            String text = Messages.EnumType_NoUsedAsIdInFaktorIpsUiAttribute;
            Message message = new Message("ENUMTYPE-EnumTypeNoUsedAsIdInFaktorIpsUiAttribute", text, Message.ERROR, new ObjectProperty[]{new ObjectProperty((Object)this, null)});
            validationMessageList.add(message);
        }
    }

    private void validateUsedAsNameInFaktorIpsUiAttribute(MessageList validationMessageList, IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object[])new Object[]{validationMessageList, ipsProject});
        if (this.isAbstract) {
            return;
        }
        if (this.findUsedAsNameInFaktorIpsUiAttribute(ipsProject) == null) {
            String text = Messages.EnumType_NoUsedAsNameInFaktorIpsUiAttribute;
            Message message = new Message("ENUMTYPE-EnumTypeNoUsedAsNameInFaktorIpsUiAttribute", text, Message.ERROR, new ObjectProperty[]{new ObjectProperty((Object)this, null)});
            validationMessageList.add(message);
        }
    }

    private void validateEnumContentAlreadyUsed(MessageList validationMessageList, IIpsProject ipsProject) {
        IEnumContent enumContent = this.findEnumContent(ipsProject);
        if (enumContent != null && !enumContent.getEnumType().equals(this.getQualifiedName())) {
            String text = MessageFormat.format(Messages.EnumType_EnumContentAlreadyUsedByAnotherEnumType, this.enumContentPackageFragment, enumContent.getEnumType());
            Message message = new Message("ENUMTYPE-EnumTypeEnumContentAlreadyUsed", text, Message.ERROR, (Object)this, new String[]{"enumContentName"});
            validationMessageList.add(message);
        }
    }

    protected boolean isValidateIdentifierBoundaryOnDatatypeNecessary(String identifierBoundaryString) {
        return !this.isAbstract && this.isExtensible() && this.isIdentifierAttributeComparable() && this.isIdentifierBoundaryValueValid(identifierBoundaryString);
    }

    private boolean isIdentifierAttributeComparable() {
        ValueDatatype datatype;
        IEnumAttribute identiferAttribute = this.findIdentiferAttribute(this.getIpsProject());
        if (identiferAttribute != null && (datatype = identiferAttribute.findDatatype(this.getIpsProject())) != null) {
            return datatype.supportsCompare();
        }
        return false;
    }

    private boolean isIdentifierBoundaryValueValid(String identifierBoundaryString) {
        return identifierBoundaryString != null && !identifierBoundaryString.isEmpty();
    }

    private void validateIdentifierBoundaryOnDatatype(MessageList validationMessageList) {
        IEnumAttribute identifierAttribute = this.getIdentifierAttribute();
        if (identifierAttribute != null) {
            ValueDatatype identifierAttributeDatatype = identifierAttribute.findDatatype(this.getIpsProject());
            String identifierBoundaryString = this.getIdentifierBoundary();
            ValidationUtils.checkValue(identifierAttributeDatatype, identifierAttribute.getDatatype(), identifierBoundaryString, this, "identifierBoundary", validationMessageList);
        }
    }

    private IEnumAttribute getIdentifierAttribute() {
        IEnumAttribute identifierAttribute = this.hasSuperEnumType() ? this.findSuperEnumType(this.getIpsProject()).findIdentiferAttribute(this.getIpsProject()) : this.findIdentiferAttribute(this.getIpsProject());
        return identifierAttribute;
    }

    private void validateLiteralNameAttributeExists(MessageList validationMessageList) {
        if (this.isMissingLiteralNameAttribute()) {
            String text = Messages.EnumType_NoLiteralNameAttribute;
            Message message = new Message("ENUMTYPE-EnumTypeNoLiteralNameAttribute", text, Message.ERROR, new ObjectProperty[]{new ObjectProperty((Object)this, null)});
            validationMessageList.add(message);
        }
    }

    private void validateLiteralNameAttributeCount(MessageList validationMessageList) {
        int literalNameAttributesCount = this.getEnumLiteralNameAttributesCount();
        if (literalNameAttributesCount > 1) {
            String text = MessageFormat.format(Messages.EnumType_MultipleLiteralNameAttributes, literalNameAttributesCount);
            Message message = new Message("ENUMTYPE-EnumTypeMultipleLiteralNameAttributes", text, Message.ERROR, (Object)this);
            validationMessageList.add(message);
        }
    }

    private void validateInheritedAttributes(MessageList validationMessageList, IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object[])new Object[]{validationMessageList, ipsProject});
        if (this.isAbstract()) {
            return;
        }
        this.validateInheritedAttributesNonAbstract(validationMessageList, ipsProject);
    }

    private void validateInheritedAttributesNonAbstract(MessageList validationMessageList, IIpsProject ipsProject) {
        List<IEnumAttribute> notInheritedAttributes = this.findInheritEnumAttributeCandidates(ipsProject);
        int notInheritedAttributesCount = notInheritedAttributes.size();
        if (notInheritedAttributesCount > 0) {
            IEnumAttribute firstNotInheritedAttribute = notInheritedAttributes.get(0);
            String showFirst = String.valueOf(firstNotInheritedAttribute.getName()) + " (" + firstNotInheritedAttribute.getDatatype() + ')';
            String text = notInheritedAttributesCount > 1 ? MessageFormat.format(Messages.EnumType_NotInheritedAttributesInSupertypeHierarchyPlural, notInheritedAttributesCount, showFirst) : MessageFormat.format(Messages.EnumType_NotInheritedAttributesInSupertypeHierarchySingular, showFirst);
            Message message = new Message("ENUMTYPE-EnumTypeNotInheritedAttributesInSupertypeHierarchy", text, Message.ERROR, (Object)this);
            validationMessageList.add(message);
        }
    }

    public boolean isMissingLiteralNameAttribute() {
        return !this.containsEnumLiteralNameAttribute();
    }

    @Override
    public boolean isInextensibleEnum() {
        return !this.isAbstract() && !this.isExtensible();
    }

    public int getEnumLiteralNameAttributesCount() {
        int count = 0;
        for (IEnumAttribute currentEnumAttribute : this.enumAttributes) {
            if (!(currentEnumAttribute instanceof IEnumLiteralNameAttribute)) continue;
            ++count;
        }
        return count;
    }

    private List<IEnumAttribute> findAllAttributesInSupertypeHierarchy(IIpsProject ipsProject) {
        ArrayList<IEnumAttribute> returnAttributesList = new ArrayList<IEnumAttribute>();
        List<IEnumType> superEnumTypes = this.findAllSuperEnumTypes(ipsProject);
        int i = superEnumTypes.size() - 1;
        while (i >= 0) {
            IEnumType currentSuperEnumType = superEnumTypes.get(i);
            for (IEnumAttribute currentEnumAttribute : currentSuperEnumType.getEnumAttributes(false)) {
                returnAttributesList.add(currentEnumAttribute);
            }
            --i;
        }
        return returnAttributesList;
    }

    @Override
    public IEnumType findSuperEnumType(IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object)ipsProject);
        if (!this.hasSuperEnumType()) {
            return null;
        }
        IIpsSrcFile enumTypeSrcFile = ipsProject.findIpsSrcFile(IpsObjectType.ENUM_TYPE, this.superEnumType);
        if (enumTypeSrcFile != null && enumTypeSrcFile.exists()) {
            return (IEnumType)enumTypeSrcFile.getIpsObject();
        }
        return null;
    }

    @Override
    public Set<IEnumType> searchSubclassingEnumTypes() {
        IIpsProject[] ipsProjects;
        HashSet<IEnumType> collectedEnumTypes = new HashSet<IEnumType>(25);
        IIpsProject[] iIpsProjectArray = ipsProjects = this.getIpsProject().findReferencingProjectLeavesOrSelf();
        int n = ipsProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsSrcFile[] srcFiles;
            IIpsProject ipsProject = iIpsProjectArray[n2];
            IIpsSrcFile[] iIpsSrcFileArray = srcFiles = ipsProject.findIpsSrcFiles(IpsObjectType.ENUM_TYPE);
            int n3 = srcFiles.length;
            int n4 = 0;
            while (n4 < n3) {
                IIpsSrcFile ipsSrcFile = iIpsSrcFileArray[n4];
                IEnumType enumType = (IEnumType)ipsSrcFile.getIpsObject();
                if (enumType.isSubEnumTypeOf(this, ipsProject)) {
                    collectedEnumTypes.add(enumType);
                }
                ++n4;
            }
            ++n2;
        }
        return collectedEnumTypes;
    }

    @Override
    public IEnumAttribute findIdentiferAttribute(IIpsProject ipsProject) {
        for (IEnumAttribute currentEnumAttribute : this.getEnumAttributesIncludeSupertypeCopies(false)) {
            if (!currentEnumAttribute.findIsIdentifier(ipsProject)) continue;
            return currentEnumAttribute;
        }
        return null;
    }

    @Override
    public IEnumAttribute findUsedAsNameInFaktorIpsUiAttribute(IIpsProject ipsProject) {
        for (IEnumAttribute currentEnumAttribute : this.getEnumAttributesIncludeSupertypeCopies(false)) {
            if (!currentEnumAttribute.findIsUsedAsNameInFaktorIpsUi(ipsProject)) continue;
            return currentEnumAttribute;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean removePartThis(IIpsObjectPart part) {
        IIpsObjectPart iIpsObjectPart = part;
        if (iIpsObjectPart instanceof IEnumAttribute) {
            void enumAttributeToDelete;
            IEnumAttribute iEnumAttribute = (IEnumAttribute)iIpsObjectPart;
            IEnumAttribute cfr_ignored_0 = (IEnumAttribute)iIpsObjectPart;
            ((IpsModel)this.getIpsModel()).executeModificationsWithSingleEvent(new SingleEventModification<Void>(this.getIpsSrcFile(), (IEnumAttribute)enumAttributeToDelete, part){
                private final /* synthetic */ IEnumAttribute val$enumAttributeToDelete;
                private final /* synthetic */ IIpsObjectPart val$part;
                {
                    this.val$enumAttributeToDelete = iEnumAttribute;
                    this.val$part = iIpsObjectPart;
                    super($anonymous0);
                }

                @Override
                public boolean execute() {
                    EnumType.this.deleteEnumAttributeValues(this.val$enumAttributeToDelete, EnumType.this.getEnumValues());
                    return EnumType.super.removePartThis(this.val$part);
                }
            });
            return part.isDeleted();
        }
        return super.removePartThis(part);
    }

    private void deleteEnumAttributeValues(IEnumAttribute enumAttribute, List<IEnumValue> enumValues) {
        boolean deleteEnumValues = false;
        for (IEnumValue currentEnumValue : enumValues) {
            int index = this.getIndexOfEnumAttribute(enumAttribute, true);
            currentEnumValue.getEnumAttributeValues().get(index).delete();
            boolean bl = deleteEnumValues = currentEnumValue.getEnumAttributeValuesCount() == 0;
        }
        if (deleteEnumValues) {
            for (IEnumValue enumValue : enumValues) {
                enumValue.delete();
            }
        }
    }

    @Override
    public boolean hasSuperEnumType() {
        return IpsStringUtils.isNotEmpty((String)this.superEnumType);
    }

    @Override
    public boolean hasExistingSuperEnumType(IIpsProject ipsProject) {
        return this.findSuperEnumType(ipsProject) != null;
    }

    @Override
    public List<IEnumType> findAllSuperEnumTypes(IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object)ipsProject);
        final ArrayList<IEnumType> superEnumTypes = new ArrayList<IEnumType>();
        IEnumType directSuperEnumType = this.findSuperEnumType(ipsProject);
        if (directSuperEnumType != null) {
            EnumTypeHierarchyVisitor collector = new EnumTypeHierarchyVisitor(this.getIpsProject()){

                @Override
                protected boolean visit(IEnumType currentType) {
                    superEnumTypes.add(currentType);
                    return true;
                }
            };
            collector.start(directSuperEnumType);
        }
        return superEnumTypes;
    }

    @Override
    public List<IEnumAttribute> findInheritEnumAttributeCandidates(IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object)ipsProject);
        ArrayList<IEnumAttribute> inheritedEnumAttributes = new ArrayList<IEnumAttribute>();
        for (IEnumAttribute currentEnumAttribute : this.getEnumAttributesIncludeSupertypeCopies(false)) {
            if (!currentEnumAttribute.isInherited()) continue;
            inheritedEnumAttributes.add(currentEnumAttribute);
        }
        List<IEnumAttribute> supertypeHierarchyAttributes = this.findAllAttributesInSupertypeHierarchy(ipsProject);
        ArrayList<IEnumAttribute> notInheritedEnumAttributes = new ArrayList<IEnumAttribute>();
        for (IEnumAttribute currentSupertypeHierarchyAttribute : supertypeHierarchyAttributes) {
            if (this.containsEqualEnumAttribute(inheritedEnumAttributes, currentSupertypeHierarchyAttribute)) continue;
            notInheritedEnumAttributes.add(currentSupertypeHierarchyAttribute);
        }
        return notInheritedEnumAttributes;
    }

    private boolean containsEqualEnumAttribute(List<IEnumAttribute> listOfEnumAttributes, IEnumAttribute enumAttribute) {
        for (IEnumAttribute currentEnumAttribute : listOfEnumAttributes) {
            if (!currentEnumAttribute.getName().equals(enumAttribute.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<IEnumAttribute> inheritEnumAttributes(List<IEnumAttribute> superEnumAttributes) {
        ArrayList<IEnumAttribute> newEnumAttributes = new ArrayList<IEnumAttribute>();
        for (IEnumAttribute currentSuperEnumAttribute : superEnumAttributes) {
            String currentSuperEnumAttributeName = currentSuperEnumAttribute.getName();
            IEnumAttribute searchedEnumAttribute = this.getEnumAttributeIncludeSupertypeCopies(currentSuperEnumAttributeName);
            if (searchedEnumAttribute != null && searchedEnumAttribute.isInherited()) continue;
            searchedEnumAttribute = this.findEnumAttributeIncludeSupertypeOriginals(this.getIpsProject(), currentSuperEnumAttributeName);
            boolean partOfSupertypeHierarchy = false;
            if (searchedEnumAttribute != null && searchedEnumAttribute.getEnumType() != this) {
                partOfSupertypeHierarchy = true;
            }
            if (!partOfSupertypeHierarchy) {
                throw new IllegalArgumentException("The given enum attribute " + currentSuperEnumAttributeName + " is not part of the supertype hierarchy.");
            }
            IEnumAttribute newEnumAttribute = this.newEnumAttribute();
            newEnumAttribute.setName(currentSuperEnumAttributeName);
            newEnumAttribute.setInherited(true);
            newEnumAttributes.add(newEnumAttribute);
        }
        return newEnumAttributes;
    }

    @Override
    public String getEnumContentName() {
        return this.enumContentPackageFragment;
    }

    @Override
    public void setEnumContentName(String packageFragmentQualifiedName) {
        ArgumentCheck.notNull((Object)packageFragmentQualifiedName);
        String oldEnumContentPackageFragment = this.enumContentPackageFragment;
        this.enumContentPackageFragment = packageFragmentQualifiedName;
        this.valueChanged(oldEnumContentPackageFragment, packageFragmentQualifiedName);
    }

    @Override
    public IEnumContent findEnumContent(IIpsProject ipsProject) {
        return ipsProject.findEnumContent(this);
    }

    @Override
    protected IDependency[] dependsOn(Map<IDependency, List<IDependencyDetail>> details) {
        ArrayList<IDependency> dependencies = new ArrayList<IDependency>();
        if (this.hasSuperEnumType()) {
            IpsObjectDependency superEnumTypeDependency = IpsObjectDependency.createSubtypeDependency(this.getQualifiedNameType(), new QualifiedNameType(this.superEnumType, IpsObjectType.ENUM_TYPE));
            this.addDetails(details, superEnumTypeDependency, this, "superEnumType");
            dependencies.add(superEnumTypeDependency);
        }
        for (IEnumAttribute enumAttribute : this.enumAttributes) {
            String datatype = enumAttribute.getDatatype();
            DatatypeDependency dependency = new DatatypeDependency(this.getQualifiedNameType(), datatype);
            dependencies.add(dependency);
            this.addDetails(details, dependency, enumAttribute, "datatype");
        }
        return dependencies.toArray(new IDependency[dependencies.size()]);
    }

    @Override
    public Collection<IIpsSrcFile> searchMetaObjectSrcFiles(boolean includeSubtypes) {
        IIpsProject[] searchProjects;
        TreeSet<IIpsSrcFile> result = TreeSetHelper.newIpsSrcFileTreeSet();
        IIpsProject[] iIpsProjectArray = searchProjects = this.getIpsProject().findReferencingProjectLeavesOrSelf();
        int n = searchProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsProject project = iIpsProjectArray[n2];
            result.addAll(Arrays.asList(project.findAllEnumContentSrcFiles(this, includeSubtypes)));
            ++n2;
        }
        return result;
    }

    @Override
    public boolean containsEnumAttribute(String attributeName) {
        return this.containsEnumAttribute(attributeName, false);
    }

    @Override
    public boolean containsEnumAttributeIncludeSupertypeCopies(String attributeName) {
        return this.containsEnumAttribute(attributeName, true);
    }

    @Override
    public boolean containsEnumLiteralNameAttribute() {
        return this.getEnumLiteralNameAttribute() != null;
    }

    private boolean containsEnumAttribute(String attributeName, boolean includeSupertypeCopies) {
        List<IEnumAttribute> enumAttributesToCheck = includeSupertypeCopies ? this.getEnumAttributesIncludeSupertypeCopies(true) : this.getEnumAttributes(true);
        for (IEnumAttribute currentEnumAttribute : enumAttributesToCheck) {
            if (!currentEnumAttribute.getName().equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected IIpsObjectPart newPartThis(Element xmlTag, String id) {
        if (xmlTag.getTagName().equals("EnumLiteralNameAttribute")) {
            return this.newPart(EnumLiteralNameAttribute.class);
        }
        return super.newPartThis(xmlTag, id);
    }

    @Override
    public IEnumLiteralNameAttribute getEnumLiteralNameAttribute() {
        for (IEnumAttribute currentAttribute : this.enumAttributes) {
            if (!(currentAttribute instanceof IEnumLiteralNameAttribute)) continue;
            return (IEnumLiteralNameAttribute)currentAttribute;
        }
        return null;
    }

    @Override
    public boolean hasEnumLiteralNameAttribute() {
        return this.getEnumLiteralNameAttribute() != null;
    }

    @Override
    public boolean isCapableOfContainingValues() {
        return !this.isAbstract;
    }

    @Override
    public List<IEnumValue> findAggregatedEnumValues() {
        return this.getEnumValues();
    }

    @Override
    public boolean isIdentifierNamespaceBelowBoundary() {
        return true;
    }

    @Override
    public boolean isOverriding() {
        return this.hasSuperEnumType();
    }

    private static final class AttributeFinder
    extends EnumTypeHierarchyVisitor {
        private final LinkedList<IEnumAttribute> allAttributes;
        private final boolean includeLiteralName;

        private AttributeFinder(IIpsProject ipsProject, LinkedList<IEnumAttribute> allAttributes, boolean includeLiteralName) {
            super(ipsProject);
            this.allAttributes = allAttributes;
            this.includeLiteralName = includeLiteralName;
        }

        @Override
        protected boolean visit(IEnumType currentType) {
            LinkedList<IEnumAttribute> attributesToPrepend = new LinkedList<IEnumAttribute>();
            for (IEnumAttribute localAttribute : ((EnumType)currentType).getEnumAttributesInternal(true, this.includeLiteralName)) {
                if (this.contains(localAttribute)) continue;
                attributesToPrepend.addFirst(localAttribute);
            }
            for (IEnumAttribute attributeToPrepend : attributesToPrepend) {
                this.allAttributes.addFirst(attributeToPrepend);
            }
            return true;
        }

        private boolean contains(IEnumAttribute attribute) {
            for (IEnumAttribute enumAttribute : this.allAttributes) {
                if (!enumAttribute.getName().equals(attribute.getName()) || !enumAttribute.isInherited()) continue;
                return true;
            }
            return false;
        }
    }

    private static class IsSubEnumTypeOfVisitor
    extends EnumTypeHierarchyVisitor {
        private IEnumType superEnumTypeCandidate;
        private boolean subEnumType = false;

        public IsSubEnumTypeOfVisitor(IIpsProject ipsProject, IEnumType superEnumTypeCandidate) {
            super(ipsProject);
            ArgumentCheck.notNull((Object)superEnumTypeCandidate);
            this.superEnumTypeCandidate = superEnumTypeCandidate;
        }

        boolean isSubtype() {
            return this.subEnumType;
        }

        @Override
        protected boolean visit(IEnumType currentEnumType) {
            if (currentEnumType == this.superEnumTypeCandidate) {
                this.subEnumType = true;
                return false;
            }
            return true;
        }
    }
}

