/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.enums;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.faktorips.devtools.model.enums.EnumTypeHierarchyVisitor;
import org.faktorips.devtools.model.enums.IEnumType;
import org.faktorips.devtools.model.enums.Messages;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.ArgumentCheck;

public class EnumTypeValidations {
    private EnumTypeValidations() {
    }

    public static void validateSuperEnumType(MessageList validationMessageList, IEnumType enumType, String superEnumTypeQualifiedName, IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object[])new Object[]{validationMessageList, superEnumTypeQualifiedName, ipsProject});
        ArgumentCheck.isTrue((boolean)IpsStringUtils.isNotEmpty((String)superEnumTypeQualifiedName));
        IEnumType superEnumType = ipsProject.findEnumType(superEnumTypeQualifiedName);
        if (superEnumType == null) {
            ObjectProperty[] objectPropertyArray;
            String text = MessageFormat.format(Messages.EnumType_SupertypeDoesNotExist, superEnumTypeQualifiedName);
            if (enumType != null) {
                ObjectProperty[] objectPropertyArray2 = new ObjectProperty[1];
                objectPropertyArray = objectPropertyArray2;
                objectPropertyArray2[0] = new ObjectProperty((Object)enumType, "superEnumType");
            } else {
                objectPropertyArray = new ObjectProperty[]{};
            }
            Message message = new Message("ENUMTYPE-EnumTypeSupertypeDoesNotExist", text, Message.ERROR, objectPropertyArray);
            validationMessageList.add(message);
            return;
        }
        if (!superEnumType.isAbstract()) {
            String text = MessageFormat.format(Messages.EnumType_SupertypeIsNotAbstract, superEnumType.getQualifiedName());
            Message message = new Message("ENUMTYPE-EnumTypeSupertypeIsNotAbstract", text, Message.ERROR, (Object)enumType, new String[]{"superEnumType"});
            validationMessageList.add(message);
        }
    }

    public static void validateSuperTypeHierarchy(MessageList msgList, IEnumType enumType, IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object[])new Object[]{msgList, ipsProject});
        IEnumType superEnumType = enumType.findSuperEnumType(ipsProject);
        if (superEnumType == null) {
            return;
        }
        SupertypeCollector collector = new SupertypeCollector(ipsProject);
        collector.start(superEnumType);
        if (collector.cycleDetected()) {
            String msg = MessageFormat.format(Messages.EnumType_cycleDetected, enumType.getQualifiedName());
            msgList.add(new Message("ENUMTYPE-CycleInTypeHierarchy", msg, Message.ERROR, (Object)enumType, new String[]{"superEnumType"}));
        } else {
            for (IEnumType iEnumType : collector.superTypes) {
                MessageList superResult = iEnumType.validate(ipsProject);
                if (superResult.isEmpty() || superResult.getMessageByCode("ENUMTYPE-EnumTypeSupertypeDoesNotExist") == null && superResult.getMessageByCode("ENUMTYPE-EnumTypeSupertypeIsNotAbstract") == null) continue;
                String text = MessageFormat.format(Messages.EnumType_inconsistentHierarchy, enumType.getQualifiedName());
                msgList.add(new Message("ENUMTYPE-InconsistentTypeHierachy", text, Message.ERROR, (Object)enumType, new String[]{"superEnumType"}));
            }
        }
    }

    public static void validateEnumContentName(MessageList msgList, IEnumType enumType, boolean enumTypeIsAbstract, boolean enumTypeExtensible, String enumContentName) {
        ArgumentCheck.notNull((Object[])new Object[]{msgList, enumContentName});
        if (enumTypeExtensible && !enumTypeIsAbstract && enumContentName.length() == 0) {
            ObjectProperty[] objectPropertyArray;
            String text = Messages.EnumType_EnumContentNameEmpty;
            if (enumType != null) {
                ObjectProperty[] objectPropertyArray2 = new ObjectProperty[1];
                objectPropertyArray = objectPropertyArray2;
                objectPropertyArray2[0] = new ObjectProperty((Object)enumType, "enumContentName");
            } else {
                objectPropertyArray = new ObjectProperty[]{};
            }
            Message message = new Message("ENUMTYPE-EnumTypeEnumContentNameEmpty", text, Message.ERROR, objectPropertyArray);
            msgList.add(message);
        }
    }

    private static class SupertypeCollector
    extends EnumTypeHierarchyVisitor {
        private List<IEnumType> superTypes = new ArrayList<IEnumType>();

        public SupertypeCollector(IIpsProject ipsProject) {
            super(ipsProject);
        }

        @Override
        protected boolean visit(IEnumType currentType) {
            this.superTypes.add(currentType);
            return true;
        }
    }
}

