/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.enums;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.faktorips.devtools.model.enums.IEnumAttribute;
import org.faktorips.devtools.model.enums.IEnumAttributeValue;
import org.faktorips.devtools.model.enums.IEnumContent;
import org.faktorips.devtools.model.enums.IEnumLiteralNameAttributeValue;
import org.faktorips.devtools.model.enums.IEnumType;
import org.faktorips.devtools.model.enums.IEnumValue;
import org.faktorips.devtools.model.enums.IEnumValueContainer;
import org.faktorips.devtools.model.internal.enums.EnumAttributeValue;
import org.faktorips.devtools.model.internal.enums.EnumLiteralNameAttributeValue;
import org.faktorips.devtools.model.internal.enums.EnumValueContainer;
import org.faktorips.devtools.model.internal.enums.Messages;
import org.faktorips.devtools.model.internal.ipsobject.BaseIpsObjectPart;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectPartCollection;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.value.IValue;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EnumValue
extends BaseIpsObjectPart
implements IEnumValue {
    private IpsObjectPartCollection<IEnumAttributeValue> enumAttributeValues = new IpsObjectPartCollection<IEnumAttributeValue>(this, EnumAttributeValue.class, IEnumAttributeValue.class, "EnumAttributeValue");

    public EnumValue(EnumValueContainer parent, String id) {
        super(parent, id);
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement("EnumValue");
    }

    @Override
    public List<IEnumAttributeValue> getEnumAttributeValues() {
        IIpsObjectPart[] parts;
        ArrayList<IEnumAttributeValue> attributeValuesList = new ArrayList<IEnumAttributeValue>();
        IIpsObjectPart[] iIpsObjectPartArray = parts = this.enumAttributeValues.getParts();
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsObjectPart currentObjectPart = iIpsObjectPartArray[n2];
            attributeValuesList.add((IEnumAttributeValue)currentObjectPart);
            ++n2;
        }
        return attributeValuesList;
    }

    @Override
    public IEnumAttributeValue newEnumAttributeValue() {
        return this.createNewEnumAttributeValue(EnumAttributeValue.class);
    }

    @Override
    public IEnumLiteralNameAttributeValue newEnumLiteralNameAttributeValue() {
        return this.createNewEnumAttributeValue(EnumLiteralNameAttributeValue.class);
    }

    private <T extends IEnumAttributeValue> T createNewEnumAttributeValue(Class<T> attributeValueClass) {
        IEnumAttributeValue attributeValue = (IEnumAttributeValue)this.newPart(attributeValueClass);
        this.fixEnumAttributeValueAfterConstructing(attributeValue);
        return (T)attributeValue;
    }

    private void fixEnumAttributeValueAfterConstructing(IEnumAttributeValue enumAttributeValue) {
        IEnumType enumType = this.findEnumType();
        if (enumType != null) {
            List<IEnumAttribute> enumAttributes = enumType.getEnumAttributesIncludeSupertypeCopies(this.isEnumTypeValue());
            int index = this.getEnumAttributeValuesCount() - 1;
            if (enumAttributes.size() > index) {
                IEnumAttribute enumAttribute = enumAttributes.get(index);
                enumAttributeValue.fixValueType(enumAttribute.isMultilingual());
            }
        }
    }

    private IEnumType findEnumType() {
        return this.getEnumValueContainer().findEnumType(this.getIpsProject());
    }

    protected boolean isEnumTypeValue() {
        return this.getEnumValueContainer() instanceof IEnumType;
    }

    @Override
    protected IIpsObjectPart newPartThis(Element xmlTag, String id) {
        if (xmlTag.getTagName().equals("EnumLiteralNameAttributeValue")) {
            return this.newPart(EnumLiteralNameAttributeValue.class);
        }
        return super.newPartThis(xmlTag, id);
    }

    @Override
    public int moveEnumAttributeValue(IEnumAttributeValue enumAttributeValue, boolean up) {
        ArgumentCheck.notNull((Object)enumAttributeValue);
        int index = this.getIndexOfEnumAttributeValue(enumAttributeValue);
        if (up ? index == 0 : index == this.getEnumAttributeValuesCount() - 1) {
            return index;
        }
        int[] newIndex = this.enumAttributeValues.moveParts(new int[]{index}, up);
        return newIndex[0];
    }

    @Override
    public void swapEnumAttributeValue(int firstIndex, int secondIndex) {
        if (firstIndex == secondIndex || firstIndex < 0 || secondIndex < 0) {
            throw new IllegalArgumentException();
        }
        int positionOfFirstAttribute = firstIndex;
        int positionOfSecondAttribute = secondIndex;
        if (firstIndex < secondIndex) {
            positionOfFirstAttribute = secondIndex;
            positionOfSecondAttribute = firstIndex;
        }
        IEnumAttributeValue firstValue = this.getEnumAttributeValues().get(positionOfFirstAttribute);
        IEnumAttributeValue secondValue = this.getEnumAttributeValues().get(positionOfSecondAttribute);
        int currentIndex = positionOfFirstAttribute;
        while (currentIndex != positionOfSecondAttribute) {
            currentIndex = this.moveEnumAttributeValue(firstValue, true);
        }
        currentIndex = positionOfSecondAttribute + 1;
        while (currentIndex != positionOfFirstAttribute) {
            currentIndex = this.moveEnumAttributeValue(secondValue, false);
        }
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        IEnumValueContainer enumValueContainer = this.getEnumValueContainer();
        IEnumType enumType = enumValueContainer.findEnumType(ipsProject);
        if (enumType == null) {
            return;
        }
        int numberNeeded = 0;
        if (this.isEnumTypeValue()) {
            IEnumType containerType = (IEnumType)enumValueContainer;
            numberNeeded = containerType.getEnumAttributesCountIncludeSupertypeCopies(true);
        } else {
            IEnumContent contentType = (IEnumContent)enumValueContainer;
            numberNeeded = contentType.getEnumAttributeReferencesCount();
        }
        if (numberNeeded != this.getEnumAttributeValuesCount()) {
            String text = Messages.EnumValue_NumberAttributeValuesDoesNotCorrespondToNumberAttributes;
            Message validationMessage = new Message("ENUMVALUE-EnumValueNumberAttributeValuesDoesNotCorrespondToNumberAttributes", text, Message.ERROR, (Object)this);
            list.add(validationMessage);
        }
    }

    @Override
    public int getEnumAttributeValuesCount() {
        return this.enumAttributeValues.size();
    }

    @Override
    public IEnumValueContainer getEnumValueContainer() {
        return (IEnumValueContainer)this.getParent();
    }

    @Override
    public IEnumAttributeValue getEnumAttributeValue(IEnumAttribute enumAttribute) {
        if (enumAttribute == null) {
            return null;
        }
        int attributeIndex = enumAttribute.getEnumType().getIndexOfEnumAttribute(enumAttribute, this.isEnumTypeValue());
        if (attributeIndex < 0 || this.enumAttributeValues.size() - 1 < attributeIndex) {
            return null;
        }
        return this.enumAttributeValues.getPart(attributeIndex);
    }

    @Override
    public void setEnumAttributeValue(IEnumAttribute enumAttribute, IValue<?> value) {
        ArgumentCheck.notNull((Object)enumAttribute);
        this.getEnumAttributeValue(enumAttribute).setValue(value);
    }

    @Override
    public void setEnumAttributeValue(String enumAttributeName, IValue<?> value) {
        ArgumentCheck.notNull((Object)enumAttributeName);
        IEnumType enumType = this.findEnumType();
        IEnumAttribute enumAttribute = enumType.getEnumAttributeIncludeSupertypeCopies(enumAttributeName);
        if (enumAttribute == null) {
            throw new NoSuchElementException();
        }
        this.setEnumAttributeValue(enumAttribute, value);
    }

    @Override
    public void setEnumAttributeValue(int enumAttributeIndex, IValue<?> value) {
        if (enumAttributeIndex <= -1 || enumAttributeIndex >= this.enumAttributeValues.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.enumAttributeValues.getBackingList().get(enumAttributeIndex).setValue(value);
    }

    @Override
    public List<IEnumAttributeValue> findUniqueEnumAttributeValues(List<IEnumAttribute> uniqueEnumAttributes, IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object[])new Object[]{uniqueEnumAttributes, ipsProject});
        ArrayList<IEnumAttributeValue> uniqueAttributeValues = new ArrayList<IEnumAttributeValue>(uniqueEnumAttributes.size());
        for (IEnumAttribute currentUniqueAttribute : uniqueEnumAttributes) {
            uniqueAttributeValues.add(this.getEnumAttributeValue(currentUniqueAttribute));
        }
        return uniqueAttributeValues;
    }

    @Override
    public int getIndexOfEnumAttributeValue(IEnumAttributeValue enumAttributeValue) {
        ArgumentCheck.notNull((Object)enumAttributeValue);
        return this.enumAttributeValues.indexOf(enumAttributeValue);
    }

    @Override
    public IEnumLiteralNameAttributeValue getEnumLiteralNameAttributeValue() {
        if (!this.isEnumTypeValue()) {
            return null;
        }
        for (IEnumAttributeValue enumAttributeValue : this.enumAttributeValues) {
            if (!enumAttributeValue.isEnumLiteralNameAttributeValue()) continue;
            return (IEnumLiteralNameAttributeValue)enumAttributeValue;
        }
        return null;
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.removeAttribute("id");
    }
}

