/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.enums;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.ContentChangeEvent;
import org.faktorips.devtools.model.enums.IEnumAttribute;
import org.faktorips.devtools.model.enums.IEnumAttributeValue;
import org.faktorips.devtools.model.enums.IEnumType;
import org.faktorips.devtools.model.enums.IEnumValue;
import org.faktorips.devtools.model.enums.IEnumValueContainer;
import org.faktorips.devtools.model.internal.IpsModel;
import org.faktorips.devtools.model.internal.SingleEventModification;
import org.faktorips.devtools.model.internal.enums.EnumContent;
import org.faktorips.devtools.model.internal.enums.EnumValue;
import org.faktorips.devtools.model.internal.enums.UniqueIdentifierValidator;
import org.faktorips.devtools.model.internal.ipsobject.BaseIpsObject;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectPartCollection;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.value.ValueTypeMismatch;
import org.faktorips.util.ArgumentCheck;

public abstract class EnumValueContainer
extends BaseIpsObject
implements IEnumValueContainer {
    private IpsObjectPartCollection<IEnumValue> enumValues;
    private final UniqueIdentifierValidator uniqueIdentifierValidator;
    private final Map<String, IEnumValue> enumValuesByIdentifier = new ConcurrentHashMap<String, IEnumValue>(16, 0.75f, 1);
    private IEnumAttribute identifierAttribute;

    protected EnumValueContainer(IIpsSrcFile file) {
        super(file);
        this.enumValues = new IpsObjectPartCollection<IEnumValue>(this, EnumValue.class, IEnumValue.class, "EnumValue");
        this.uniqueIdentifierValidator = new UniqueIdentifierValidator(this);
    }

    @Override
    public List<IEnumValue> getEnumValues() {
        ArrayList<IEnumValue> valuesList = new ArrayList<IEnumValue>();
        valuesList.addAll(this.enumValues.asList());
        return valuesList;
    }

    @Override
    public List<String> findAllIdentifierAttributeValues(IIpsProject ipsProject) {
        ArrayList<String> valueIds = new ArrayList<String>();
        IEnumType enumType = this.findEnumType(ipsProject);
        IEnumAttribute isIdentifierEnumAttribute = enumType.findIdentiferAttribute(ipsProject);
        List allEnumValues = this.findAggregatedEnumValues();
        for (IEnumValue enumValue : allEnumValues) {
            IEnumAttributeValue enumAttributeValue = enumValue.getEnumAttributeValue(isIdentifierEnumAttribute);
            if (enumAttributeValue == null) continue;
            valueIds.add(enumAttributeValue.getValue().getDefaultLocalizedContent(ipsProject));
        }
        return valueIds;
    }

    @Override
    public IEnumValue findEnumValue(String identifierAttributeValue, IIpsProject ipsProject) {
        if (identifierAttributeValue == null) {
            return null;
        }
        this.checkIdentifierAttribute(ipsProject);
        if (this.identifierAttribute == null) {
            return null;
        }
        return this.getEnumValueForValidIdentifierAttribute(identifierAttributeValue);
    }

    private void checkIdentifierAttribute(IIpsProject ipsProject) {
        if (this.identifierAttribute == null || this.identifierAttribute.isDeleted() || !this.identifierAttribute.findIsIdentifier(ipsProject)) {
            IEnumType enumType = this.findEnumType(ipsProject);
            if (enumType != null) {
                this.identifierAttribute = enumType.findIdentiferAttribute(ipsProject);
                if (this.identifierAttribute != null) {
                    this.reinitEnumValuesByIdentifierMap();
                }
            } else {
                throw new IpsException("Can't find EnumType " + ((EnumContent)this).getEnumType());
            }
        }
    }

    private void reinitEnumValuesByIdentifierMap() {
        this.enumValuesByIdentifier.clear();
        List aggregatedEnumValues = this.findAggregatedEnumValues();
        for (IEnumValue enumValue : aggregatedEnumValues) {
            String identifier;
            IEnumAttributeValue enumAttributeValue = enumValue.getEnumAttributeValue(this.identifierAttribute);
            if (enumAttributeValue == null || (identifier = enumAttributeValue.getValue().getDefaultLocalizedContent(this.getIpsProject())) == null || identifier.length() <= 0) continue;
            this.enumValuesByIdentifier.put(identifier, enumValue);
        }
    }

    private IEnumValue getEnumValueForValidIdentifierAttribute(String identifierAttributeValue) {
        IEnumValue enumValue = this.enumValuesByIdentifier.get(identifierAttributeValue);
        if (enumValue != null) {
            IEnumAttributeValue enumAttributeValue = enumValue.getEnumAttributeValue(this.identifierAttribute);
            String newIdentifier = enumAttributeValue.getValue().getDefaultLocalizedContent(this.getIpsProject());
            if (Objects.equals(newIdentifier, identifierAttributeValue)) {
                return enumValue;
            }
            this.enumValuesByIdentifier.remove(identifierAttributeValue);
        }
        List aggregatedEnumValues = this.findAggregatedEnumValues();
        for (IEnumValue currentEnumValue : aggregatedEnumValues) {
            String newIdentifier;
            IEnumAttributeValue enumAttributeValue = currentEnumValue.getEnumAttributeValue(this.identifierAttribute);
            if (enumAttributeValue == null || !Objects.equals(newIdentifier = enumAttributeValue.getValue().getDefaultLocalizedContent(this.getIpsProject()), identifierAttributeValue)) continue;
            enumValue = currentEnumValue;
            for (Map.Entry<String, IEnumValue> entry : this.enumValuesByIdentifier.entrySet()) {
                if (entry.getValue() != enumValue) continue;
                this.enumValuesByIdentifier.remove(entry.getKey());
                this.enumValuesByIdentifier.put(newIdentifier, enumValue);
                break;
            }
            return enumValue;
        }
        return null;
    }

    @Override
    public IEnumValue newEnumValue() {
        final IEnumType enumType = this.findEnumType(this.getIpsProject());
        if (enumType == null) {
            return null;
        }
        return ((IpsModel)this.getIpsModel()).executeModificationsWithSingleEvent(new SingleEventModification<IEnumValue>(this.getIpsSrcFile()){
            private IEnumValue newEnumValue;

            @Override
            public boolean execute() {
                this.newEnumValue = EnumValueContainer.this.createEnumValueSingleEvent(enumType);
                return this.newEnumValue != null;
            }

            @Override
            public IEnumValue getResult() {
                return this.newEnumValue;
            }

            @Override
            public ContentChangeEvent modificationEvent() {
                return ContentChangeEvent.newPartAddedEvent(this.newEnumValue);
            }
        });
    }

    private IEnumValue createEnumValueSingleEvent(IEnumType enumType) {
        IEnumValue newEnumValue = this.newPart(EnumValue.class);
        boolean includeLiteralNames = this instanceof IEnumType;
        for (IEnumAttribute enumAttribute : enumType.getEnumAttributesIncludeSupertypeCopies(includeLiteralNames)) {
            if (enumAttribute.isEnumLiteralNameAttribute()) {
                newEnumValue.newEnumLiteralNameAttributeValue();
                continue;
            }
            newEnumValue.newEnumAttributeValue();
        }
        return newEnumValue;
    }

    @Override
    public int getEnumValuesCount() {
        return this.enumValues.size();
    }

    @Override
    public int[] moveEnumValues(final List<IEnumValue> enumValuesToMove, final boolean up) {
        ArgumentCheck.notNull(enumValuesToMove);
        final int numberToMove = enumValuesToMove.size();
        if (numberToMove == 0) {
            return new int[0];
        }
        return ((IpsModel)this.getIpsModel()).executeModificationsWithSingleEvent(new SingleEventModification<int[]>(this.getIpsSrcFile()){
            private int[] indices;
            {
                super($anonymous0);
                this.indices = new int[n];
            }

            @Override
            public boolean execute() {
                int i = 0;
                while (i < numberToMove) {
                    int index;
                    IEnumValue currentEnumValue = (IEnumValue)enumValuesToMove.get(i);
                    this.indices[i] = index = EnumValueContainer.this.getIndexOfEnumValue(currentEnumValue);
                    ++i;
                }
                this.indices = EnumValueContainer.this.enumValues.moveParts(this.indices, up);
                return true;
            }

            @Override
            public int[] getResult() {
                return this.indices;
            }
        });
    }

    @Override
    public int getIndexOfEnumValue(IEnumValue enumValue) {
        ArgumentCheck.notNull((Object)enumValue);
        return this.enumValues.indexOf(enumValue);
    }

    @Override
    public void clear() {
        this.enumValues.clear();
        this.objectHasChanged();
    }

    List<String> getUniqueIdentifierViolations(IEnumAttributeValue enumAttributeValue) {
        return this.uniqueIdentifierValidator.getUniqueIdentifierViolations(enumAttributeValue);
    }

    @Override
    public boolean deleteEnumValues(final List<IEnumValue> enumValuesToDelete) {
        if (enumValuesToDelete == null) {
            return false;
        }
        return ((IpsModel)this.getIpsModel()).executeModificationsWithSingleEvent(new SingleEventModification<Boolean>(this.getIpsSrcFile()){
            private Boolean changed;
            {
                super($anonymous0);
                this.changed = false;
            }

            @Override
            protected boolean execute() {
                for (IEnumValue currentEnumValue : enumValuesToDelete) {
                    if (!EnumValueContainer.this.enumValues.contains(currentEnumValue)) continue;
                    currentEnumValue.delete();
                    this.changed = true;
                }
                return this.changed;
            }

            @Override
            protected Boolean getResult() {
                return this.changed;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean removePartThis(IIpsObjectPart part) {
        IIpsObjectPart iIpsObjectPart;
        boolean removed = super.removePartThis(part);
        if (removed && (iIpsObjectPart = part) instanceof IEnumValue) {
            IEnumValue iEnumValue = (IEnumValue)iIpsObjectPart;
            IEnumValue cfr_ignored_0 = (IEnumValue)iIpsObjectPart;
            for (String identifier : this.enumValuesByIdentifier.keySet()) {
                void enumValue;
                IEnumValue storedEnumValue = this.enumValuesByIdentifier.get(identifier);
                if (storedEnumValue != enumValue) continue;
                this.enumValuesByIdentifier.remove(identifier);
                break;
            }
        }
        return removed;
    }

    @Override
    public void fixEnumAttributeValues(IEnumAttribute enumAttribute) {
        this.fixEnumAttributeValuesInternal(enumAttribute);
        this.objectHasChanged();
    }

    private void fixEnumAttributeValuesInternal(IEnumAttribute enumAttribute) {
        for (IEnumValue enumValue : this.enumValues) {
            this.fixEnumAttributeValue(enumAttribute, enumValue);
        }
    }

    private void fixEnumAttributeValue(IEnumAttribute enumAttribute, IEnumValue enumValue) {
        IEnumAttributeValue enumAttributeValue = enumValue.getEnumAttributeValue(enumAttribute);
        if (enumAttributeValue != null) {
            enumAttributeValue.fixValueType(enumAttribute.isMultilingual());
        }
    }

    @Override
    public void fixAllEnumAttributeValues() {
        IEnumType enumType = this.findEnumType(this.getIpsProject());
        if (enumType != null) {
            List<IEnumAttribute> enumAttributes = enumType.getEnumAttributesIncludeSupertypeCopies(false);
            for (IEnumAttribute enumAttribute : enumAttributes) {
                this.fixEnumAttributeValuesInternal(enumAttribute);
            }
        }
        this.objectHasChanged();
    }

    @Override
    public Map<String, ValueTypeMismatch> checkAllEnumAttributeValueTypeMismatch() {
        ConcurrentHashMap<String, ValueTypeMismatch> map = new ConcurrentHashMap<String, ValueTypeMismatch>(16, 0.9f, 1);
        IEnumType enumType = this.findEnumType(this.getIpsProject());
        if (enumType != null) {
            List<IEnumAttribute> enumAttributes = enumType.getEnumAttributesIncludeSupertypeCopies(false);
            for (IEnumAttribute enumAttribute : enumAttributes) {
                map.put(enumAttribute.getName(), this.checkValueTypeMismatch(enumAttribute));
            }
        }
        return map;
    }

    @Override
    public ValueTypeMismatch checkValueTypeMismatch(IEnumAttribute enumAttribute) {
        ValueTypeMismatch typeMismatch = ValueTypeMismatch.NO_MISMATCH;
        for (IEnumValue enumValue : this.enumValues) {
            IEnumAttributeValue enumAttributeValue = enumValue.getEnumAttributeValue(enumAttribute);
            if (enumAttributeValue != null && !ValueTypeMismatch.NO_MISMATCH.equals((Object)(typeMismatch = enumAttributeValue.checkValueTypeMismatch(enumAttribute)))) break;
        }
        return typeMismatch;
    }
}

